/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import jp.sourceforge.concierge.widget.ICCGCompositeCallback;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ToggleHyperlink;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class CCGComposite
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int VSPACE;
    public int clientVerticalSpacing = this.VSPACE = 0;
    public int HGAP = 0;
    public int VGAP = 0;
    private int SEPARATOR_HEIGHT = 2;
    private boolean ismodified = false;
    private boolean iseditable = false;
    private boolean expanded;
    private Control textClient;
    private Control client;
    private Control separator;
    private LinkProperty property = new LinkProperty();
    protected ToggleHyperlink toggle;
    protected Control textLabel;
    private MouseListener mouseListener;
    private ICCGCompositeCallback callback;

    protected void reflow() {
        CCGComposite c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public CCGComposite(Composite parent, int style) {
        super(parent, style);
        super.setLayout((Layout)new CCGCompositeLayout());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CCGComposite.this.onPaint(e);
            }
        });
        this.toggle = new Twistie((Composite)this, 0);
        this.toggle.traverse(16);
        this.toggle.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CCGComposite.this.toggle.traverse(16);
            }
        });
        this.toggle.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                CCGComposite.this.internalSetExpanded(!CCGComposite.this.isExpanded());
            }
        });
        this.expanded = true;
        this.toggle.setExpanded(this.expanded);
        this.textLabel = new ImageHyperlink((Composite)this, 1088);
        this.mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!CCGComposite.this.iseditable) {
                    return;
                }
                if (e.widget instanceof ImageHyperlink) {
                    if (((ImageHyperlink)e.widget).getImage() != null && e.x <= 16 && e.y <= 16) {
                        CCGComposite.this.changeImage();
                    } else {
                        CCGComposite.this.changeControl();
                    }
                }
            }
        };
        this.textLabel.addMouseListener(this.mouseListener);
        this.textLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CCGComposite.this.textLabel.traverse(16);
            }
        });
    }

    private void saveproperty(ImageHyperlink link) {
        this.property.text = link.getText();
        this.property.image = link.getImage();
        this.property.font = link.getFont();
    }

    private void restoreproperty(ImageHyperlink link) {
        link.setImage(this.property.image);
        link.setForeground(super.getForeground());
        link.setBackground(super.getBackground());
        link.setFont(this.property.font);
        this.property.image = null;
        this.property.font = null;
    }

    private void changeImage() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        String[] filter = new String[]{"*.jpg", "*.gif", "*.bmp", "*.png"};
        fd.setFilterPath(System.getProperty("user.home"));
        fd.setFilterExtensions(filter);
        fd.setFilterNames(filter);
        fd.setText("Set icon");
        String path = fd.open();
        if (path == null) {
            return;
        }
        Image newimg = new Image((Device)this.getDisplay(), path);
        if (newimg == null) {
            return;
        }
        Rectangle r = newimg.getBounds();
        if (r.width > 16 || r.height > 16) {
            newimg.dispose();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Error", (String)"Image size have to be less than 16x16.");
            return;
        }
        if (this.callback != null && !this.callback.imageModify(path)) {
            return;
        }
        this.ismodified = true;
        ((ImageHyperlink)this.textLabel).setImage(newimg);
        this.layout();
    }

    private void setHyperlinkToLabel() {
        if (this.textLabel instanceof Hyperlink) {
            return;
        }
        String txt = ((Text)this.textLabel).getText();
        if (txt.trim().length() == 0) {
            return;
        }
        boolean bl = this.ismodified = txt.compareTo(this.property.text) != 0;
        if (this.ismodified && !this.callback.textModify(txt)) {
            return;
        }
        this.textLabel.dispose();
        this.textLabel = new ImageHyperlink((Composite)this, 1088);
        ((ImageHyperlink)this.textLabel).setText(txt);
        this.restoreproperty((ImageHyperlink)this.textLabel);
        this.textLabel.addMouseListener(this.mouseListener);
        this.layout();
        this.textLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CCGComposite.this.textLabel.traverse(16);
            }
        });
    }

    private void setTextToLabel() {
        if (this.textLabel instanceof Text) {
            return;
        }
        String txt = ((ImageHyperlink)this.textLabel).getText();
        this.saveproperty((ImageHyperlink)this.textLabel);
        this.textLabel.dispose();
        this.textLabel = new Text((Composite)this, 2052);
        ((Text)this.textLabel).setFont(this.property.font);
        ((Text)this.textLabel).setText(txt);
        this.textLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CCGComposite.this.changeControl();
            }
        });
        ((Text)this.textLabel).addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    CCGComposite.this.changeControl();
                }
            }
        });
        this.textLabel.addMouseListener(this.mouseListener);
        this.layout();
        this.textLabel.setFocus();
        ((Text)this.textLabel).selectAll();
    }

    private void changeControl() {
        if (this.textLabel instanceof Text) {
            this.setHyperlinkToLabel();
        } else {
            this.setTextToLabel();
        }
    }

    public final void setLayout(Layout layout) {
    }

    public void resetLabel() {
        this.setHyperlinkToLabel();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.textLabel instanceof Hyperlink) {
            this.textLabel.setBackground(bg);
        }
        this.toggle.setBackground(bg);
        if (this.textClient != null) {
            this.textClient.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.textLabel instanceof Hyperlink) {
            this.textLabel.setForeground(fg);
        }
        this.toggle.setForeground(fg);
        if (this.textClient != null) {
            this.textClient.setForeground(fg);
        }
    }

    public void setToggleColor(Color c) {
        this.toggle.setDecorationColor(c);
    }

    public void setActiveToggleColor(Color c) {
        this.toggle.setHoverDecorationColor(c);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textLabel.setFont(font);
        this.toggle.setFont(font);
    }

    public void setClient(Control client) {
        if (client == null || !client.getParent().equals((Object)this)) {
            return;
        }
        this.client = client;
    }

    public Control getClient() {
        return this.client;
    }

    public void setText(String title) {
        if (this.textLabel instanceof Text) {
            ((Text)this.textLabel).setText(title);
        } else {
            ((ImageHyperlink)this.textLabel).setText(title);
        }
    }

    public String getText() {
        if (this.textLabel instanceof Text) {
            return ((Text)this.textLabel).getText();
        }
        return ((Hyperlink)this.textLabel).getText();
    }

    public void setImage(Image image) {
        if (!(this.textLabel instanceof ImageHyperlink)) {
            if (this.property.image != null) {
                this.property.image.dispose();
            }
            this.property.image = image;
        } else {
            ((ImageHyperlink)this.textLabel).setImage(image);
            this.textLabel.pack();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.internalSetExpanded(expanded);
        this.toggle.setExpanded(expanded);
    }

    protected void internalSetExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        if (this.client != null) {
            this.client.setVisible(expanded);
        }
        this.layout();
        this.reflow();
    }

    protected void onPaint(PaintEvent e) {
    }

    protected Control getDescriptionControl() {
        return null;
    }

    protected Control getSeparatorControl() {
        return this.separator;
    }

    public void setSeparatorControl(Control separator) {
        if (separator == null || !separator.getParent().equals((Object)this)) {
            return;
        }
        if (this.separator != null) {
            this.separator.dispose();
        }
        this.separator = separator;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        CCGCompositeLayout layout = (CCGCompositeLayout)this.getLayout();
        Point size = wHint == -1 || hHint == -1 ? layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected boolean isFixedStyle() {
        return false;
    }

    public Control getTextClient() {
        return this.textClient;
    }

    public void setTextClient(Control tclient) {
        if (tclient == null || !tclient.getParent().equals((Object)this)) {
            return;
        }
        if (this.textClient != null) {
            this.textClient.dispose();
        }
        this.textClient = tclient;
    }

    public Control getTextLabel() {
        return this.textLabel;
    }

    public boolean isModified() {
        return this.ismodified;
    }

    public void setModified(boolean modified) {
        this.ismodified = modified;
    }

    public void setEditable() {
        this.iseditable = true;
    }

    public void setCallback(ICCGCompositeCallback cb) {
        this.callback = cb;
    }

    private class LinkProperty {
        public String text;
        public Image image;
        public Font font;

        private LinkProperty() {
        }
    }

    private class CCGCompositeLayout
    extends Layout
    implements ILayoutExtension {
        private CCGCompositeLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Point tcsize;
            Rectangle carea = parent.getClientArea();
            int thmargin = CCGComposite.this.HGAP;
            int tvmargin = CCGComposite.this.VGAP;
            int x = CCGComposite.this.marginWidth + thmargin;
            int y = CCGComposite.this.marginHeight + tvmargin;
            Point dtgsize = CCGComposite.this.toggle.computeSize(-1, -1, changed);
            Point dtlsize = CCGComposite.this.textLabel.computeSize(-1, -1, changed);
            Point dtcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, -1, changed) : null;
            int tlwidth = carea.width - 2 * x - dtgsize.x - CCGComposite.this.HGAP - (dtcsize != null ? dtcsize.x + CCGComposite.this.HGAP : 0);
            Point tgsize = dtgsize;
            Point tlsize = CCGComposite.this.textLabel.computeSize(tlwidth, -1, changed);
            Point point = tcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, tlsize.y, changed) : null;
            if (dtlsize.y == tlsize.y) {
                tlsize.x = Math.min(dtlsize.x, tlsize.x);
            }
            GC gc = new GC((Drawable)CCGComposite.this);
            gc.setFont(CCGComposite.this.getFont());
            FontMetrics fm = gc.getFontMetrics();
            int fontHeight = fm.getHeight();
            gc.dispose();
            int tgy = Math.max(fontHeight / 2 - tgsize.y / 2 + 1, 0) + CCGComposite.this.marginHeight + tvmargin;
            CCGComposite.this.toggle.setLocation(x, tgy);
            CCGComposite.this.toggle.setSize(tgsize);
            CCGComposite.this.textLabel.setBounds(x += tgsize.x + CCGComposite.this.HGAP, y, tlsize.x, tlsize.y);
            if (CCGComposite.this.textClient != null) {
                int tcx = carea.width - tcsize.x - thmargin;
                CCGComposite.this.textClient.setBounds(tcx, y, tcsize.x, tcsize.y);
            }
            y += tlsize.y + tvmargin;
            if (CCGComposite.this.getSeparatorControl() != null) {
                CCGComposite.this.getSeparatorControl().setBounds(CCGComposite.this.marginWidth, y += CCGComposite.this.VSPACE, carea.width - 2 * CCGComposite.this.marginWidth, CCGComposite.this.SEPARATOR_HEIGHT);
                y += CCGComposite.this.SEPARATOR_HEIGHT;
                if (CCGComposite.this.expanded) {
                    y += CCGComposite.this.VSPACE;
                }
            }
            if (CCGComposite.this.expanded && CCGComposite.this.client != null) {
                int cx = CCGComposite.this.marginWidth + thmargin;
                int areaw = carea.width - 2 * cx;
                int cwidth = areaw;
                int cheight = carea.height - 2 * CCGComposite.this.marginHeight - (y += CCGComposite.this.clientVerticalSpacing - CCGComposite.this.VSPACE);
                CCGComposite.this.client.setBounds(cx, y, cwidth, cheight);
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Point tcsize;
            Point dtcsize;
            int width = 0;
            int height = 0;
            int thmargin = CCGComposite.this.HGAP;
            int tvmargin = CCGComposite.this.VGAP;
            Point dtgsize = CCGComposite.this.toggle.computeSize(-1, -1, changed);
            Point dtlsize = CCGComposite.this.textLabel.computeSize(-1, -1, changed);
            Point point = dtcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, -1, changed) : null;
            int tlwidth = wHint == -1 ? -1 : wHint - dtgsize.x - CCGComposite.this.HGAP - (dtcsize != null ? dtcsize.x + CCGComposite.this.HGAP : 0);
            Point tgsize = dtgsize;
            Point tlsize = CCGComposite.this.textLabel.computeSize(tlwidth, -1, changed);
            Point point2 = tcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, tlsize.y, changed) : null;
            if (dtlsize.y == tlsize.y) {
                tlsize.x = Math.min(dtlsize.x, tlsize.x);
            }
            width = tlsize.x;
            int sizey = tlsize.y;
            int n = height = tcsize != null ? Math.max(tcsize.y, sizey) : sizey;
            if (CCGComposite.this.getSeparatorControl() != null) {
                height += CCGComposite.this.VSPACE + CCGComposite.this.SEPARATOR_HEIGHT;
                if (CCGComposite.this.expanded && CCGComposite.this.client != null) {
                    height += CCGComposite.this.VSPACE;
                }
            }
            height += CCGComposite.this.VSPACE;
            if (CCGComposite.this.expanded && CCGComposite.this.client != null) {
                int cwHint = wHint == -1 ? wHint : wHint - 2 * tvmargin;
                Point csize = CCGComposite.this.client.computeSize(FormUtil.getWidthHint((int)cwHint, (Control)CCGComposite.this.client), -1, changed);
                height += CCGComposite.this.clientVerticalSpacing - CCGComposite.this.VSPACE;
                width = Math.max(width, csize.x);
                if (CCGComposite.this.expanded) {
                    height += csize.y;
                }
            }
            height = height - sizey + Math.max(sizey, tlsize.y);
            return new Point((width += tgsize.x + CCGComposite.this.HGAP) + 2 * CCGComposite.this.marginWidth + 2 * thmargin + thmargin, height + 2 * CCGComposite.this.marginHeight + 2 * tvmargin);
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            int width = 0;
            Point size = CCGComposite.this.textLabel.computeSize(5, -1, changed);
            Point tcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, -1, changed) : null;
            int thmargin = CCGComposite.this.HGAP;
            width = size.x;
            if (tcsize != null) {
                width += CCGComposite.this.HGAP + tcsize.x;
            }
            if (CCGComposite.this.expanded && CCGComposite.this.client != null) {
                int cwidth = FormUtil.computeMinimumWidth((Control)CCGComposite.this.client, (boolean)changed);
                width = Math.max(width, cwidth);
            }
            Point tsize = CCGComposite.this.toggle.computeSize(-1, -1, changed);
            return (width += tsize.x + CCGComposite.this.HGAP) + 2 * CCGComposite.this.marginWidth + 2 * thmargin;
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            int width = 0;
            Point size = CCGComposite.this.textLabel.computeSize(-1, -1, changed);
            int thmargin = CCGComposite.this.HGAP;
            width = size.x;
            Point tcsize = CCGComposite.this.textClient != null ? CCGComposite.this.textClient.computeSize(-1, -1, changed) : null;
            width += CCGComposite.this.HGAP + tcsize.x;
            if (CCGComposite.this.expanded && CCGComposite.this.client != null) {
                int cwidth = FormUtil.computeMaximumWidth((Control)CCGComposite.this.client, (boolean)changed);
                width = Math.max(width, cwidth);
            }
            Point tsize = CCGComposite.this.toggle.computeSize(-1, -1, changed);
            return (width += tsize.x + CCGComposite.this.HGAP) + 2 * CCGComposite.this.marginWidth + 2 * thmargin;
        }
    }
}

