/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciergeAdapter {
    public static final String TYPEDOCNAME = "Paper";
    public static final String REQUIRED_PARSERS = "text, authors, keywords, identifiers";

    public static boolean isReady(Object sender) {
        String[] request = REQUIRED_PARSERS.split(",");
        ArrayList fact = FrameworkPlugin.getAllParserTypes();
        int i = 0;
        while (i < request.length) {
            if (!fact.contains(request[i].trim())) {
                return false;
            }
            ++i;
        }
        Request rq = new Request(4, (Object)"/type[@name='Paper']", "type");
        ArrayList types = FrameworkPlugin.getDefault().getDocumentsOfQuery(rq);
        if (types.size() == 0) {
            Document tdoc = TypeDomImpl.createDocument((String)TYPEDOCNAME);
            TypeDomImpl.setImage((Document)tdoc, (String)IPapersPlugin.getPluginFilePath("icons/pubmed.png"));
            TypeDomImpl.appendElement((Document)tdoc, (String)"Author", (String)"authors", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Title", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Journal", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Volume", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Number", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Pages", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Year", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Abstract", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"IDs", (String)"identifiers", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Comment", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.setPluginID((Document)tdoc, (String)IPapersPlugin.getDefault().getBundle().getSymbolicName());
            rq = new Request(1, (Object)tdoc, "type");
            ArrayList<Request> rqs = new ArrayList<Request>();
            rqs.add(rq);
            FrameworkPlugin.getDefault().updateDocuments(rqs, sender);
        }
        return true;
    }

    public static boolean saveArticle(PaperInfo info, Object sender) {
        String xpath = "/type[@name='Paper']";
        Request request = new Request(4, (Object)xpath, "type");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        boolean response = false;
        if (ret.size() > 0) {
            Document typedoc = (Document)ret.get(0);
            Document datadoc = DataDomImpl.createDocument((Document)typedoc);
            ConciergeAdapter.setArticleInfo(datadoc, typedoc, info, sender);
            Shell shell = IPapersPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            ConciergeDialog cd = IPapersPlugin.getDefault().getDialog(shell, 0);
            cd.setDocument(datadoc, sender);
            cd.open();
            response = true;
        }
        return response;
    }

    private static void setArticleInfo(Document datadoc, Document typedoc, PaperInfo info, Object sender) {
        String path = info.getFilepath();
        DataDomImpl.setFilePath((Document)datadoc, (String)path);
        Element data = DataDomImpl.getElement((Document)datadoc, (String)"Author");
        DataDomImpl.setElementContent((Element)data, (String)info.getAuthor());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Title");
        DataDomImpl.setElementContent((Element)data, (String)info.getTitle());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Journal");
        DataDomImpl.setElementContent((Element)data, (String)info.getJournal());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Volume");
        DataDomImpl.setElementContent((Element)data, (String)info.getVolume());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Number");
        DataDomImpl.setElementContent((Element)data, (String)info.getIssue());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Pages");
        DataDomImpl.setElementContent((Element)data, (String)info.getPages());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Year");
        DataDomImpl.setElementContent((Element)data, (String)info.getYear());
        data = DataDomImpl.getElement((Document)datadoc, (String)"Abstract");
        DataDomImpl.setElementContent((Element)data, (String)info.getAbstract());
        data = DataDomImpl.getElement((Document)datadoc, (String)"IDs");
        DataDomImpl.setElementContent((Element)data, (String)info.getFormattedIDs());
    }

    public static Set<String> authorsInConcierge() {
        Request request = new Request(4, (Object)"/data[@name='Paper']/Author", "data");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        TreeSet<String> authors = new TreeSet<String>();
        for (Document doc : ret) {
            Element author = DataDomImpl.getElement((Document)doc, (String)"Author");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParserPlugin((String)paserName).createInstance();
            authors.addAll(parser.getIndexes(author));
        }
        return authors;
    }

    public static Set<String> journalInConcierge() {
        Request request = new Request(4, (Object)"/data[@name='Paper']/Journal", "data");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        TreeSet<String> journals = new TreeSet<String>();
        for (Document doc : ret) {
            Element author = DataDomImpl.getElement((Document)doc, (String)"Journal");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParserPlugin((String)paserName).createInstance();
            journals.addAll(parser.getIndexes(author));
        }
        return journals;
    }

    public static Set<String> keywordsInConcierge() {
        Request request = new Request(4, (Object)"/data[@name='Paper']/Keywords", "data");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        TreeSet<String> keywords = new TreeSet<String>();
        for (Document doc : ret) {
            Element author = DataDomImpl.getElement((Document)doc, (String)"Keywords");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParserPlugin((String)paserName).createInstance();
            keywords.addAll(parser.getIndexes(author));
        }
        return keywords;
    }

    public static ArrayList<Paper> papersBindToKeyword(String keyword) {
        String xpath = "/data[@name='Paper']/Keywords[contains(translate(., 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + keyword.toLowerCase() + "')]";
        Request request = new Request(4, (Object)xpath, "data");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        ArrayList<Paper> papers = new ArrayList<Paper>();
        block0: for (Document doc : ret) {
            ArticleInfo info = new ArticleInfo();
            Element element = DataDomImpl.getElement((Document)doc, (String)"Author");
            ArrayList data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)element)).createInstance().getIndexes(element);
            if (data.size() > 0) {
                info.setAuthor((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Abstract")))).createInstance().getIndexes(element)).size() > 0) {
                info.setAbstract((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Journal")))).createInstance().getIndexes(element)).size() > 0) {
                info.setJournal((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Year")))).createInstance().getIndexes(element)).size() > 0) {
                info.setYear((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Volume")))).createInstance().getIndexes(element)).size() > 0) {
                info.setVolume((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Number")))).createInstance().getIndexes(element)).size() > 0) {
                info.setIssue((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Pages")))).createInstance().getIndexes(element)).size() > 0) {
                info.setPages((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Document)doc, (String)"Title")))).createInstance().getIndexes(element)).size() > 0) {
                info.setTitle((String)data.get(0));
            }
            element = DataDomImpl.getElement((Document)doc, (String)"IDs");
            ArrayList ids = FrameworkPlugin.getParserPlugin((String)DataDomImpl.getParserName((Element)element)).createInstance().getIndexes(element);
            Pattern pattern = Pattern.compile("pubmed:=(\\d+)");
            for (String id : ids) {
                Matcher matcher = pattern.matcher(id);
                if (!matcher.find(0)) continue;
                String pmid = matcher.group(1);
                String idtype = PubMedCore.IDTYPE;
                Paper newPaper = new Paper(pmid, idtype, info);
                papers.add(newPaper);
                continue block0;
            }
        }
        return papers;
    }

    public static Boolean hasPapers(String id, String idtype) {
        String xpath = "/data[@name='Paper']/IDs[contains(translate(., 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + id.toLowerCase() + "')]";
        Request request = new Request(4, (Object)xpath, "data");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        Boolean result = false;
        if (ret.size() > 0) {
            result = true;
        }
        return result;
    }
}

