/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import jp.ac.suzuka_ct.www.info.lab.aoyama.articleComment.ArticleComment;
import jp.ac.suzuka_ct.www.info.lab.aoyama.articleComment.CommentManagerBindingStub;
import jp.ac.suzuka_ct.www.info.lab.aoyama.articleComment.CommentManagerLocator;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.CannotGuessIdtypeException;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperFactory;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.FileLauncher;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDialog
extends ConciergeDialog {
    private static final int VMARGIN = 5;
    private static final int HMARGIN = 2;
    private static final int HEIGHT = 15;
    private static final int FIRSTWIDTH = 55;
    private static final int SECONDWIDTH = 65;
    private static final String DIALOGTITLE = "Metadata Editor for iPapers";
    private Document schema = null;
    private Document metadata = null;
    private Hashtable<String, Text> texthash = null;
    private Object sender = null;
    private Shell myshell = null;
    private boolean ismodified = false;

    public MetadataDialog(Shell shell, int style) {
        super(shell, 67680);
        String xpath = "/type[@name='Paper']";
        Request request = new Request(4, (Object)xpath, "type");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        if (ret.size() > 0) {
            this.schema = (Document)ret.get(0);
        }
        this.texthash = new Hashtable();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.metadata = null;
        this.texthash = null;
        this.sender = null;
        this.ismodified = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Group rig = new Group(dialog, 64);
        rig.setText("Reference Info");
        rig.setLayoutData((Object)new GridData(768));
        rig.setLayout((Layout)new FormLayout());
        Label lblAuthor = new Label((Composite)rig, 0);
        lblAuthor.setText("Author");
        lblAuthor.setAlignment(131072);
        FormData fdr = new FormData();
        fdr.top = new FormAttachment(0, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAuthor.setLayoutData((Object)fdr);
        Text txtAuthor = new Text((Composite)rig, 2052);
        FormData fdl = new FormData();
        fdl.top = new FormAttachment(0, 5);
        fdl.left = new FormAttachment((Control)lblAuthor, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtAuthor.setLayoutData((Object)fdl);
        this.texthash.put("Author", txtAuthor);
        Label lblTitle = new Label((Composite)rig, 0);
        lblTitle.setText("Title");
        lblTitle.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtAuthor, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblTitle.setLayoutData((Object)fdr);
        Text txtTitle = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtAuthor, 5);
        fdl.left = new FormAttachment((Control)lblTitle, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtTitle.setLayoutData((Object)fdl);
        this.texthash.put("Title", txtTitle);
        Label lblJournal = new Label((Composite)rig, 0);
        lblJournal.setText("Journal");
        lblJournal.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblJournal.setLayoutData((Object)fdr);
        Text txtJournal = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblJournal, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtJournal.setLayoutData((Object)fdl);
        this.texthash.put("Journal", txtJournal);
        Label lblYear = new Label((Composite)rig, 0);
        lblYear.setText("Year");
        lblYear.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment((Control)txtJournal, 5);
        fdr.height = 15;
        lblYear.setLayoutData((Object)fdr);
        Text txtYear = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblYear, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtYear.setLayoutData((Object)fdl);
        this.texthash.put("Year", txtYear);
        Label lblVolume = new Label((Composite)rig, 0);
        lblVolume.setText("Vol");
        lblVolume.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblVolume.setLayoutData((Object)fdr);
        Text txtVolume = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblVolume, 2);
        fdl.right = new FormAttachment(33, -5);
        fdl.height = 15;
        txtVolume.setLayoutData((Object)fdl);
        this.texthash.put("Volume", txtVolume);
        Label lblNumber = new Label((Composite)rig, 0);
        lblNumber.setText("No");
        lblNumber.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtVolume, 5);
        fdr.height = 15;
        lblNumber.setLayoutData((Object)fdr);
        Text txtNumber = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblNumber, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtNumber.setLayoutData((Object)fdl);
        this.texthash.put("Number", txtNumber);
        Label lblPages = new Label((Composite)rig, 0);
        lblPages.setText("Pages");
        lblPages.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtNumber, 5);
        fdr.height = 15;
        lblPages.setLayoutData((Object)fdr);
        Text txtPages = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblPages, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtPages.setLayoutData((Object)fdl);
        this.texthash.put("Pages", txtPages);
        Label lblIDs = new Label((Composite)rig, 0);
        lblIDs.setText("IDs");
        lblIDs.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtVolume, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblIDs.setLayoutData((Object)fdr);
        Text txtIDs = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtVolume, 5);
        fdl.left = new FormAttachment((Control)lblIDs, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtIDs.setLayoutData((Object)fdl);
        this.texthash.put("IDs", txtIDs);
        Label lblAbstract = new Label((Composite)rig, 0);
        lblAbstract.setText("Abstract");
        lblAbstract.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtIDs, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAbstract.setLayoutData((Object)fdr);
        Text txtAbstract = new Text((Composite)rig, 578);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtIDs, 5);
        fdl.left = new FormAttachment((Control)lblAbstract, 5);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 90;
        txtAbstract.setLayoutData((Object)fdl);
        this.texthash.put("Abstract", txtAbstract);
        Group aig = new Group(dialog, 64);
        aig.setText("Additional Info");
        aig.setLayoutData((Object)new GridData(768));
        aig.setLayout((Layout)new FormLayout());
        Label lblKeywords = new Label((Composite)aig, 0);
        lblKeywords.setText("Keywords");
        lblKeywords.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment(0, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 65);
        fdr.height = 15;
        lblKeywords.setLayoutData((Object)fdr);
        Text txtKeywords = new Text((Composite)aig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 5);
        fdl.left = new FormAttachment((Control)lblKeywords, 2);
        fdl.right = new FormAttachment(100, 0);
        fdl.height = 15;
        txtKeywords.setLayoutData((Object)fdl);
        this.texthash.put("Keywords", txtKeywords);
        Label lblComment = new Label((Composite)aig, 0);
        lblComment.setText("Comment");
        lblComment.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtKeywords, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 65);
        fdr.height = 15;
        lblComment.setLayoutData((Object)fdr);
        Text txtComment = new Text((Composite)aig, 578);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtKeywords, 5);
        fdl.left = new FormAttachment((Control)lblComment, 5);
        fdl.right = new FormAttachment(100, -5);
        fdl.bottom = new FormAttachment(100, -5);
        fdl.height = 90;
        txtComment.setLayoutData((Object)fdl);
        this.texthash.put("Comment", txtComment);
        Button commentSubmit = new Button((Composite)aig, 0);
        commentSubmit.setText("Submit");
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)lblComment, 0);
        fdr.left = new FormAttachment(0, 0);
        commentSubmit.setLayoutData((Object)fdr);
        commentSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetadataDialog.this.submitCommentToCommentServer(parent);
            }
        });
        Group lig = new Group(dialog, 16);
        lig.setText("PDF Reprint File");
        lig.setLayoutData((Object)new GridData(768));
        lig.setLayout((Layout)new FormLayout());
        Button btnOpen = new Button((Composite)lig, 4096);
        btnOpen.setText("Open");
        btnOpen.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                FileLauncher.LaunchFile((Document)MetadataDialog.this.metadata);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 8);
        fdl.left = new FormAttachment(50, -150);
        fdl.right = new FormAttachment(50, -15);
        fdl.bottom = new FormAttachment(100, -8);
        btnOpen.setLayoutData((Object)fdl);
        Button btnPath = new Button((Composite)lig, 4096);
        btnPath.setText("Change");
        btnPath.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                FileDialog dialog = new FileDialog(MetadataDialog.this.myshell, 4096);
                String path = dialog.open();
                DataDomImpl.setFilePath((Document)MetadataDialog.this.metadata, (String)path);
                MetadataDialog.this.ismodified = true;
                MetadataDialog.this.updateTitle();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 8);
        fdl.left = new FormAttachment(50, 15);
        fdl.right = new FormAttachment(50, 150);
        fdl.bottom = new FormAttachment(100, -8);
        btnPath.setLayoutData((Object)fdl);
        this.updateDocument();
        this.updateTitle();
        return dialog;
    }

    protected void initializeBounds() {
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(500, size.y);
    }

    protected void configureShell(Shell myshell) {
        super.configureShell(myshell);
        this.myshell = myshell;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 64, "Close", false);
        this.createButton(parent, 8192, "Save", true);
    }

    protected void buttonPressed(int button) {
        this.setReturnCode(1);
        if (button == 8192) {
            this.saveDocument();
            this.close();
        } else if (button == 64) {
            if (this.ismodified) {
                MessageBox box = new MessageBox(this.myshell, 200);
                box.setMessage("The metadata was modified. Save before leaving?");
                int ret = box.open();
                if (ret == 64) {
                    this.saveDocument();
                    this.close();
                } else if (ret == 128) {
                    this.close();
                }
            } else {
                this.close();
            }
        }
    }

    public void setDocument(Document metadata, Object sender) {
        this.sender = sender;
        if (metadata == null) {
            this.metadata = DataDomImpl.createDocument((Document)this.schema);
            this.ismodified = false;
        } else {
            this.metadata = metadata;
            this.ismodified = sender == IPapersPlugin.getDefault().getBundle().getSymbolicName();
        }
        String filepath = DataDomImpl.getFilePath((Document)this.metadata);
        if (filepath != null && filepath.length() > 0) {
            try {
                this.searchIDandCreatePaper(filepath, this.metadata);
                this.ismodified = true;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void saveDocument() {
        ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)this.metadata);
        int i = 0;
        while (i < metas.size()) {
            Element schm;
            String pname;
            IParserPlugin pp;
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Text text = this.texthash.get(tname);
            if (text != null && (pp = FrameworkPlugin.getParserPlugin((String)(pname = TypeDomImpl.getParser((Element)(schm = TypeDomImpl.getElement((Document)this.schema, (String)tname)))))) != null) {
                try {
                    ITypeParser parser = pp.createInstance();
                    if (parser != null) {
                        parser.addToElement(meta, text.getText());
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request(3, (Object)this.metadata, "data");
        reqs.add(req);
        FrameworkPlugin.getDefault().updateDocuments(reqs, this.sender);
        this.setReturnCode(0);
    }

    private void updateDocument() {
        ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)this.metadata);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
            String pname = TypeDomImpl.getParser((Element)schm);
            Text txt = this.texthash.get(tname);
            if (txt != null) {
                IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)pname);
                if (pp != null) {
                    try {
                        ITypeParser parser = pp.createInstance();
                        if (parser != null) {
                            String cntnt = parser.getViewForm(meta);
                            txt.setText(cntnt);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
                txt.addModifyListener((ModifyListener)new TextListener());
            }
            ++i;
        }
    }

    private void updateTitle() {
        if (this.myshell != null) {
            if (this.ismodified) {
                this.myshell.setText("Metadata Editor for iPapers*");
            } else {
                this.myshell.setText(DIALOGTITLE);
            }
        }
    }

    private void searchIDandCreatePaper(String filepath, Document metadata) {
        try {
            Paper paper = PaperFactory.getInstance().create(filepath);
            Hashtable<String, String> items = paper.toHashtable();
            ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)metadata);
            int i = 0;
            while (i < metas.size()) {
                String value;
                ITypeParser parser;
                Element meta = (Element)metas.get(i);
                String tname = DataDomImpl.getTagName((Element)meta);
                Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
                String pname = TypeDomImpl.getParser((Element)schm);
                IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)pname);
                if (pp != null && (parser = pp.createInstance()) != null && (value = items.get(tname)) != null && value.length() > 0) {
                    parser.addToElement(meta, value);
                }
                ++i;
            }
        }
        catch (CannotGuessIdtypeException cannotGuessIdtypeException) {
            return;
        }
        catch (CannotGetPaperInfoException cannotGetPaperInfoException) {
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    private Hashtable<String, String> toHashtable(Document metadatadoc, Document metadataschema) {
        Hashtable<String, String> items = new Hashtable<String, String>();
        ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)metadatadoc);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Element schm = TypeDomImpl.getElement((Document)metadataschema, (String)tname);
            String pname = TypeDomImpl.getParser((Element)schm);
            IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)pname);
            if (pp != null) {
                try {
                    ITypeParser parser = pp.createInstance();
                    if (parser != null) {
                        String cntnt = parser.getViewForm(meta);
                        items.put(tname, cntnt);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        return items;
    }

    private void submitCommentToCommentServer(Composite parent) {
        Hashtable<String, String> items = this.toHashtable(this.metadata, this.schema);
        String ids = items.get("IDs");
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> idtypeList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([a-zA-Z]+):=([a-zA-Z0-9/\\.]+)");
        Matcher matcher = pattern.matcher(ids);
        while (matcher.find()) {
            idList.add(matcher.group(2));
            idtypeList.add(matcher.group(1));
            if (ids.length() <= matcher.group(1).length() + matcher.group(2).length() + 2 + 1) continue;
            ids = ids.substring(matcher.end() + 1, ids.length());
            matcher = pattern.matcher(ids);
        }
        String pmid = null;
        int i = 0;
        while (i < idList.size()) {
            if (((String)idtypeList.get(i)).equals(PubMedCore.IDTYPE) || ((String)idtypeList.get(i)).equals(PubMedCore.IDTYPE.toLowerCase())) {
                pmid = (String)idList.get(i);
                break;
            }
            ++i;
        }
        try {
            if (pmid != null) {
                CommentManagerLocator service = new CommentManagerLocator();
                CommentManagerBindingStub stub = (CommentManagerBindingStub)service.getcommentManagerPort();
                ArticleComment submitComment = new ArticleComment();
                submitComment.setId(pmid);
                submitComment.setIdtype("pubmed");
                submitComment.setHost("concierge");
                submitComment.setTitle("concierge");
                submitComment.setExcerpt(items.get("Comment"));
                submitComment.setUrl("concierge");
                submitComment.setBlog_name("concierge");
                submitComment.setComment(items.get("Comment"));
                submitComment.setNumGood(0);
                submitComment.setNumBad(0);
                submitComment.setTimestamp("2007-10-11");
                submitComment.setCommitTime("2007-10-11");
                stub.commitArticleComment(submitComment);
            }
        }
        catch (ServiceException e) {
            System.err.println(e.getMessage());
        }
        catch (RemoteException e) {
            System.err.println(e.getMessage());
        }
    }

    class TextListener
    implements ModifyListener {
        TextListener() {
        }

        public void modifyText(ModifyEvent e) {
            MetadataDialog.this.ismodified = true;
            MetadataDialog.this.updateTitle();
        }
    }
}

