/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceLocator;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceSoap;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.ArticleIdType_pubmed;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.AuthorListType;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.AuthorType_nlmc;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.EFetchRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.EFetchResult;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch.MedlineCitationType;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchResult;
import gov.nih.nlm.ncbi.www.soap.eutils.esummary.ESummaryRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esummary.ESummaryResult;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.ConciergeAdapter;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoGetter;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.NoSearchResultsFoundException;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubMedCore
extends PaperInfoGetter {
    private ESearchResult searchResult = null;
    public static String IDTYPE = "pubmed";

    public PubMedCore() {
        super(IDTYPE);
    }

    public ArrayList<String> search(String query) throws Exception {
        try {
            EUtilsServiceLocator service = new EUtilsServiceLocator();
            EUtilsServiceSoap utils = service.geteUtilsServiceSoap();
            IPreferenceStore store = IPapersPlugin.getDefault().getPreferenceStore();
            ESearchRequest parameters = new ESearchRequest();
            StringBuffer searchquery = new StringBuffer(query);
            searchquery.append(" AND (");
            if (store.getBoolean("English")) {
                searchquery.append(" OR English[language]");
            }
            if (store.getBoolean("French")) {
                searchquery.append(" OR French[language]");
            }
            if (store.getBoolean("German")) {
                searchquery.append(" OR German[language]");
            }
            if (store.getBoolean("Italian")) {
                searchquery.append(" OR Italian[language]");
            }
            if (store.getBoolean("Japanese")) {
                searchquery.append(" OR Japanese[language]");
            }
            if (store.getBoolean("Russian")) {
                searchquery.append(" OR Russian[language]");
            }
            if (store.getBoolean("Spanish")) {
                searchquery.append(" OR Spanish[language]");
            }
            searchquery.append(")");
            Pattern pattern = Pattern.compile(" AND [(] OR");
            Matcher matcher = pattern.matcher(searchquery.toString());
            query = matcher.replaceFirst(" AND (");
            if (IPapersPlugin.log.isDebugEnabled()) {
                IPapersPlugin.log.debug((Object)query);
            }
            parameters.setDb("pubmed");
            parameters.setTerm(URLEncoder.encode(query, "UTF-8"));
            parameters.setRetMax(store.getString("maximul retrieved"));
            this.searchResult = utils.run_eSearch(parameters);
            if (this.searchResult.getIdList().getId() != null) {
                ArrayList<String> result = new ArrayList<String>();
                int i = 0;
                while (i < this.searchResult.getIdList().getId().length) {
                    result.add(this.searchResult.getIdList().getId()[i]);
                    ++i;
                }
                return result;
            }
            throw new NoSearchResultsFoundException("IDTYPE");
        }
        catch (RemoteException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
            throw e;
        }
        catch (ServiceException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public PaperInfo fetchInfo(String id) throws CannotGetPaperInfoException {
        if (IPapersPlugin.log.isInfoEnabled()) {
            IPapersPlugin.log.debug((Object)"fetch from PubMed");
        }
        try {
            EUtilsServiceLocator service = new EUtilsServiceLocator();
            EUtilsServiceSoap utils = service.geteUtilsServiceSoap();
            EFetchRequest parameters = new EFetchRequest();
            parameters.setDb("pubmed");
            parameters.setId(id);
            EFetchResult res = utils.run_eFetch(parameters);
            ArticleInfo info = new ArticleInfo();
            MedlineCitationType articleInfo = res.getPubmedArticleSet().getPubmedArticle()[0].getMedlineCitation();
            if (articleInfo.getArticle().getAuthorList() != null) {
                info.setAuthor(this.getAuthorString(articleInfo.getArticle().getAuthorList()));
            }
            if (articleInfo.getArticle().getArticleTitle() != null) {
                info.setTitle(articleInfo.getArticle().getArticleTitle());
            }
            if (articleInfo.getMedlineJournalInfo().getMedlineTA() != null) {
                info.setJournal(articleInfo.getMedlineJournalInfo().getMedlineTA());
            }
            if (articleInfo.getArticle().getJournal().getJournalIssue().getVolume() != null) {
                info.setVolume(articleInfo.getArticle().getJournal().getJournalIssue().getVolume());
            }
            if (articleInfo.getArticle().getJournal().getJournalIssue().getPubDate().getYear() != null) {
                info.setYear(articleInfo.getArticle().getJournal().getJournalIssue().getPubDate().getYear());
            }
            if (articleInfo.getArticle().getJournal().getJournalIssue().getIssue() != null) {
                info.setIssue(articleInfo.getArticle().getJournal().getJournalIssue().getIssue());
            }
            if (articleInfo.getArticle().getPagination().getMedlinePgn() != null) {
                info.setPages(articleInfo.getArticle().getPagination().getMedlinePgn());
            }
            ArticleIdType_pubmed[] idlist = res.getPubmedArticleSet().getPubmedArticle()[0].getPubmedData().getArticleIdList().getArticleId();
            int i = 0;
            while (i < idlist.length) {
                info.putID(idlist[i].getIdType().toString(), idlist[i].get_value());
                ++i;
            }
            if (ConciergeAdapter.hasPapers(id, IDTYPE).booleanValue()) {
                info.setFlag(2);
            } else {
                info.setFlag(0);
            }
            if (articleInfo.getArticle().get_abstract() != null && articleInfo.getArticle().get_abstract().getAbstractText() != null) {
                info.setAbstract(articleInfo.getArticle().get_abstract().getAbstractText());
            }
            return info;
        }
        catch (ServiceException serviceException) {
            throw new CannotGetPaperInfoException(id, IDTYPE);
        }
        catch (RemoteException remoteException) {
            throw new CannotGetPaperInfoException(id, IDTYPE);
        }
    }

    public void cancel() {
        this.searchResult = null;
    }

    public String getAuthorString(AuthorListType authors) {
        AuthorType_nlmc[] a = authors.getAuthor();
        StringBuffer authorString = new StringBuffer();
        int i = 0;
        i = 0;
        while (i < a.length - 1) {
            authorString.append(String.valueOf(a[i].getLastName()) + " " + a[i].getInitials());
            authorString.append(", ");
            ++i;
        }
        authorString.append(String.valueOf(a[i].getLastName()) + " " + a[i].getInitials());
        return authorString.toString();
    }

    public String titleOfTitleAbbreviation(String TA) {
        String title = null;
        try {
            EUtilsServiceLocator service = new EUtilsServiceLocator();
            EUtilsServiceSoap utils = service.geteUtilsServiceSoap();
            ESearchRequest parameters = new ESearchRequest();
            parameters.setDb("Journals");
            parameters.setTerm(URLEncoder.encode(String.valueOf(TA) + "[TA]", "UTF-8"));
            ESearchResult searchRes = utils.run_eSearch(parameters);
            if (searchRes.getIdList() != null && searchRes.getIdList().getId().length > 0) {
                ESummaryRequest params = new ESummaryRequest();
                params.setDb("journals");
                params.setId(searchRes.getIdList().getId()[0]);
                ESummaryResult res = utils.run_eSummary(params);
                if (res.getDocSum() != null && res.getDocSum().length > 0) {
                    title = res.getDocSum()[0].getItem()[0].get_any()[0].getValue();
                    if (IPapersPlugin.log.isDebugEnabled()) {
                        IPapersPlugin.log.debug((Object)title);
                    }
                    Pattern pattern = Pattern.compile("([\\w ]+)");
                    Matcher m = pattern.matcher(title);
                    m.find();
                    title = m.group(0);
                } else {
                    title = TA;
                }
            } else {
                title = TA;
            }
        }
        catch (Exception e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
        return title;
    }
}

