/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.util.Set;
import jp.sourceforge.concierge.plugin.ipapers.ConciergeAdapter;
import org.eclipse.swt.custom.CCombo;

public class QueryComposeData {
    public static String[] targetData = new String[]{"", "Author", "Title", "Journal", "Keyword", "Year", "Publication Type"};
    private static String[] rangeData = new String[]{"", "Include", "Exclude"};
    private static String[] numericalRangeData = new String[]{"", "Larger than", "Equal to", "Smaller than"};
    private static String[] publicationTypeData = new String[]{"Clinical Trial", "Editorial", "Letter", "Meta-Analysis", "Practice Guideline", "Randomized Controlled Trial", "Addresses", "Bibliography", "Biography", "Case Reports", "Classical Article", "Clinical Conference", "Clinical Trial, Phase I", "Clinical Trial, Phase II", "Clinical Trial, Phase III", "Clinical Trial, Phase IV", "Comment", "Congresses", "Consensus Development Conference", "Consensus Development Conference, NIH", "Controlled Clinical Trial", "Corrected and Republished Article", "Dictionary", "Directory", "Duplicate Publication", "Evaluation Studies", "Festschrift", "Government Publications", "Guideline", "Historical Article", "Interview", "Journal Article", "Lectures", "Legal Cases", "Legislation", "Multicenter Study", "News", "Newspaper Article", "Overall", "Patient Education Handout", "Periodical Index", "Published Erratum", "Retracted Publication", "Retraction of Publication", "Scientific Integrity Review"};
    private static int MAX_OF_ITEMS = 10;

    static void setContainRangeItems(CCombo ccombo) {
        ccombo.removeAll();
        String[] stringArray = rangeData;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            ccombo.add(t);
            ++n;
        }
        ccombo.select(1);
        ccombo.setVisibleItemCount(rangeData.length);
    }

    private static void setNumericalRangeItems(CCombo ccombo) {
        ccombo.removeAll();
        String[] stringArray = numericalRangeData;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            ccombo.add(t);
            ++n;
        }
        ccombo.select(2);
        ccombo.setVisibleItemCount(numericalRangeData.length);
    }

    private static void setPublicationType(CCombo ccombo) {
        ccombo.setEditable(false);
        ccombo.removeAll();
        String[] stringArray = publicationTypeData;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            ccombo.add(t);
            ++n;
        }
        ccombo.setVisibleItemCount(15);
    }

    public static void setParameterItems(String selectedItem, CCombo parameter, CCombo keyword) {
        if (selectedItem.equals("Journal")) {
            QueryComposeData.setContainRangeItems(parameter);
            QueryComposeData.setJournals(keyword);
        } else if (selectedItem.equals("Author")) {
            QueryComposeData.setContainRangeItems(parameter);
            QueryComposeData.setAuthors(keyword);
        } else if (selectedItem.equals("Keyword")) {
            QueryComposeData.setContainRangeItems(parameter);
            QueryComposeData.setKeywords(keyword);
        } else if (selectedItem.equals("Title")) {
            QueryComposeData.setContainRangeItems(parameter);
            keyword.setEditable(true);
            keyword.removeAll();
        } else if (selectedItem.equals("Year")) {
            QueryComposeData.setNumericalRangeItems(parameter);
            keyword.setEditable(true);
        } else if (selectedItem.equals("Publication Type")) {
            QueryComposeData.setContainRangeItems(parameter);
            QueryComposeData.setPublicationType(keyword);
        }
    }

    private static void setJournals(CCombo ccombo) {
        Set<String> journals = ConciergeAdapter.journalInConcierge();
        ccombo.removeAll();
        for (String journal : journals) {
            ccombo.add(journal);
        }
        ccombo.setVisibleItemCount(journals.size() > MAX_OF_ITEMS ? MAX_OF_ITEMS : journals.size());
    }

    private static void setAuthors(CCombo ccombo) {
        Set<String> authors = ConciergeAdapter.authorsInConcierge();
        ccombo.removeAll();
        for (String author : authors) {
            ccombo.add(author);
        }
        ccombo.setVisibleItemCount(authors.size() > MAX_OF_ITEMS ? MAX_OF_ITEMS : authors.size());
    }

    private static void setKeywords(CCombo ccombo) {
        Set<String> keywords = ConciergeAdapter.keywordsInConcierge();
        ccombo.removeAll();
        for (String keyword : keywords) {
            ccombo.add(keyword);
        }
        ccombo.setVisibleItemCount(keywords.size() > MAX_OF_ITEMS ? MAX_OF_ITEMS : keywords.size());
    }
}

