/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.view;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import jp.ac.suzuka_ct.www.info.lab.aoyama.articleComment.ArticleComment;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.ConciergeAdapter;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperList;
import jp.sourceforge.concierge.plugin.ipapers.download.PDFDownloadException;
import jp.sourceforge.concierge.plugin.ipapers.download.PDFDownloadJob;
import jp.sourceforge.concierge.plugin.ipapers.download.downloadPDF;
import jp.sourceforge.concierge.plugin.ipapers.search.comment.CommentSearch;
import jp.sourceforge.concierge.plugin.ipapers.view.PaperContentProvider;
import jp.sourceforge.concierge.plugin.ipapers.view.PaperLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ResultView {
    private SashForm result_sf = null;
    private Action horizontalAction = null;
    private Action verticalAction = null;
    private StyledText abstractText = null;
    private StyledText commentText = null;
    private Table table = null;
    private TableViewer tableviewer = null;
    private Action dialogAction = null;
    private IMemento memento = null;
    private IWorkbenchPartSite parentViewPartSite;
    private PaperList papers = PaperList.getInstance();

    public ResultView(IWorkbenchPartSite site, IMemento mem) {
        this.parentViewPartSite = site;
        this.memento = mem;
    }

    public void saveColumnWidth(IMemento memento) {
        TableColumn[] columns = this.tableviewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            memento.putInteger("TAG_COLUMN_WIDTH" + i, columns[i].getWidth());
            ++i;
        }
    }

    public void createSearchResultForm(SashForm mainForm) {
        boolean orientation = IPapersPlugin.getDefault().getPreferenceStore().getBoolean("orientation horizontal");
        this.result_sf = orientation ? new SashForm((Composite)mainForm, 256) : new SashForm((Composite)mainForm, 512);
        this.result_sf.setLayoutData((Object)new GridData(1808));
        this.createResultTable(this.result_sf);
        this.createDetailTab(this.result_sf);
        this.result_sf.setWeights(new int[]{55, 45});
        this.makeActions();
    }

    private void createDetailTab(SashForm sf) {
        CTabFolder detailTabFolder = new CTabFolder((Composite)sf, 0);
        Display display = Display.getCurrent();
        Color titleForeColor = display.getSystemColor(30);
        Color titleBackColor1 = display.getSystemColor(31);
        Color titleBackColor2 = display.getSystemColor(32);
        detailTabFolder.setSelectionForeground(titleForeColor);
        detailTabFolder.setSelectionBackground(new Color[]{titleBackColor1, titleBackColor2}, new int[]{100}, true);
        this.createAbstractTab(detailTabFolder);
        this.createCommentTab(detailTabFolder);
    }

    private void createAbstractTab(CTabFolder tabFolder) {
        CTabItem tabAbstract = new CTabItem(tabFolder, 0);
        tabAbstract.setText("Abstract");
        tabFolder.setSelection(tabAbstract);
        this.abstractText = new StyledText((Composite)tabFolder, 2626);
        tabAbstract.setControl((Control)this.abstractText);
    }

    private void createCommentTab(CTabFolder tabFolder) {
        CTabItem tabComment = new CTabItem(tabFolder, 0);
        tabComment.setText("Comment");
        this.commentText = new StyledText((Composite)tabFolder, 2626);
        tabComment.setControl((Control)this.commentText);
    }

    private void createResultTable(SashForm sf) {
        this.table = new Table((Composite)sf, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableviewer = new TableViewer(this.table);
        this.tableviewer.setContentProvider((IContentProvider)new PaperContentProvider());
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new PaperLabelProvider(this.memento));
        this.tableviewer.setInput((Object)this.papers);
        int i = 0;
        while (i < PaperLabelProvider.COLUMN.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(PaperLabelProvider.COLUMN[i]);
            tableColumn.setWidth(PaperLabelProvider.WIDTH[i]);
            int index = i++;
            tableColumn.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ResultView.this.tableviewer.setSorter(PaperLabelProvider.SORTER[index]);
                }
            });
        }
        this.tableviewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Paper selected1stArticle = (Paper)selection.getFirstElement();
                try {
                    ResultView.this.abstractText.setText(selected1stArticle.getPaperInfo().getAbstract());
                    selected1stArticle.setFlag(1);
                    CommentSearch commentSearch = new CommentSearch();
                    ArrayList<ArticleComment> comments = commentSearch.comments(selected1stArticle.getId(), selected1stArticle.getIdType());
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < comments.size()) {
                        sb.append(comments.get(i).getBlog_name());
                        sb.append(":");
                        sb.append(comments.get(i).getCommitTime());
                        sb.append("\n");
                        sb.append(comments.get(i).getComment());
                        sb.append("\n");
                        sb.append(comments.get(i).getUrl());
                        sb.append("\n");
                        sb.append("\n");
                        ++i;
                    }
                    ResultView.this.commentText.setText(sb.toString());
                    ResultView.this.tableviewer.refresh();
                }
                catch (CannotGetPaperInfoException e) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                }
                catch (ServiceException e) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                }
                catch (RemoteException e) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                }
            }
        });
        this.tableviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selected_article = selection.getFirstElement();
                ResultView.this.executeBrowser(((Paper)selected_article).getURL());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.tableviewer.getControl());
        this.tableviewer.getControl().setMenu(menu);
        this.parentViewPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.tableviewer);
        Action importAction = new Action(){

            public void run() {
                ResultView.this.importToConcierge();
            }
        };
        importAction.setText("Import");
        menuMgr.add((IAction)importAction);
        Action downloadAction = new Action(){

            public void run() {
                ResultView.this.tryToDownloadPDF();
            }
        };
        downloadAction.setText("Download PDF");
        menuMgr.add((IAction)downloadAction);
        Action openURLAction = new Action(){

            public void run() {
                ResultView.this.executeBrowser();
            }
        };
        openURLAction.setText("Open Journal Site");
        menuMgr.add((IAction)openURLAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.horizontalAction = new Action(){

            public void run() {
                ResultView.this.result_sf.setOrientation(256);
                IPapersPlugin.getDefault().getPreferenceStore().setValue("orientation horizontal", true);
            }
        };
        this.horizontalAction.setText("Horizontal Layout");
        this.horizontalAction.setToolTipText("Horizontal Layout");
        this.horizontalAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ipapers", (String)"icons/th_horizontal.gif"));
        this.verticalAction = new Action(){

            public void run() {
                ResultView.this.result_sf.setOrientation(512);
                IPapersPlugin.getDefault().getPreferenceStore().setValue("orientation horizontal", false);
            }
        };
        this.verticalAction.setText("Vertical Layout");
        this.verticalAction.setToolTipText("Vertical Layout");
        this.verticalAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ipapers", (String)"icons/th_vertical.gif"));
        this.dialogAction = new Action(){

            public void run() {
                Shell shell = IPapersPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                ConciergeDialog cd = IPapersPlugin.getDefault().getDialog(shell, 1264);
                cd.setDocument(null, (Object)IPapersPlugin.getDefault().getBundle().getSymbolicName());
                cd.open();
            }
        };
        this.dialogAction.setText("Open Edit Dialog");
        this.dialogAction.setToolTipText("Open Edit Dialog");
        this.dialogAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ipapers", (String)"icons/dialog.png"));
    }

    private void downloadPDF(Paper anArticle) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            String PDFlocation = new downloadPDF(anArticle.getURL()).PDFLocation();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFileName(String.valueOf(anArticle.getId()) + ".pdf");
            String filelocation = dlg.open();
            if (filelocation != null) {
                PDFDownloadJob job = new PDFDownloadJob("Try to Download PDF", filelocation, PDFlocation, anArticle);
                if (IPapersPlugin.getDefault().getPreferenceStore().getBoolean("suppres dialog")) {
                    job.setUser(false);
                } else {
                    job.setUser(true);
                }
                job.schedule();
            }
        }
        catch (PDFDownloadException e) {
            MessageBox errDlg = new MessageBox(shell, 1);
            errDlg.setMessage(e.getMessage());
            errDlg.open();
            return;
        }
    }

    private void tryToDownloadPDF() {
        TableItem[] selectedItems = this.tableviewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            Paper anArticle = (Paper)selectedItems[i].getData();
            this.downloadPDF(anArticle);
            ++i;
        }
    }

    private void importToConcierge() {
        TableItem[] selectedItems = this.tableviewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            this.importToConcierge((Paper)selectedItems[i].getData());
            ++i;
        }
    }

    private void importToConcierge(Paper aPaper) {
        try {
            if (ConciergeAdapter.saveArticle(aPaper.getPaperInfo(), IPapersPlugin.getDefault().getBundle().getSymbolicName())) {
                aPaper.setFlag(2);
                this.tableviewer.refresh();
            }
        }
        catch (CannotGetPaperInfoException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
    }

    private void executeBrowser() {
        TableItem[] selectedItems = this.tableviewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            Paper aPaper = (Paper)selectedItems[i].getData();
            this.executeBrowser(aPaper.getURL());
            ++i;
        }
    }

    private void executeBrowser(String url) {
        if (url != null) {
            Program program = Program.findProgram((String)"html");
            if (IPapersPlugin.log.isDebugEnabled()) {
                IPapersPlugin.log.debug((Object)("Open URL:" + url));
            }
            if (program != null) {
                program.execute(url);
            } else {
                try {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url});
                }
                catch (IOException iOException) {
                    IPapersPlugin.log.error((Object)"could not find system browser");
                }
            }
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.horizontalAction);
        manager.add((IAction)this.verticalAction);
        manager.add((IAction)this.dialogAction);
    }

    public void contributeToActionBars(IViewSite viewSite) {
        IActionBars bars = viewSite.getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }
}

