/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.concierge.plugin;

import java.io.File;
import java.util.Hashtable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sourceforge.concierge.plugin.FileImporter;

public class FileManagerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.filemanager";
    private static FileManagerPlugin plugin;
    private DefaultFileMonitor fmonitor = null;
    private String directory = null;
    private Hashtable<String, String> filelist = new Hashtable();

    public FileManagerPlugin() {
        plugin = this;
    }

    private synchronized void addToList(String path, long id) {
        this.filelist.put(String.valueOf(id), FilenameUtils.getName((String)path));
    }

    private synchronized String getFileName(String id) {
        return this.filelist.get(id);
    }

    private synchronized void deleteFromList(long id) {
        try {
            this.filelist.remove(String.valueOf(id));
        }
        catch (Exception exception) {
            return;
        }
    }

    private synchronized void initFileList(String dir) {
        File fd = new File(dir);
        File[] files = fd.listFiles();
        int i = 0;
        while (i < files.length) {
            try {
                String name = files[i].getName();
                long id = Long.parseLong(FilenameUtils.getBaseName((String)name));
                this.filelist.put(String.valueOf(id), name);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fmonitor != null) {
            this.fmonitor.stop();
            this.fmonitor = null;
        }
        plugin = null;
        super.stop(context);
    }

    public void setManagerDirectory(String dir) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileObject listendir = fsManager.resolveFile(dir);
            if (this.fmonitor != null) {
                this.fmonitor.stop();
                this.fmonitor = null;
            }
            this.initFileList(dir);
            this.directory = dir;
            this.fmonitor = new DefaultFileMonitor((FileListener)new CustomFileListener());
            this.fmonitor.setRecursive(false);
            this.fmonitor.addFile(listendir);
            this.fmonitor.start();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void add(String orgfile, long id) {
        String ext = FilenameUtils.getExtension((String)orgfile);
        String imname = String.valueOf(String.valueOf(id)) + (ext != null && ext.length() > 0 ? "." + ext : "");
        if (FileImporter.getPathFromID(this.directory, id) != null) {
            FileImporter.deleteFile(this.directory, id);
        }
        if (FileImporter.importFile(orgfile, this.directory, imname)) {
            this.addToList(imname, id);
        }
    }

    public void delete(long id) {
        FileImporter.deleteFile(this.directory, id);
        this.deleteFromList(id);
    }

    public String getFilenameFromID(long id) {
        String f = this.getFileName(String.valueOf(id));
        if (f == null) {
            return null;
        }
        return String.valueOf(this.directory) + File.separator + f;
    }

    public String getFilename(String file) {
        return FileImporter.findFile(this.directory, file);
    }

    public static FileManagerPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return FileManagerPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private class CustomFileListener
    implements FileListener {
        private CustomFileListener() {
        }

        public void fileChanged(FileChangeEvent e) {
        }

        public void fileDeleted(FileChangeEvent ev) {
            String bname = ev.getFile().getName().getBaseName();
            try {
                long id = Long.parseLong(bname);
                FileManagerPlugin.this.deleteFromList(id);
            }
            catch (Exception exception) {
                return;
            }
        }

        public void fileCreated(FileChangeEvent ev) {
            String path = ev.getFile().getName().getPath();
            try {
                long id = Long.parseLong(FilenameUtils.getBaseName((String)path));
                FileManagerPlugin.this.addToList(path, id);
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

