/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.InputStream;
import java.nio.ByteBuffer;
import jp.sourceforge.concierge.util.SystemUtil;

public class Alias {
    private static final String ALIASCOMMAND = "aliascommand";
    public static final String ERRORHEADER = "!ERROR:";

    private static String getCommandString() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            return "\"" + System.getProperty("osgi.install.area").replaceFirst("file:/", "") + "tools" + System.getProperty("file.separator") + ALIASCOMMAND + ".exe\"";
        }
        if (os.startsWith("Mac")) {
            String cmd = String.valueOf(System.getProperty("osgi.install.area").replaceFirst("file:", "")) + "tools" + System.getProperty("file.separator") + ALIASCOMMAND;
            return Alias.replaceSpace(cmd);
        }
        String cmd = String.valueOf(System.getProperty("osgi.install.area").replaceFirst("file:", "")) + "tools" + System.getProperty("file.separator") + ALIASCOMMAND;
        return Alias.replaceSpace(cmd);
    }

    private static String execCommand(String[] args) {
        try {
            byte[] buf = new byte[1024];
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(args);
            InputStream is = pr.getInputStream();
            int sz = is.read(buf);
            int totalsize = 0;
            while (sz >= 0) {
                buffer.put(buf);
                totalsize = sz;
                sz = is.read(buf);
            }
            if (totalsize == 0) {
                return new String();
            }
            return SystemUtil.GetOSType() == 0 ? new String(buffer.array()) : new String(buffer.array(), "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String replaceSpace(String str) {
        return str.replaceAll(" ", "\\ ");
    }

    private static String encloseWithDQ(String str) {
        return "\"" + str + "\"";
    }

    public static long getIDFromPath(String aliasdir, String path) {
        String command = Alias.getCommandString();
        String[] args = new String[4];
        args[0] = command;
        args[1] = "-i";
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            args[2] = Alias.encloseWithDQ(aliasdir);
            args[3] = Alias.encloseWithDQ(path);
        } else if (os.startsWith("Mac")) {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(path);
        } else {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(path);
        }
        String result = Alias.execCommand(args);
        if (result == null || result.startsWith(ERRORHEADER)) {
            return -1L;
        }
        return Long.parseLong(result.trim());
    }

    public static String getPathFromID(String aliasdir, long id) {
        String command = Alias.getCommandString();
        String[] args = new String[4];
        args[0] = command;
        args[1] = "-p";
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            args[2] = Alias.encloseWithDQ(aliasdir);
            args[3] = Alias.encloseWithDQ(String.valueOf(id));
        } else if (os.startsWith("Mac")) {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(String.valueOf(id));
        } else {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(String.valueOf(id));
        }
        String result = Alias.execCommand(args);
        if (result == null || result.startsWith(ERRORHEADER)) {
            return null;
        }
        return result.trim();
    }

    public static String createAlias(String originalfile, String aliasdir, String aliasfile) {
        String command = Alias.getCommandString();
        String[] args = new String[5];
        args[0] = command;
        args[1] = "-c";
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            args[2] = Alias.encloseWithDQ(originalfile);
            args[3] = Alias.encloseWithDQ(aliasdir);
            args[4] = Alias.encloseWithDQ(aliasfile);
        } else if (os.startsWith("Mac")) {
            args[2] = Alias.replaceSpace(originalfile);
            args[3] = Alias.replaceSpace(aliasdir);
            args[4] = Alias.replaceSpace(aliasfile);
        } else {
            args[2] = Alias.replaceSpace(originalfile);
            args[3] = Alias.replaceSpace(aliasdir);
            args[4] = Alias.replaceSpace(aliasfile);
        }
        String res = Alias.execCommand(args);
        return res == null || res.startsWith(ERRORHEADER) ? null : res;
    }

    public static String deleteAlias(String aliasdir, String id) {
        String command = Alias.getCommandString();
        String[] args = new String[4];
        args[0] = command;
        args[1] = "-d";
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            args[2] = Alias.encloseWithDQ(aliasdir);
            args[3] = Alias.encloseWithDQ(id);
        } else if (os.startsWith("Mac")) {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(id);
        } else {
            args[2] = Alias.replaceSpace(aliasdir);
            args[3] = Alias.replaceSpace(id);
        }
        String res = Alias.execCommand(args);
        return res == null || res.startsWith(ERRORHEADER) ? null : res;
    }
}

