/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import org.osgi.framework.Bundle;

public class DatabaseKeeper {
    private static final String databaseID = "jp.sourceforge.concierge.database";
    private static final String activatorID = "Bundle-Activator";
    private static final String getMethod = "getDefault";
    private Hashtable<String, Object> databaseFactory = new Hashtable();

    public void initialize(Bundle[] bundles) throws Exception {
        int i = 0;
        while (i < bundles.length) {
            String clsname;
            if (bundles[i].getSymbolicName().startsWith(databaseID) && (clsname = (String)bundles[i].getHeaders().get(activatorID)) != null) {
                Method method = bundles[i].loadClass(clsname).getMethod(getMethod, null);
                Object database = method.invoke(null, null);
                this.databaseFactory.put(clsname, database);
                System.out.println("Installed database: " + clsname);
            }
            ++i;
        }
    }

    public IDatabasePlugin getDatabasePlugin(String databasename) {
        Enumeration<Object> objs = this.databaseFactory.elements();
        while (objs.hasMoreElements()) {
            IDatabasePlugin database = (IDatabasePlugin)objs.nextElement();
            if (database.getDatabaseName().compareToIgnoreCase(databasename) != 0) continue;
            return database;
        }
        return null;
    }

    public ArrayList getAllDatabases() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> elements = this.databaseFactory.elements();
        while (elements.hasMoreElements()) {
            list.add(((IDatabasePlugin)elements.nextElement()).getDatabaseName());
        }
        return list;
    }
}

