/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.database.IDatabaseAdapter;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.DatabaseKeeper;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.ParserKeeper;
import jp.sourceforge.concierge.framework.PluginKeeper;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.core.SiteManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.sourceforge.concierge.plugin.FileImporter;
import org.sourceforge.concierge.plugin.FileManagerPlugin;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkPlugin
extends AbstractDocumentUIPlugin {
    private static final String DEFAULTDB = "Xindice Embedded with cache";
    public static final String TYPECOLLECTIONNAME = "type";
    public static final String DATACOLLECTIONNAME = "data";
    public static final String CONFCOLLECTIONNAME = "ccgconfig";
    private static FrameworkPlugin plugin;
    BundleContext bundlecontext;
    private ParserKeeper parsers;
    private DatabaseKeeper databases;
    private IDatabasePlugin currentdb;

    private void updateViews(ArrayList requests, Object sender) {
        ArrayList views = ConciergeViewPart.getViews();
        int i = 0;
        while (i < views.size()) {
            ConciergeViewPart vp = (ConciergeViewPart)((Object)views.get(i));
            try {
                vp.Update(requests, sender);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public FrameworkPlugin() {
        plugin = this;
        this.parsers = new ParserKeeper();
        this.databases = new DatabaseKeeper();
        this.currentdb = null;
    }

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        block8: {
            super.start(context);
            this.bundlecontext = context;
            bundles = context.getBundles();
            try {
                this.parsers.initialize(bundles);
                this.databases.initialize(bundles);
            }
            catch (Exception e) {
                if (e == null) break block8;
                System.err.println(e.getMessage());
            }
        }
        String dbname = this.getPreferenceStore().getString("CCGDatabaseName");
        if (dbname.length() == 0) {
            dbname = DEFAULTDB;
            this.getPreferenceStore().setValue("CCGDatabaseName", dbname);
        }
        this.currentdb = this.databases.getDatabasePlugin(dbname);
        ArrayList props = this.currentdb.getProperties();
        int i = 0;
        while (i < props.size()) {
            String p = this.getPreferenceStore().getString((String)props.get(i));
            if (p.length() > 0) {
                this.currentdb.setProperty((String)props.get(i), p);
            } else {
                this.getPreferenceStore().setValue((String)props.get(i), this.currentdb.getProperty((String)props.get(i)));
            }
            ++i;
        }
        if (this.currentdb.getInstance(TYPECOLLECTIONNAME) == null || this.currentdb.getInstance(DATACOLLECTIONNAME) == null) {
            PluginKeeper.stopPlugins(bundles);
            System.err.println("Quit concierge");
            System.exit(0);
        }
        FileManagerPlugin.getDefault().setManagerDirectory(plugin.getUserFileDir());
        this.initializePreferences();
        FrameworkPlugin.getDefault().getPreferenceStore().setValue("CCGDatabaseName", this.currentdb.getDatabaseName());
        ArrayList properties = this.currentdb.getProperties();
        int i2 = 0;
        while (i2 < properties.size()) {
            String p = (String)properties.get(i2);
            FrameworkPlugin.getDefault().getPreferenceStore().setValue(p, this.currentdb.getProperty(p));
            ++i2;
        }
        plugin.savePluginPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FrameworkPlugin getDefault() {
        return plugin;
    }

    public void activateAllPlugins() {
        PluginKeeper.initialize(this.bundlecontext.getBundles());
    }

    public Document getDocumentByID(String collection, long id) {
        String xpath = "/child::*[@id='" + String.valueOf(id) + "']";
        ArrayList<Document> docs = this.currentdb.getInstance(collection).query(xpath);
        return docs == null || docs.size() == 0 ? null : docs.get(0);
    }

    public static IParserPlugin getParserPlugin(String typename) {
        return FrameworkPlugin.plugin.parsers.getParserPlugin(typename);
    }

    public static IConciergeDialog getDialogPlugin(String pluginid) {
        AbstractUIPlugin p = PluginKeeper.getPlugin(pluginid);
        return p instanceof IConciergeDialog ? (IConciergeDialog)p : null;
    }

    public static AbstractUIPlugin getPlugin(String pluginid) {
        return PluginKeeper.getPlugin(pluginid);
    }

    public static ArrayList getAllParserTypes() {
        return FrameworkPlugin.plugin.parsers.getAllParserTypes();
    }

    public static IDatabasePlugin getDatabasePlugin(String dbname) {
        return FrameworkPlugin.plugin.databases.getDatabasePlugin(dbname);
    }

    public static ArrayList getAllDatabases() {
        return FrameworkPlugin.plugin.databases.getAllDatabases();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.framework", (String)path);
    }

    public ArrayList<Document> getDocumentsOfQuery(Request req) {
        ArrayList<Document> alldocs = this.currentdb.getInstance(req.collection).query((String)req.data);
        return alldocs;
    }

    private String getDatabaseDir(String path) {
        File f;
        String dbdir = this.currentdb.getLocalDatabaseDirectory();
        if (dbdir == null) {
            dbdir = System.getProperty("user.home");
        }
        if (!(f = new File(dbdir = String.valueOf(dbdir) + File.separator + path)).exists()) {
            f.mkdir();
        }
        return dbdir;
    }

    private String getUserFileDir() {
        return this.getDatabaseDir(".concierge");
    }

    private String getSystemFileDir() {
        return this.getDatabaseDir(".import");
    }

    private void adddocument(IDatabaseAdapter adapter, Document doc) {
        ArrayList<Document> list = new ArrayList<Document>();
        String path = DataDomImpl.getFilePath(doc);
        if (path != null && path.length() > 0) {
            DataDomImpl.setFileName(doc, FilenameUtils.getName((String)path));
            DataDomImpl.removeFilePath(doc);
        }
        list.add(doc);
        if (!adapter.append(list)) {
            return;
        }
        if (path == null || path.length() == 0) {
            return;
        }
        FileManagerPlugin.getDefault().add(path, DomImpl.getID(doc));
    }

    private void deldocument(IDatabaseAdapter adapter, Document doc) {
        ArrayList<Document> list = new ArrayList<Document>();
        list.add(doc);
        if (adapter.delete(list) && adapter.getCollectionName().compareTo(DATACOLLECTIONNAME) == 0) {
            FileManagerPlugin.getDefault().delete(DomImpl.getID(doc));
        }
    }

    private void upddocument(IDatabaseAdapter adapter, Document doc) {
        String path = DataDomImpl.getFilePath(doc);
        if (path != null && path.length() > 0) {
            DataDomImpl.setFileName(doc, FilenameUtils.getName((String)path));
            DataDomImpl.removeFilePath(doc);
        }
        ArrayList<Document> list = new ArrayList<Document>();
        DomImpl.setLastModifiedTime(doc, System.currentTimeMillis());
        list.add(doc);
        adapter.update(list);
        if (path == null || path.length() == 0) {
            return;
        }
        long id = DomImpl.getID(doc);
        FileManagerPlugin.getDefault().delete(id);
        FileManagerPlugin.getDefault().add(path, id);
    }

    public boolean updateDocuments(ArrayList requests, Object sender) {
        int i = 0;
        while (i < requests.size()) {
            Request req = (Request)requests.get(i);
            IDatabaseAdapter dba = this.currentdb.getInstance(req.collection);
            Document doc = (Document)req.data;
            long id = DomImpl.getID(doc);
            switch (req.command) {
                case 1: 
                case 3: {
                    if (dba.documentExists(id)) {
                        this.upddocument(dba, doc);
                        break;
                    }
                    this.adddocument(dba, doc);
                    break;
                }
                case 2: {
                    this.deldocument(dba, doc);
                }
            }
            ++i;
        }
        this.updateViews(requests, sender);
        return true;
    }

    public static void importSystemFile(String originalfile, String newfile) {
        FileImporter.importFile((String)originalfile, (String)plugin.getSystemFileDir(), (String)newfile);
    }

    public static String findSystemFile(String file) {
        return FileImporter.findFile((String)plugin.getSystemFileDir(), (String)file);
    }

    public static void importUserFile(String originalfile, long id) {
        FileManagerPlugin.getDefault().add(originalfile, id);
    }

    public static String findUserFile(String filename) {
        return FileManagerPlugin.getDefault().getFilename(filename);
    }

    public static void deleteUserFile(long id) {
        FileManagerPlugin.getDefault().delete(id);
    }

    public static String getPathFromID(long id) {
        return FileManagerPlugin.getDefault().getFilenameFromID(id);
    }

    public static long getIDFromPath(String path) {
        return -1L;
    }

    public static Document getDocumentFromPath(String path) {
        try {
            long id = Long.parseLong(FilenameUtils.getBaseName((String)path));
            return plugin.getDocumentByID(DATACOLLECTIONNAME, id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getLocalDatabaseDirectory() {
        if (FrameworkPlugin.plugin.currentdb == null) {
            return null;
        }
        return FrameworkPlugin.plugin.currentdb.getLocalDatabaseDirectory();
    }

    private void initializePreferences() {
        this.initHttpProxy();
        this.initFormatData();
    }

    private void initHttpProxy() {
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        String proxyPort = FrameworkPlugin.getDefault().GetHttpProxyPort();
        System.out.println("Http Proxy Host = " + proxyHost + ", Port = " + proxyPort);
        if (proxyHost != null && proxyHost.length() > 0) {
            System.setProperty("http.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            System.setProperty("http.proxyPort", proxyPort);
        }
    }

    public String GetHttpProxyHost() {
        if (SiteManager.isHttpProxyEnable()) {
            String proxyHost = SiteManager.getHttpProxyServer();
            System.out.println(proxyHost);
            return proxyHost;
        }
        return "";
    }

    public String GetHttpProxyPort() {
        if (SiteManager.isHttpProxyEnable()) {
            String proxyPort = SiteManager.getHttpProxyPort();
            System.out.println(proxyPort);
        }
        return "";
    }

    private void initFormatData() {
        try {
            ReferenceFormatDomImpl.initializeFormatDataList();
        }
        catch (Exception exception) {}
    }
}

