/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.parser.IParserPlugin;
import org.osgi.framework.Bundle;

public class ParserKeeper {
    private static final String parserID = "jp.sourceforge.concierge.parser";
    private static final String activatorID = "Bundle-Activator";
    private static final String getMethod = "getDefault";
    private static Hashtable<String, Object> parserFactory = new Hashtable();

    public void initialize(Bundle[] bundles) throws Exception {
        int i = 0;
        while (i < bundles.length) {
            String clsname;
            if (bundles[i].getSymbolicName().startsWith(parserID) && (clsname = (String)bundles[i].getHeaders().get(activatorID)) != null) {
                Method method = bundles[i].loadClass(clsname).getMethod(getMethod, null);
                Object parser = method.invoke(null, null);
                parserFactory.put(clsname, parser);
            }
            ++i;
        }
    }

    public IParserPlugin getParserPlugin(String typename) {
        Enumeration<Object> objs = parserFactory.elements();
        while (objs.hasMoreElements()) {
            IParserPlugin parser = (IParserPlugin)objs.nextElement();
            if (parser.getType().compareToIgnoreCase(typename) != 0) continue;
            return parser;
        }
        return null;
    }

    public ArrayList getAllParserTypes() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> elements = parserFactory.elements();
        while (elements.hasMoreElements()) {
            list.add(((IParserPlugin)elements.nextElement()).getType());
        }
        return list;
    }
}

