/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.util.AccountData;
import jp.sourceforge.concierge.util.AccountsDomImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class AccountPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer _tableviewer = null;
    private Label _accountname = null;
    private Text _accounttype = null;
    private Text _url = null;
    private Text _username = null;
    private Text _comment = null;
    private Text _passwd = null;
    private Button _check = null;
    private Button _autofill = null;
    private AccountData _ad = null;
    private Action newAccountAction;
    private Action deleteAccountAction;
    private Action saveAction;
    private ArrayList<AccountData> deleteList = null;

    public AccountPreferencePage() {
        super("Account");
    }

    public void init(IWorkbench workbench) {
        System.out.println("AccountPreferencePage Init");
    }

    public void dispose() {
        super.dispose();
        System.out.println("AccountPreferencePage Dispose");
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite fieldEditorParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        fieldEditorParent.setLayout((Layout)layout);
        this.createPartControl(fieldEditorParent);
        return fieldEditorParent;
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected void createPartControl(Composite parent) {
        GridData data = null;
        this._tableviewer = new TableViewer(parent, 66308);
        data = new GridData(768);
        data.heightHint = 120;
        this._tableviewer.getControl().setLayoutData((Object)data);
        this._tableviewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this._tableviewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this._tableviewer.getTable().setLinesVisible(true);
        this._tableviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                AccountPreferencePage.this.setCurrentData((AccountData)obj);
            }
        });
        this._tableviewer.setColumnProperties(new String[]{"text"});
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this._tableviewer.getTable())};
        this._tableviewer.setCellEditors(cellEditors);
        this._tableviewer.setCellModifier((ICellModifier)new TableCellModifier(this._tableviewer));
        Composite rightComposite = new Composite(parent, 0);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        data = new GridData();
        data.heightHint = 120;
        rightComposite.setLayoutData((Object)data);
        rightComposite.setLayoutData((Object)new GridData(1040));
        Button newButton = new Button(rightComposite, 8);
        newButton.setText("new");
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.DoNewAccount();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData(768);
        newButton.setLayoutData((Object)data);
        Button delButton = new Button(rightComposite, 8);
        delButton.setText("delete");
        delButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.DoDeleteAccount();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData(768);
        delButton.setLayoutData((Object)data);
        Composite underComposite = new Composite(parent, 0);
        underComposite.setLayout((Layout)new GridLayout(2, false));
        data = new GridData(1808);
        data.horizontalSpan = 2;
        underComposite.setLayoutData((Object)data);
        Label label = null;
        Label space1 = new Label(underComposite, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        space1.setLayoutData((Object)data);
        this._accountname = new Label(underComposite, 0);
        Font font = this._accountname.getFont();
        this._accountname.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this._accountname.setLayoutData((Object)data);
        Label separator1 = new Label(underComposite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator1.setLayoutData((Object)data);
        label = new Label(underComposite, 0);
        label.setText("Type:");
        this._accounttype = new Text(underComposite, 2048);
        this._accounttype.setEditable(false);
        this._accounttype.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text cfr_ignored_0 = (Text)e.getSource();
            }
        });
        data = new GridData(768);
        this._accounttype.setLayoutData((Object)data);
        label = new Label(underComposite, 0);
        label.setText("Url:");
        this._url = new Text(underComposite, 2048);
        this._url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (AccountPreferencePage.this._ad != null) {
                    AccountPreferencePage.this._ad.setUrl(text.getText());
                }
            }
        });
        data = new GridData(768);
        this._url.setLayoutData((Object)data);
        label = new Label(underComposite, 0);
        label.setText("User:");
        this._username = new Text(underComposite, 2048);
        this._username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (AccountPreferencePage.this._ad != null) {
                    AccountPreferencePage.this._ad.setUser(text.getText());
                }
            }
        });
        data = new GridData(768);
        this._username.setLayoutData((Object)data);
        this._check = new Button(underComposite, 32);
        this._check.setText("Password:");
        this._check.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AccountPreferencePage.this._check.getSelection()) {
                    AccountPreferencePage.this._passwd.setEchoChar('\u0000');
                } else {
                    AccountPreferencePage.this._passwd.setEchoChar('*');
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData(132);
        this._check.setLayoutData((Object)data);
        this._passwd = new Text(underComposite, 2048);
        this._passwd.setText("");
        this._passwd.setEchoChar('*');
        this._passwd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (AccountPreferencePage.this._ad != null) {
                    AccountPreferencePage.this._ad.setPasswd(text.getText());
                }
            }
        });
        data = new GridData(1792);
        this._passwd.setLayoutData((Object)data);
        label = new Label(underComposite, 0);
        label.setText("Comment:");
        this._comment = new Text(underComposite, 2048);
        this._comment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (AccountPreferencePage.this._ad != null) {
                    AccountPreferencePage.this._ad.setComment(text.getText());
                }
            }
        });
        data = new GridData(768);
        this._comment.setLayoutData((Object)data);
        this._autofill = new Button(underComposite, 32);
        this._autofill.setSelection(false);
        this._autofill.setText("AutoFill");
        data = new GridData(768);
        data.horizontalSpan = 2;
        this._autofill.setLayoutData((Object)data);
        this._autofill.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (AccountPreferencePage.this._ad != null) {
                    AccountPreferencePage.this._ad.setAutoFill(button.getSelection());
                }
            }
        });
        this.makeActions();
        this.DoOpen();
        this.setCurrentData(null);
    }

    private void makeActions() {
        this.newAccountAction = new Action(){

            public void run() {
                AccountPreferencePage.this.DoNewAccount();
            }
        };
        this.newAccountAction.setText("Add Account");
        this.newAccountAction.setToolTipText("Add Account");
        this.newAccountAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.deleteAccountAction = new Action(){

            public void run() {
                AccountPreferencePage.this.DoDeleteAccount();
            }
        };
        this.deleteAccountAction.setText("Delete Account");
        this.deleteAccountAction.setToolTipText("Delete Account");
        this.deleteAccountAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.saveAction = new Action(){

            public void run() {
                AccountPreferencePage.this.DoSave();
            }
        };
        this.saveAction.setText("Save Account");
        this.saveAction.setToolTipText("Save Account");
        this.saveAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private void setCurrentData(AccountData ad) {
        if (ad == null) {
            this._ad = ad;
            this._accountname.setText("*");
            this._accounttype.setText("");
            this._url.setText("");
            this._username.setText("");
            this._comment.setText("");
            this._passwd.setText("");
            this._autofill.setSelection(false);
        } else {
            if (this._ad != null && this._ad.equals(ad)) {
                return;
            }
            this._ad = ad;
            this._accountname.setText(this._ad.getName());
            this._accounttype.setText(this._ad.getType());
            this._url.setText(this._ad.getUrl());
            this._username.setText(this._ad.getUser());
            this._comment.setText(this._ad.getComment());
            this._passwd.setText(this._ad.getPasswd());
            this._autofill.setSelection(this._ad.isAutoFill());
        }
    }

    private void DoSave() {
        AccountData ad;
        ArrayList<Request> reqs = new ArrayList<Request>();
        int j = 0;
        while (j < this._tableviewer.getTable().getItemCount()) {
            ad = (AccountData)this._tableviewer.getElementAt(j);
            if (ad.getSTATUS() == 3) {
                reqs.add(new Request(1, ad.getDoc(true), "account"));
                ad.setSTATUS(0);
            } else if (ad.getSTATUS() == 0) {
                reqs.add(new Request(3, ad.getDoc(true), "account"));
                ad.setSTATUS(0);
            }
            ++j;
        }
        if (this.deleteList != null && this.deleteList.size() > 0) {
            int i = 0;
            while (i < this.deleteList.size()) {
                ad = this.deleteList.get(i);
                reqs.add(new Request(2, ad.getDoc(false), "account"));
                ++i;
            }
            this.deleteList.clear();
        }
        if (reqs.size() > 0) {
            FrameworkPlugin.getDefault().updateDocuments(reqs, "jp.sourceforge.concierge.framework.preferences.AccountPreferencePage");
        }
        reqs.clear();
        reqs = null;
    }

    private void DoOpen() {
        ArrayList<Document> al = AccountsDomImpl.getAllAccount();
        int i = 0;
        while (i < al.size()) {
            Document doc = al.get(i);
            AccountData ad = new AccountData(doc);
            this._tableviewer.add((Object)ad);
            ++i;
        }
    }

    private void DoNewAccount() {
        AccountData ad = new AccountData();
        this._tableviewer.add((Object)ad);
        this._tableviewer.reveal((Object)ad);
        this._tableviewer.getTable().select(this._tableviewer.getTable().getItemCount() - 1);
        this.setCurrentData(ad);
    }

    private void DoDeleteAccount() {
        if (this._ad != null) {
            if (this.deleteList == null) {
                this.deleteList = new ArrayList();
            }
            if (this._ad.getSTATUS() != 3) {
                this._ad.setSTATUS(2);
                this.deleteList.add(this._ad);
            }
            this._tableviewer.remove((Object)this._ad);
        }
    }

    private class TableCellModifier
    implements ICellModifier {
        private TableViewer viewer = null;

        public TableCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (AccountPreferencePage.this._ad != null) {
                return AccountPreferencePage.this._ad.equals(element);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            AccountData ad = (AccountData)element;
            return ad.getName();
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            AccountData ad = (AccountData)tableItem.getData();
            ad.setName((String)value);
            this.viewer.update((Object)ad, null);
            AccountPreferencePage.this._accountname.setText(ad.getName());
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ArrayList) {
                return ((ArrayList)parent).toArray();
            }
            return new String[]{"One", "Two", "Three"};
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AccountData) {
                return ((AccountData)obj).getName();
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

