/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DatabasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Composite _parent;
    Composite _propcomp;
    Combo _combo;
    String curdbname = "";
    ArrayList<Property> properties = new ArrayList();

    private boolean showConfirm(String message) {
        return MessageDialog.openConfirm((Shell)this._propcomp.getShell(), (String)"Database Preference", (String)message);
    }

    private void setDatabaseProperty(String dbname) {
        if (dbname.compareTo(this.curdbname) == 0) {
            return;
        }
        int i = 0;
        while (i < this.properties.size()) {
            this.properties.get(i).dispose();
            ++i;
        }
        this.properties.clear();
        IDatabasePlugin db = FrameworkPlugin.getDatabasePlugin(dbname);
        ArrayList props = db.getProperties();
        int i2 = 0;
        while (i2 < props.size()) {
            String pn = (String)props.get(i2);
            Byte type = db.getPropertyType(pn);
            this.properties.add(new Property(this._propcomp, pn, db.getProperty(pn), type == IDatabasePlugin.PROP_TYPE_PATH ? "..." : null));
            ++i2;
        }
        this.curdbname = dbname;
    }

    public DatabasePreferencePage() {
        super("Database");
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (!this.showConfirm("Changing database property requires restart the application.")) {
            return super.performCancel();
        }
        if (this._combo.getItemCount() > 0) {
            FrameworkPlugin.getDefault().getPreferenceStore().setValue("CCGDatabaseName", this._combo.getText());
            int i = 0;
            while (i < this.properties.size()) {
                Property p = this.properties.get(i);
                FrameworkPlugin.getDefault().getPreferenceStore().setValue(p.getProperty(), p.getValue());
                ++i;
            }
        }
        PlatformUI.getWorkbench().restart();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this._parent = parent;
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this._combo = new Combo(parent, 0);
        ArrayList dbs = FrameworkPlugin.getAllDatabases();
        int i = 0;
        while (i < dbs.size()) {
            this._combo.add((String)dbs.get(i));
            ++i;
        }
        if (this._combo.getItemCount() == 0) {
            return parent;
        }
        this._combo.select(0);
        this._combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabasePreferencePage.this.setDatabaseProperty(DatabasePreferencePage.this._combo.getText());
            }
        });
        this._propcomp = new Composite(parent, 0);
        this._propcomp.setLayout((Layout)new GridLayout(3, false));
        this._propcomp.setLayoutData((Object)new GridData(1808));
        this.setDatabaseProperty((String)dbs.get(0));
        return parent;
    }

    protected void contributeButtons(Composite parent) {
    }

    private class Property {
        public Label label;
        public Text text;
        public Button button;

        public Property(Composite parent, String title, String value, String btitle) {
            this.label = new Label(parent, 0);
            this.label.setLayoutData((Object)new GridData(0));
            this.label.setText(title);
            this.text = new Text(parent, 0);
            this.text.setLayoutData((Object)new GridData(768));
            this.text.setText(value);
            if (btitle == null) {
                return;
            }
            this.button = new Button(parent, 0);
            this.button.setLayoutData((Object)new GridData(0));
            this.button.setText(btitle);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(Property.this.button.getShell(), 4096);
                    String path = dd.open();
                    if (path != null) {
                        Property.this.text.setText(path);
                    }
                }
            });
        }

        public String getProperty() {
            return this.label.getText();
        }

        public String getValue() {
            return this.text.getText();
        }

        public void dispose() {
            this.label.dispose();
            this.text.dispose();
            if (this.button != null) {
                this.button.dispose();
            }
        }
    }
}

