/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatAuthorsItemData;
import jp.sourceforge.concierge.util.ReferenceFormatData;
import jp.sourceforge.concierge.util.ReferenceFormatDomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatIdentifiersItemData;
import jp.sourceforge.concierge.util.ReferenceFormatItem;
import jp.sourceforge.concierge.util.ReferenceFormatItemTransfer;
import jp.sourceforge.concierge.util.ReferenceFormatTypeData;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite _parent = null;
    private TableViewer typeTableViewer = null;
    private CheckboxTableViewer formatListTableViewer = null;
    private Button boldButton = null;
    private Button italicButton = null;
    private Combo fontCombo = null;
    private Spinner fontSizeSpinner = null;
    private TableViewer formatEditView = null;
    private int colSelectIndex = -1;
    private Color rectTextColor;
    private Color fillTextColor;
    private Color rectSchemaColor;
    private Color fillSchemaColor;
    private Action addSchemaAction;
    private Action addTextAction;
    private Action deleteAction;
    private Action boldAction;
    private Action italicAction;
    private Action underlineAction;
    private Action editAction;

    public ReferenceFormatPreferencePage() {
        super("Reference Format");
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected Control createContents(Composite parent) {
        this._parent = parent;
        this.noDefaultAndApplyButton();
        SashForm sf = new SashForm(parent, 512);
        sf.setLayout((Layout)new FillLayout());
        this.createCategoryComposite((Composite)sf);
        this.createFormatComposite((Composite)sf);
        this.FirstSetDataToControls();
        sf.setWeights(new int[]{50, 50});
        sf.setLayoutData((Object)new GridData(1808));
        sf.SASH_WIDTH = 8;
        return sf;
    }

    protected void FirstSetDataToControls() {
        ArrayList al = this.GetTypeDocuments();
        int i = 0;
        while (i < al.size()) {
            ReferenceFormatTypeData foty = new ReferenceFormatTypeData((Document)al.get(i));
            this.typeTableViewer.add((Object)foty);
            this.readNewDoc(foty);
            ++i;
        }
        if (al.size() > 0) {
            this.typeTableViewer.getTable().deselectAll();
            this.typeTableViewer.getTable().select(0);
            ReferenceFormatTypeData foty = (ReferenceFormatTypeData)this.typeTableViewer.getElementAt(0);
            this.selectedTypeTableViewer(foty);
        }
    }

    private void createCategoryComposite(Composite parent) {
        GridLayout gl = null;
        GridData gd = null;
        Composite left = new Composite(parent, 2048);
        gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        left.setLayout((Layout)gl);
        SashForm sf = new SashForm(left, 256);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        this.typeTableViewer = new TableViewer((Composite)sf, 66308);
        this.typeTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.typeTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.typeTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.typeTableViewer.getTable().setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.typeTableViewer.getTable(), 16384, 0);
        tc.setText("Type");
        this.typeTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ReferenceFormatPreferencePage.this.typeTableViewer.getTable().getClientArea();
                TableColumn[] col = ReferenceFormatPreferencePage.this.typeTableViewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.typeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof ReferenceFormatTypeData) {
                    ReferenceFormatTypeData foty = (ReferenceFormatTypeData)obj;
                    ReferenceFormatPreferencePage.this.selectedTypeTableViewer(foty);
                }
            }
        });
        Composite formatComposite = new Composite((Composite)sf, 0);
        formatComposite.setLayoutData((Object)new GridData(1808));
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        formatComposite.setLayout((Layout)gl);
        this.formatListTableViewer = CheckboxTableViewer.newCheckList((Composite)formatComposite, (int)66340);
        this.formatListTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.formatListTableViewer.getTable().setLinesVisible(true);
        this.formatListTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.formatListTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.formatListTableViewer.getTable().setHeaderVisible(true);
        TableColumn tc2 = new TableColumn(this.formatListTableViewer.getTable(), 16384, 0);
        tc2.setText("Format");
        this.formatListTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getClientArea();
                TableColumn[] col = ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.formatListTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem ti = (TableItem)event.item;
                    ReferenceFormatTypeData foty = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                    if (foty != null) {
                        foty.setFormatListIndex(ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().indexOf(ti));
                    }
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getItemCount()) {
                        if (!ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getItem(i).equals(ti)) {
                            ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getItem(i).setChecked(false);
                        }
                        ++i;
                    }
                }
            }
        });
        this.formatListTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof ReferenceFormatData) {
                    ReferenceFormatData fodt = (ReferenceFormatData)obj;
                    ReferenceFormatPreferencePage.this.initFormatEditView(fodt);
                }
            }
        });
        this.formatListTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                ArrayList formatNameList = (ArrayList)ReferenceFormatPreferencePage.this.formatListTableViewer.getInput();
                if (formatNameList.get(0).equals(obj)) {
                    return;
                }
                ReferenceFormatData oldfodt = (ReferenceFormatData)obj;
                if (oldfodt == null) {
                    return;
                }
                InputDialog dlg = new InputDialog(ReferenceFormatPreferencePage.this._parent.getShell(), "Input Format Name", "Format Name:", oldfodt.getName(), new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Please input Format Name.";
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    oldfodt.setName(dlg.getValue());
                    ReferenceFormatPreferencePage.this.formatListTableViewer.update((Object)oldfodt, null);
                }
                dlg = null;
            }
        });
        Composite formatListTableControlComposite = new Composite(formatComposite, 0);
        formatListTableControlComposite.setLayoutData((Object)new GridData(1040));
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        formatListTableControlComposite.setLayout((Layout)gl);
        Button plus = new Button(formatListTableControlComposite, 8);
        gd = new GridData(768);
        plus.setLayoutData((Object)gd);
        plus.setText("new");
        plus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatTypeData foty;
                InputDialog dlg = new InputDialog(ReferenceFormatPreferencePage.this._parent.getShell(), "Input Format Name", "Format Name:", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Please input Format Name.";
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0 && (foty = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer()) != null) {
                    ReferenceFormatData newfodt = foty.newReferenceFormatData(dlg.getValue());
                    ReferenceFormatPreferencePage.this.formatListTableViewer.setInput((Object)foty.getFormatList());
                    ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().select(ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getItemCount() - 1);
                    ReferenceFormatPreferencePage.this.initFormatEditView(newfodt);
                }
                dlg = null;
            }
        });
        Button minus = new Button(formatListTableControlComposite, 8);
        gd = new GridData(768);
        minus.setLayoutData((Object)gd);
        minus.setText("delete");
        minus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatTypeData foty;
                ArrayList formatNameList;
                ReferenceFormatData fodt = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                if (fodt != null && !(formatNameList = (ArrayList)ReferenceFormatPreferencePage.this.formatListTableViewer.getInput()).get(0).equals(fodt) && (foty = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer()) != null) {
                    foty.removeFormatData(fodt);
                    ReferenceFormatPreferencePage.this.formatListTableViewer.setInput((Object)foty.getFormatList());
                    foty.setFormatListIndex(0);
                    ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().getItem(0).setChecked(true);
                    ReferenceFormatPreferencePage.this.formatListTableViewer.getTable().select(0);
                    ReferenceFormatPreferencePage.this.initFormatEditView((ReferenceFormatData)foty.getFormatList().get(0));
                }
            }
        });
        sf.setWeights(new int[]{30, 70});
    }

    private void selectedTypeTableViewer(ReferenceFormatTypeData foty) {
        this.formatListTableViewer.getTable().deselectAll();
        this.formatListTableViewer.setInput((Object)foty.getFormatList());
        int i = 0;
        while (i < foty.getFormatList().size()) {
            ReferenceFormatData fodt = (ReferenceFormatData)foty.getFormatList().get(i);
            this.formatListTableViewer.setChecked((Object)fodt, foty.getFormatListIndex() == i);
            ++i;
        }
        this.formatListTableViewer.getTable().select(foty.getFormatListIndex());
        ReferenceFormatData fodt = (ReferenceFormatData)foty.getFormatList().get(foty.getFormatListIndex());
        this.initFormatEditView(fodt);
    }

    private ReferenceFormatData getSelectionFormatListTableViewer() {
        Object obj;
        ISelection selection = this.formatListTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceFormatData) {
            return (ReferenceFormatData)obj;
        }
        return null;
    }

    private ReferenceFormatTypeData getSelectionTypeTableViewer() {
        Object obj;
        ISelection selection = this.typeTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceFormatTypeData) {
            return (ReferenceFormatTypeData)obj;
        }
        return null;
    }

    private ArrayList<Object> getFormatItemList() {
        ArrayList pl = (ArrayList)this.formatEditView.getInput();
        if (pl == null) {
            pl = new ArrayList();
            pl.add(new ArrayList());
            this.formatEditView.setInput(pl);
        } else if (pl.size() == 0) {
            pl.add(new ArrayList());
        }
        return (ArrayList)pl.get(0);
    }

    private void initFormatEditView(ReferenceFormatData fodt) {
        this.colSelectIndex = -1;
        if (fodt != null) {
            ArrayList<Object> formatArray;
            this.formatEditView.getTable().setVisible(false);
            TableColumn[] cols = this.formatEditView.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].dispose();
                ++i;
            }
            ArrayList<ArrayList<Object>> pl = (ArrayList<ArrayList<Object>>)this.formatEditView.getInput();
            if (pl != null) {
                formatArray = fodt.getItemList();
                if (pl.size() > 0) {
                    pl.set(0, formatArray);
                } else {
                    pl.add(formatArray);
                }
            } else {
                pl = new ArrayList<ArrayList<Object>>();
                formatArray = fodt.getItemList();
                pl.add(formatArray);
                this.formatEditView.setInput(pl);
            }
            int i2 = 0;
            while (i2 < this.getFormatItemList().size()) {
                new TableColumn(this.formatEditView.getTable(), 0x1000000);
                ++i2;
            }
            int index = fodt.getFontItemIndex();
            if (index >= 0 && index < ReferenceFormatData.fontitems.length) {
                this.fontCombo.select(index);
            } else {
                this.fontCombo.select(0);
            }
            this.fontSizeSpinner.setSelection(fodt.getFontSize());
            this.boldButton.setEnabled(false);
            this.italicButton.setEnabled(false);
            this.formatEditView.getTable().setFont(new Font(null, fodt.getFontname(), fodt.getFontSize(), 0));
            TableItem ti = this.formatEditView.getTable().getItem(0);
            int i3 = 0;
            while (i3 < this.getFormatItemList().size()) {
                short style = 0;
                Object cont = this.getFormatItemList().get(i3);
                if (cont instanceof ReferenceFormatItem) {
                    if (((ReferenceFormatItem)cont).getBold()) {
                        style = (short)(style | 1);
                    }
                    if (((ReferenceFormatItem)cont).getItalic()) {
                        style = (short)(style | 2);
                    }
                }
                ti.setFont(i3, null);
                ti.setFont(i3, new Font(null, fodt.getFontname(), fodt.getFontSize(), (int)style));
                ++i3;
            }
            this.setColumnWidthOnFormatEditView();
            this.formatEditView.refresh();
            this.formatEditView.getTable().setVisible(true);
        } else {
            TableColumn[] cols = this.formatEditView.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].dispose();
                ++i;
            }
            this.getFormatItemList().clear();
            ArrayList pl = (ArrayList)this.formatEditView.getInput();
            pl.set(0, new ArrayList());
            this.fontCombo.deselectAll();
            this.fontSizeSpinner.setSelection(0);
            this.boldButton.setEnabled(false);
            this.italicButton.setEnabled(false);
            this.formatEditView.refresh();
        }
    }

    private void createFormatComposite(Composite parent) {
        GridLayout gl = null;
        Composite underComposite = new Composite(parent, 2048);
        gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        underComposite.setLayout((Layout)gl);
        Composite centerComposite = new Composite(underComposite, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        centerComposite.setLayout((Layout)gl);
        centerComposite.setLayoutData((Object)new GridData(1808));
        this.createFormatEditView(centerComposite);
        Composite actionComposite = new Composite(centerComposite, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        actionComposite.setLayout((Layout)gl);
        actionComposite.setLayoutData((Object)new GridData(1040));
        Button editButton = new Button(actionComposite, 8);
        editButton.setText("Edit");
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.editAction.run();
            }
        });
        Button addSchemaButton = new Button(actionComposite, 8);
        addSchemaButton.setText("Add Schema");
        addSchemaButton.setLayoutData((Object)new GridData(768));
        addSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.addSchemaAction.run();
            }
        });
        Button addTextButton = new Button(actionComposite, 8);
        addTextButton.setText("Add Text");
        addTextButton.setLayoutData((Object)new GridData(768));
        addTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.addTextAction.run();
            }
        });
        Button deleteButton = new Button(actionComposite, 8);
        deleteButton.setText("Delete");
        deleteButton.setLayoutData((Object)new GridData(768));
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.deleteAction.run();
            }
        });
        Composite bottomComposite = new Composite(underComposite, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bottomComposite.setLayout((Layout)gl);
        bottomComposite.setLayoutData((Object)new GridData(768));
        Group fg2 = new Group(bottomComposite, 0);
        fg2.setLayoutData((Object)new GridData(1040));
        fg2.setLayout((Layout)new GridLayout(2, false));
        this.fontCombo = new Combo((Composite)fg2, 8);
        this.fontCombo.setItems(ReferenceFormatData.fontitems);
        this.fontCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatData data = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                if (data != null) {
                    data.setFontItemIndex(((Combo)e.getSource()).getSelectionIndex());
                    ReferenceFormatPreferencePage.this.formatEditView.getTable().setFont(new Font(null, data.getFontname(), data.getFontSize(), 0));
                    TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                        Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(i);
                        short style = 0;
                        if (cont instanceof ReferenceFormatItem) {
                            if (((ReferenceFormatItem)cont).getBold()) {
                                style = (short)(style | 1);
                            }
                            if (((ReferenceFormatItem)cont).getItalic()) {
                                style = (short)(style | 2);
                            }
                        }
                        ti.setFont(i, null);
                        ti.setFont(i, new Font(null, data.getFontname(), data.getFontSize(), (int)style));
                        ++i;
                    }
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                }
            }
        });
        this.fontSizeSpinner = new Spinner((Composite)fg2, 2048);
        this.fontSizeSpinner.setMinimum(8);
        this.fontSizeSpinner.setMaximum(64);
        this.fontSizeSpinner.setSelection(12);
        this.fontSizeSpinner.setIncrement(1);
        this.fontSizeSpinner.setPageIncrement(4);
        this.fontSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatData data = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                if (data != null) {
                    data.setFontSize(((Spinner)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.formatEditView.getTable().setFont(new Font(null, data.getFontname(), data.getFontSize(), 0));
                    TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                        short style = 0;
                        Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(i);
                        if (cont instanceof ReferenceFormatItem) {
                            if (((ReferenceFormatItem)cont).getBold()) {
                                style = (short)(style | 1);
                            }
                            if (((ReferenceFormatItem)cont).getItalic()) {
                                style = (short)(style | 2);
                            }
                        }
                        ti.setFont(i, null);
                        ti.setFont(i, new Font(null, data.getFontname(), data.getFontSize(), (int)style));
                        ++i;
                    }
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                }
            }
        });
        Group fg3 = new Group(bottomComposite, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        fg3.setLayout((Layout)gl);
        fg3.setLayoutData((Object)new GridData(1808));
        this.boldButton = new Button((Composite)fg3, 32);
        this.boldButton.setLayoutData((Object)new GridData(1024));
        this.boldButton.setText("Bold");
        this.boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                    ReferenceFormatPreferencePage.this.boldAction.setChecked(((Button)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.boldAction.run();
                }
            }
        });
        this.boldButton.setEnabled(false);
        this.boldButton.setSelection(false);
        this.italicButton = new Button((Composite)fg3, 32);
        this.italicButton.setLayoutData((Object)new GridData(1024));
        this.italicButton.setText("Italic");
        this.italicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                    ReferenceFormatPreferencePage.this.italicAction.setChecked(((Button)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.italicAction.run();
                }
            }
        });
        this.italicButton.setEnabled(false);
        this.italicButton.setSelection(false);
    }

    private void createFormatEditView(Composite parent) {
        this.formatEditView = new TableViewer(parent, 16843524);
        this.formatEditView.getControl().setLayoutData((Object)new GridData(1808));
        this.formatEditView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.formatEditView.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.formatEditView.getTable().setFont(new Font(null, ReferenceFormatData.getDefaultFontName(), 12, 0));
        ArrayList pl = new ArrayList();
        ArrayList formatArray = new ArrayList();
        pl.add(formatArray);
        this.formatEditView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
            }
        });
        this.formatEditView.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ReferenceFormatPreferencePage.this.colSelectIndex = -1;
                Point pt = new Point(event.x, event.y);
                TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                if (ti != null) {
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount()) {
                        Rectangle rect = ti.getBounds(i);
                        if (rect.contains(pt)) {
                            ReferenceFormatPreferencePage.this.colSelectIndex = i;
                            break;
                        }
                        ++i;
                    }
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
                if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                    ReferenceFormatPreferencePage.this.deleteAction.setEnabled(true);
                    Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(ReferenceFormatPreferencePage.this.colSelectIndex);
                    if (cont instanceof ReferenceFormatItem) {
                        ReferenceFormatPreferencePage.this.boldAction.setEnabled(true);
                        ReferenceFormatPreferencePage.this.boldAction.setChecked(((ReferenceFormatItem)cont).getBold());
                        ReferenceFormatPreferencePage.this.italicAction.setEnabled(true);
                        ReferenceFormatPreferencePage.this.italicAction.setChecked(((ReferenceFormatItem)cont).getItalic());
                        ReferenceFormatPreferencePage.this.underlineAction.setEnabled(true);
                        ReferenceFormatPreferencePage.this.underlineAction.setChecked(((ReferenceFormatItem)cont).getUnderline());
                        ReferenceFormatPreferencePage.this.boldButton.setEnabled(true);
                        ReferenceFormatPreferencePage.this.boldButton.setSelection(((ReferenceFormatItem)cont).getBold());
                        ReferenceFormatPreferencePage.this.italicButton.setEnabled(true);
                        ReferenceFormatPreferencePage.this.italicButton.setSelection(((ReferenceFormatItem)cont).getItalic());
                        if (cont instanceof ReferenceFormatIdentifiersItemData) {
                            ReferenceFormatPreferencePage.this.editAction.setEnabled(true);
                        } else if (cont instanceof ReferenceFormatAuthorsItemData) {
                            ReferenceFormatPreferencePage.this.editAction.setEnabled(true);
                        } else {
                            ReferenceFormatPreferencePage.this.editAction.setEnabled(false);
                        }
                    } else {
                        ReferenceFormatPreferencePage.this.editAction.setEnabled(true);
                        ReferenceFormatPreferencePage.this.boldAction.setEnabled(false);
                        ReferenceFormatPreferencePage.this.boldAction.setChecked(false);
                        ReferenceFormatPreferencePage.this.italicAction.setEnabled(false);
                        ReferenceFormatPreferencePage.this.italicAction.setChecked(false);
                        ReferenceFormatPreferencePage.this.underlineAction.setEnabled(false);
                        ReferenceFormatPreferencePage.this.underlineAction.setChecked(false);
                        ReferenceFormatPreferencePage.this.boldButton.setEnabled(false);
                        ReferenceFormatPreferencePage.this.boldButton.setSelection(false);
                        ReferenceFormatPreferencePage.this.italicButton.setEnabled(false);
                        ReferenceFormatPreferencePage.this.italicButton.setSelection(false);
                    }
                } else {
                    ReferenceFormatPreferencePage.this.editAction.setEnabled(false);
                    ReferenceFormatPreferencePage.this.deleteAction.setEnabled(false);
                    ReferenceFormatPreferencePage.this.boldAction.setEnabled(false);
                    ReferenceFormatPreferencePage.this.boldAction.setChecked(false);
                    ReferenceFormatPreferencePage.this.italicAction.setEnabled(false);
                    ReferenceFormatPreferencePage.this.italicAction.setChecked(false);
                    ReferenceFormatPreferencePage.this.underlineAction.setEnabled(false);
                    ReferenceFormatPreferencePage.this.underlineAction.setChecked(false);
                    ReferenceFormatPreferencePage.this.boldButton.setEnabled(false);
                    ReferenceFormatPreferencePage.this.boldButton.setSelection(false);
                    ReferenceFormatPreferencePage.this.italicButton.setEnabled(false);
                    ReferenceFormatPreferencePage.this.italicButton.setSelection(false);
                }
            }
        });
        this.formatEditView.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0) {
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
        this.rectTextColor = new Color(null, 164, 189, 236);
        this.fillTextColor = new Color(null, 222, 231, 248);
        this.rectSchemaColor = new Color(null, 129, 184, 127);
        this.fillSchemaColor = new Color(null, 212, 255, 191);
        this.formatEditView.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Object cont;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                Color fillColor = ReferenceFormatPreferencePage.this.fillTextColor;
                Color rectColor = ReferenceFormatPreferencePage.this.rectTextColor;
                ArrayList obj = ReferenceFormatPreferencePage.this.getFormatItemList();
                if (obj instanceof ArrayList && (cont = obj.get(event.index)) instanceof ReferenceFormatItem) {
                    fillColor = ReferenceFormatPreferencePage.this.fillSchemaColor;
                    rectColor = ReferenceFormatPreferencePage.this.rectSchemaColor;
                }
                if (SystemUtil.GetOSType() == 1) {
                    if (event.index == ReferenceFormatPreferencePage.this.colSelectIndex) {
                        gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                        gc.fillRectangle(event.x - 2, event.y, event.width + 4, event.height);
                        gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                        gc.fillRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                        gc.setForeground(rectColor);
                        gc.drawRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                    } else {
                        gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                        gc.fillRectangle(event.x - 2, event.y, event.width + 4, event.height);
                        gc.setBackground(fillColor);
                        gc.fillRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                        gc.setForeground(rectColor);
                        gc.drawRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                    }
                } else if (event.index == ReferenceFormatPreferencePage.this.colSelectIndex) {
                    gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                    gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                    gc.fillRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                    gc.setForeground(rectColor);
                    gc.drawRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                } else {
                    gc.setBackground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(1));
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                    gc.setBackground(fillColor);
                    gc.fillRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                    gc.setForeground(rectColor);
                    gc.drawRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                }
                gc.setForeground(ReferenceFormatPreferencePage.this.formatEditView.getTable().getDisplay().getSystemColor(2));
                if (obj instanceof ArrayList) {
                    cont = obj.get(event.index);
                    if (cont instanceof String) {
                        String text = (String)cont;
                        Point size = gc.textExtent(text);
                        int offsetY = Math.max(0, event.height - size.y);
                        int offsetX = Math.max(0, (event.width - size.x) / 2);
                        gc.drawText(text, event.x + offsetX, event.y + offsetY, true);
                    } else if (cont instanceof ReferenceFormatItem) {
                        String text = ((ReferenceFormatItem)cont).getViewString();
                        Point size = gc.textExtent(text);
                        int offsetY = Math.max(0, event.height - size.y);
                        int offsetX = Math.max(0, (event.width - size.x) / 2);
                        gc.drawText(text, event.x + offsetX, event.y + offsetY, true);
                    }
                }
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
            }
        });
        int i = 0;
        while (i < formatArray.size()) {
            new TableColumn(this.formatEditView.getTable(), 0x1000000);
            ++i;
        }
        this.formatEditView.setInput(pl);
        TableItem ti = this.formatEditView.getTable().getItem(0);
        int i2 = 0;
        while (i2 < this.getFormatItemList().size()) {
            ti.setFont(i2, null);
            ti.setFont(i2, new Font(null, ReferenceFormatData.getDefaultFontName(), 12, 0));
            ++i2;
        }
        ReferenceFormatItemTransfer rftiTransfer = ReferenceFormatItemTransfer.getInstance();
        Transfer[] transferTypes = null;
        transferTypes = new Transfer[]{rftiTransfer};
        this.formatEditView.addDragSupport(18, transferTypes, (DragSourceListener)new DragFormatItemTableAdapter());
        this.formatEditView.addDropSupport(18, transferTypes, (DropTargetListener)new DropFormatItemTableAdapter());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void setColumnWidthOnFormatEditView() {
        GC gc = new GC((Drawable)this.formatEditView.getTable().getDisplay());
        ReferenceFormatData fodt = this.getSelectionFormatListTableViewer();
        int offsetX = 16;
        if (SystemUtil.GetOSType() == 1) {
            offsetX = 8;
        }
        TableColumn[] col = this.formatEditView.getTable().getColumns();
        int i = 0;
        while (i < col.length) {
            Object cont = this.getFormatItemList().get(i);
            if (cont instanceof String) {
                Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), 0);
                gc.setFont(font);
                Point pt = gc.textExtent((String)cont);
                int width = pt.x + offsetX;
                col[i].setWidth(width);
                gc.setFont(null);
                font.dispose();
            } else if (cont instanceof ReferenceFormatItem) {
                short style = 0;
                if (((ReferenceFormatItem)cont).getBold()) {
                    style = (short)(style | 1);
                }
                if (((ReferenceFormatItem)cont).getItalic()) {
                    style = (short)(style | 2);
                }
                Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), (int)style);
                gc.setFont(font);
                Point pt = gc.textExtent(((ReferenceFormatItem)cont).getViewString());
                int width = pt.x + offsetX;
                col[i].setWidth(width);
                gc.setFont(null);
                font.dispose();
            } else {
                col[i].setWidth(100);
            }
            ++i;
        }
        gc.dispose();
        gc = null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReferenceFormatPreferencePage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.formatEditView.getControl());
        this.formatEditView.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addSchemaAction);
        manager.add((IAction)this.addTextAction);
        if (this.colSelectIndex >= 0 && this.colSelectIndex < this.getFormatItemList().size()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.editAction);
            manager.add((IAction)this.deleteAction);
            Object cont = this.getFormatItemList().get(this.colSelectIndex);
            if (cont instanceof ReferenceFormatItem) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.boldAction);
                manager.add((IAction)this.italicAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.addSchemaAction = new Action(){

            public void run() {
                ReferenceFormatTypeData foty = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                String[] items = foty.getSchemaItems();
                ComboDialog dlg = new ComboDialog(ReferenceFormatPreferencePage.this.formatEditView.getTable().getShell(), items, 0);
                if (dlg.open() == 0) {
                    TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                    ReferenceFormatData fodt = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                    if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                        ReferenceFormatPreferencePage.this.getFormatItemList().add(ReferenceFormatPreferencePage.this.colSelectIndex, new ReferenceFormatItem(items[dlg.getValue()]));
                        new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                        int i = ReferenceFormatPreferencePage.this.getFormatItemList().size() - 2;
                        while (ReferenceFormatPreferencePage.this.colSelectIndex <= i) {
                            Font font = ti.getFont(i);
                            ti.setFont(i + 1, null);
                            ti.setFont(i + 1, font);
                            --i;
                        }
                        Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), 0);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    } else {
                        ReferenceFormatPreferencePage.this.getFormatItemList().add(new ReferenceFormatItem(items[dlg.getValue()]));
                        new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                        ReferenceFormatPreferencePage.this.colSelectIndex = ReferenceFormatPreferencePage.this.getFormatItemList().size() - 1;
                        Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), 0);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    }
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
            }
        };
        this.addSchemaAction.setText("Add Schema");
        this.addSchemaAction.setToolTipText("Add Schema");
        this.addSchemaAction.setEnabled(true);
        this.addTextAction = new Action(){

            public void run() {
                TextDialog dlg = new TextDialog(ReferenceFormatPreferencePage.this.formatEditView.getTable().getShell(), "");
                if (dlg.open() == 0) {
                    TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                    ReferenceFormatData fodt = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                    if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                        ReferenceFormatPreferencePage.this.getFormatItemList().add(ReferenceFormatPreferencePage.this.colSelectIndex, new String(dlg.getValue()));
                        new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                        int i = ReferenceFormatPreferencePage.this.getFormatItemList().size() - 2;
                        while (ReferenceFormatPreferencePage.this.colSelectIndex <= i) {
                            Font font = ti.getFont(i);
                            ti.setFont(i + 1, null);
                            ti.setFont(i + 1, font);
                            --i;
                        }
                        Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), 0);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    } else {
                        ReferenceFormatPreferencePage.this.getFormatItemList().add(new String(dlg.getValue()));
                        new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                        ReferenceFormatPreferencePage.this.colSelectIndex = ReferenceFormatPreferencePage.this.getFormatItemList().size() - 1;
                        Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), 0);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                        ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    }
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
            }
        };
        this.addTextAction.setText("Add Text");
        this.addTextAction.setToolTipText("Add Text");
        this.addTextAction.setEnabled(true);
        this.deleteAction = new Action(){

            public void run() {
                TableColumn tc;
                if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount() && (tc = ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumn(ReferenceFormatPreferencePage.this.colSelectIndex)) != null) {
                    tc.dispose();
                }
                if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < ReferenceFormatPreferencePage.this.getFormatItemList().size()) {
                    ReferenceFormatPreferencePage.this.getFormatItemList().remove(ReferenceFormatPreferencePage.this.colSelectIndex);
                }
                ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                ReferenceFormatPreferencePage.this.formatEditView.refresh();
                ReferenceFormatPreferencePage.this.colSelectIndex = -1;
            }
        };
        this.deleteAction.setText("Delete");
        this.deleteAction.setToolTipText("Delete");
        this.deleteAction.setEnabled(false);
        this.italicAction = new Action(){

            public void run() {
                TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(ReferenceFormatPreferencePage.this.colSelectIndex);
                if (cont instanceof ReferenceFormatItem) {
                    ((ReferenceFormatItem)cont).setItalic(ReferenceFormatPreferencePage.this.italicAction.isChecked());
                    ReferenceFormatData fodt = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                    short style = 0;
                    if (((ReferenceFormatItem)cont).getBold()) {
                        style = (short)(style | 1);
                    }
                    if (ReferenceFormatPreferencePage.this.italicAction.isChecked()) {
                        style = (short)(style | 2);
                    }
                    Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), (int)style);
                    ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                    ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
            }
        };
        this.italicAction.setText("Italic");
        this.italicAction.setToolTipText("Italic");
        this.italicAction.setEnabled(false);
        this.italicAction.setChecked(false);
        this.boldAction = new Action(){

            public void run() {
                TableItem ti = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(ReferenceFormatPreferencePage.this.colSelectIndex);
                if (cont instanceof ReferenceFormatItem) {
                    ((ReferenceFormatItem)cont).setBold(ReferenceFormatPreferencePage.this.boldAction.isChecked());
                    ReferenceFormatData fodt = ReferenceFormatPreferencePage.this.getSelectionFormatListTableViewer();
                    short style = 0;
                    if (ReferenceFormatPreferencePage.this.boldAction.isChecked()) {
                        style = (short)(style | 1);
                    }
                    if (((ReferenceFormatItem)cont).getItalic()) {
                        style = (short)(style | 2);
                    }
                    Font font = new Font(null, fodt.getFontname(), fodt.getFontSize(), (int)style);
                    ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, null);
                    ti.setFont(ReferenceFormatPreferencePage.this.colSelectIndex, font);
                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
            }
        };
        this.boldAction.setText("Bold");
        this.boldAction.setToolTipText("Bold");
        this.boldAction.setEnabled(false);
        this.boldAction.setChecked(false);
        this.underlineAction = new Action(){

            public void run() {
                Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(ReferenceFormatPreferencePage.this.colSelectIndex);
                if (cont instanceof ReferenceFormatItem) {
                    ((ReferenceFormatItem)cont).setUnderline(ReferenceFormatPreferencePage.this.underlineAction.isChecked());
                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                }
            }
        };
        this.underlineAction.setText("Underline");
        this.underlineAction.setToolTipText("Underline");
        this.underlineAction.setEnabled(false);
        this.underlineAction.setChecked(false);
        this.editAction = new Action(){

            public void run() {
                ISelection selection = ReferenceFormatPreferencePage.this.formatEditView.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && obj instanceof ArrayList) {
                    Object cont = ((ArrayList)obj).get(ReferenceFormatPreferencePage.this.colSelectIndex);
                    if (cont instanceof String) {
                        TextDialog dlg = new TextDialog(ReferenceFormatPreferencePage.this.formatEditView.getTable().getShell(), (String)cont);
                        if (dlg.open() == 0) {
                            ArrayList al = (ArrayList)obj;
                            al.set(ReferenceFormatPreferencePage.this.colSelectIndex, new String(dlg.getValue()));
                            ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                            ReferenceFormatPreferencePage.this.formatEditView.refresh();
                        }
                    } else if (cont instanceof ReferenceFormatAuthorsItemData) {
                        ReferenceFormatAuthorsItemData data = (ReferenceFormatAuthorsItemData)cont;
                        ComboDialog dlg = new ComboDialog(ReferenceFormatPreferencePage.this.formatEditView.getTable().getShell(), ReferenceFormatAuthorsItemData.items, data.getIndex());
                        if (dlg.open() == 0) {
                            data.setIndex(dlg.getValue());
                        }
                    } else if (cont instanceof ReferenceFormatIdentifiersItemData) {
                        ReferenceFormatIdentifiersItemData data = (ReferenceFormatIdentifiersItemData)cont;
                        ComboDialog dlg = new ComboDialog(ReferenceFormatPreferencePage.this.formatEditView.getTable().getShell(), ReferenceFormatIdentifiersItemData.items, data.getIndex());
                        if (dlg.open() == 0) {
                            data.setIndex(dlg.getValue());
                        }
                    } else {
                        boolean cfr_ignored_0 = cont instanceof ReferenceFormatItem;
                    }
                }
            }
        };
        this.editAction.setText("Edit");
        this.editAction.setToolTipText("Edit");
        this.editAction.setEnabled(false);
    }

    private void hookDoubleClickAction() {
        this.formatEditView.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReferenceFormatPreferencePage.this.editAction.run();
            }
        });
    }

    private void DoSave() {
        this.deleteReferenceFormat();
        this.saveReferenceFormat();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceFormatTypeData foty = (ReferenceFormatTypeData)this.typeTableViewer.getElementAt(i);
            ArrayList al = foty.getFormatList();
            int j = 0;
            while (j < al.size()) {
                ReferenceFormatData fodt = (ReferenceFormatData)al.get(j);
                ReferenceFormatDomImpl.setFormatData(foty.getID(), fodt);
                ++j;
            }
            ++i;
        }
    }

    private void deleteReferenceFormat() {
        String xpath = new String();
        xpath = String.valueOf(xpath) + "/";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "referenceformat");
        ArrayList<Document> docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            int i = 0;
            while (i < docs.size()) {
                reqs.add(new Request(2, docs.get(i), "referenceformat"));
                ++i;
            }
            FrameworkPlugin.getDefault().updateDocuments(reqs, "jp.sourceforge.concierge.framework.preferences.ReferenceFormatPreferencePage");
            reqs.clear();
            reqs = null;
        }
        docs = null;
    }

    private void saveReferenceFormat() {
        ArrayList<Request> reqs = new ArrayList<Request>();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceFormatTypeData foty = (ReferenceFormatTypeData)this.typeTableViewer.getElementAt(i);
            Document doc = this.writeNewDoc(foty);
            if (doc != null) {
                reqs.add(new Request(1, doc, "referenceformat"));
            }
            ++i;
        }
        if (reqs.size() > 0) {
            FrameworkPlugin.getDefault().updateDocuments(reqs, "jp.sourceforge.concierge.framework.preferences.ReferenceFormatPreferencePage");
        }
    }

    private Document writeNewDoc(ReferenceFormatTypeData foty) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument("format", true);
            Element root_elem = doc.getDocumentElement();
            root_elem.setAttribute("typeid", String.valueOf(foty.getID()));
            root_elem.setAttribute("select", String.valueOf(foty.getFormatListIndex()));
            ArrayList formatList = foty.getFormatList();
            int j = 0;
            while (j < formatList.size()) {
                ReferenceFormatData fodt = (ReferenceFormatData)formatList.get(j);
                Element rfnd_elem = doc.createElement("items");
                root_elem.appendChild(rfnd_elem);
                rfnd_elem.setAttribute("formatname", fodt.getName());
                rfnd_elem.setAttribute("fontname", fodt.getFontname());
                rfnd_elem.setAttribute("fontsize", String.valueOf(fodt.getFontSize()));
                ArrayList<Object> itemList = fodt.getItemList();
                int k = 0;
                while (k < itemList.size()) {
                    Element item_elem;
                    Object data;
                    Object obj = itemList.get(k);
                    if (obj instanceof ReferenceFormatItem) {
                        data = (ReferenceFormatItem)obj;
                        item_elem = doc.createElement("item");
                        rfnd_elem.appendChild(item_elem);
                        if (obj instanceof ReferenceFormatAuthorsItemData) {
                            item_elem.setAttribute("class", "ReferenceFormatAuthorsItemData");
                        } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                            item_elem.setAttribute("class", "ReferenceFormatIdentifiersItemData");
                        } else {
                            item_elem.setAttribute("class", "ReferenceFormatItem");
                        }
                        item_elem.setAttribute("name", ((ReferenceFormatItem)data).toString());
                        item_elem.setAttribute("bold", String.valueOf(((ReferenceFormatItem)data).getBold()));
                        item_elem.setAttribute("italic", String.valueOf(((ReferenceFormatItem)data).getItalic()));
                        item_elem.setAttribute("underline", String.valueOf(((ReferenceFormatItem)data).getUnderline()));
                        if (obj instanceof ReferenceFormatAuthorsItemData) {
                            int index = ((ReferenceFormatAuthorsItemData)obj).getIndex();
                            item_elem.setAttribute("index", String.valueOf(index));
                        } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                            String idtype = ((ReferenceFormatIdentifiersItemData)obj).getItem();
                            item_elem.setAttribute("idtype", idtype);
                        }
                    } else if (obj instanceof String) {
                        data = (String)obj;
                        item_elem = doc.createElement("item");
                        rfnd_elem.appendChild(item_elem);
                        item_elem.setAttribute("class", "String");
                        item_elem.setAttribute("name", (String)data);
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readNewDoc(ReferenceFormatTypeData foty) {
        ArrayList formatList;
        String xpath = "/format[@typeid='" + String.valueOf(foty.getID()) + "']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "referenceformat");
        ArrayList<Document> docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = docs.get(0);
            Element root_elem = doc.getDocumentElement();
            String selectString = root_elem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            foty.setFormatListIndex(Integer.valueOf(selectString));
            Node rfnd_node = root_elem.getFirstChild();
            while (rfnd_node != null) {
                if (rfnd_node.getNodeType() == 1) {
                    ReferenceFormatData fodt = new ReferenceFormatData(((Element)rfnd_node).getAttribute("formatname"));
                    foty.addFormatData(fodt);
                    fodt.setFontname(((Element)rfnd_node).getAttribute("fontname"));
                    String fontsize = ((Element)rfnd_node).getAttribute("fontsize");
                    fodt.setFontSize(Integer.valueOf(fontsize));
                    Node rftid_node = rfnd_node.getFirstChild();
                    while (rftid_node != null) {
                        if (rftid_node.getNodeType() == 1) {
                            int i;
                            String[] items;
                            String name;
                            String classname = ((Element)rftid_node).getAttribute("class");
                            if (classname.equalsIgnoreCase("ReferenceFormatTypeItemData") || classname.equalsIgnoreCase("ReferenceFormatItem")) {
                                name = ((Element)rftid_node).getAttribute("name");
                                items = foty.getSchemaItems();
                                i = 0;
                                while (i < items.length) {
                                    if (items[i].equals(name)) {
                                        ReferenceFormatItem foit = new ReferenceFormatItem(name);
                                        fodt.addItemList(foit);
                                        foit.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                        foit.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                        foit.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                        break;
                                    }
                                    ++i;
                                }
                            } else if (classname.equalsIgnoreCase("ReferenceFormatAuthorsItemData")) {
                                name = ((Element)rftid_node).getAttribute("name");
                                items = foty.getSchemaItems();
                                i = 0;
                                while (i < items.length) {
                                    if (items[i].equals(name)) {
                                        ReferenceFormatAuthorsItemData rfaid = new ReferenceFormatAuthorsItemData(name);
                                        fodt.addItemList(rfaid);
                                        rfaid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                        rfaid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                        rfaid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                        String indexStr = ((Element)rftid_node).getAttribute("index");
                                        int index = 0;
                                        try {
                                            index = Integer.valueOf(indexStr);
                                        }
                                        catch (Exception exception) {}
                                        rfaid.setIndex(index);
                                        break;
                                    }
                                    ++i;
                                }
                            } else if (classname.equalsIgnoreCase("ReferenceFormatIdentifiersItemData")) {
                                name = ((Element)rftid_node).getAttribute("name");
                                items = foty.getSchemaItems();
                                i = 0;
                                while (i < items.length) {
                                    if (items[i].equals(name)) {
                                        ReferenceFormatIdentifiersItemData rfiid = new ReferenceFormatIdentifiersItemData(name);
                                        fodt.addItemList(rfiid);
                                        rfiid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                        rfiid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                        rfiid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                        String idtype = ((Element)rftid_node).getAttribute("idtype");
                                        rfiid.setItem(idtype);
                                        break;
                                    }
                                    ++i;
                                }
                            } else if (classname.equalsIgnoreCase("String")) {
                                name = ((Element)rftid_node).getAttribute("name");
                                fodt.addItemList(new String(name));
                            }
                        }
                        rftid_node = rftid_node.getNextSibling();
                    }
                }
                rfnd_node = rfnd_node.getNextSibling();
            }
        }
        if ((formatList = foty.getFormatList()).size() == 0) {
            foty.newReferenceFormatData("Default");
            foty.setFormatListIndex(0);
        }
    }

    protected ArrayList GetTypeDocuments() {
        FrameworkPlugin plugin = FrameworkPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        String xpath = "/type";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "type");
        ArrayList<Document> list = plugin.getDocumentsOfQuery(req);
        System.out.println("Result size = " + list.size());
        return list;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ArrayList al;
            if (obj instanceof ReferenceFormatTypeData) {
                ReferenceFormatTypeData foty = (ReferenceFormatTypeData)obj;
                if (index == 0) {
                    return foty.getTypeName();
                }
            } else if (obj instanceof ReferenceFormatData) {
                ReferenceFormatData fodt = (ReferenceFormatData)obj;
                if (index == 0) {
                    return fodt.getName();
                }
            } else if (obj instanceof ReferenceFormatItem) {
                ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                if (index == 0) {
                    return foit.toString();
                }
            } else if (obj instanceof ArrayList && (al = (ArrayList)obj).size() > 0) {
                Object cont = al.get(index);
                if (cont instanceof String) {
                    return (String)cont;
                }
                if (cont instanceof ReferenceFormatItem) {
                    return ((ReferenceFormatItem)cont).getViewString();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }
    }

    private class DragFormatItemTableAdapter
    extends DragSourceAdapter {
        private boolean isTableDrop = false;

        private DragFormatItemTableAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            if (ReferenceFormatItemTransfer.getInstance().isSupportedType(e.dataType)) {
                if (ReferenceFormatPreferencePage.this.colSelectIndex != -1) {
                    Integer integer = new Integer(ReferenceFormatPreferencePage.this.colSelectIndex);
                    e.data = integer;
                }
            } else if (TextTransfer.getInstance().isSupportedType(e.dataType)) {
                Object cont = ReferenceFormatPreferencePage.this.getFormatItemList().get(ReferenceFormatPreferencePage.this.colSelectIndex);
                if (cont instanceof String) {
                    e.data = (String)cont;
                } else if (cont instanceof ReferenceFormatItem) {
                    e.data = ((ReferenceFormatItem)cont).toString();
                }
            }
            this.isTableDrop = true;
        }

        public void dragStart(DragSourceEvent e) {
            this.isTableDrop = false;
        }

        public void dragFinished(DragSourceEvent e) {
            if (!this.isTableDrop) {
                ReferenceFormatPreferencePage.this.deleteAction.run();
            }
        }
    }

    private class DropFormatItemTableAdapter
    extends DropTargetAdapter {
        private DropFormatItemTableAdapter() {
        }

        public void drop(DropTargetEvent e) {
            TableItem ti;
            if (ReferenceFormatItemTransfer.getInstance().isSupportedType(e.currentDataType)) {
                TableItem ti2 = ReferenceFormatPreferencePage.this.formatEditView.getTable().getItem(0);
                if (ti2 != null) {
                    Point mousePt = new Point(e.x, e.y);
                    Integer integer = (Integer)e.data;
                    if (integer != null) {
                        Point pt;
                        int dragIndex = integer;
                        ArrayList al = (ArrayList)ti2.getData();
                        int i = 0;
                        while (i < ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount()) {
                            Rectangle rect = ti2.getBounds(i);
                            pt = ti2.getParent().toDisplay(rect.x, rect.y);
                            rect.x = pt.x;
                            rect.y = pt.y;
                            if (rect.x <= mousePt.x && mousePt.x <= rect.x + rect.width) {
                                if (dragIndex != i) {
                                    if (dragIndex >= 0 && dragIndex < al.size()) {
                                        Font aFont = ti2.getFont(dragIndex);
                                        Font bFont = ti2.getFont(i);
                                        ti2.setFont(dragIndex, null);
                                        ti2.setFont(dragIndex, bFont);
                                        ti2.setFont(i, null);
                                        ti2.setFont(i, aFont);
                                        Object dragObj = al.get(dragIndex);
                                        if (dragIndex < i) {
                                            al.remove(dragIndex);
                                            al.add(i, dragObj);
                                            ReferenceFormatPreferencePage.this.colSelectIndex = i;
                                        } else if (i < dragIndex) {
                                            al.remove(dragIndex);
                                            al.add(i, dragObj);
                                            ReferenceFormatPreferencePage.this.colSelectIndex = i;
                                        }
                                    } else {
                                        Object dragObj = null;
                                        al.add(i, dragObj);
                                        new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                                        ReferenceFormatPreferencePage.this.colSelectIndex = i;
                                    }
                                    ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                                    ReferenceFormatPreferencePage.this.formatEditView.refresh();
                                }
                                return;
                            }
                            ++i;
                        }
                        Rectangle rect = new Rectangle(0, 0, 0, 0);
                        if (ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount() > 0) {
                            rect = ti2.getBounds(ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount() - 1);
                        }
                        pt = ti2.getParent().toDisplay(rect.x + rect.width, rect.y + rect.height);
                        int x = pt.x;
                        Rectangle area = ti2.getParent().getClientArea();
                        pt = ti2.getParent().toDisplay(area.x + area.width, area.y + area.height);
                        int width = pt.x - x;
                        if (x <= mousePt.x && mousePt.x <= x + width) {
                            if (dragIndex != al.size() - 1) {
                                if (dragIndex >= 0 && dragIndex < al.size()) {
                                    Font aFont = ti2.getFont(dragIndex);
                                    Font bFont = ti2.getFont(al.size() - 1);
                                    ti2.setFont(dragIndex, null);
                                    ti2.setFont(dragIndex, bFont);
                                    ti2.setFont(al.size() - 1, null);
                                    ti2.setFont(al.size() - 1, aFont);
                                    Object dragObj = al.get(dragIndex);
                                    al.add(dragObj);
                                    al.remove(dragIndex);
                                    ReferenceFormatPreferencePage.this.colSelectIndex = al.size() - 1;
                                } else {
                                    Object dragObj = null;
                                    al.add(dragObj);
                                    new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                                    ReferenceFormatPreferencePage.this.colSelectIndex = al.size() - 1;
                                }
                                ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                                ReferenceFormatPreferencePage.this.formatEditView.refresh();
                            }
                            return;
                        }
                    }
                }
            } else if (TextTransfer.getInstance().isSupportedType(e.currentDataType) && (ti = (TableItem)e.item) != null) {
                Point mousePt = new Point(e.x, e.y);
                ArrayList al = (ArrayList)ti.getData();
                int i = 0;
                while (i < ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount()) {
                    Rectangle rect = ti.getBounds(i);
                    Point pt = ti.getParent().toDisplay(rect.x, rect.y);
                    rect.x = pt.x;
                    rect.y = pt.y;
                    if (rect.x <= mousePt.x && mousePt.x <= rect.x + rect.width) {
                        if (ReferenceFormatPreferencePage.this.colSelectIndex != i) {
                            Object dragObj = al.get(ReferenceFormatPreferencePage.this.colSelectIndex);
                            if (ReferenceFormatPreferencePage.this.colSelectIndex < i) {
                                al.remove(ReferenceFormatPreferencePage.this.colSelectIndex);
                                al.add(i, dragObj);
                                ReferenceFormatPreferencePage.this.colSelectIndex = i;
                            } else if (i < ReferenceFormatPreferencePage.this.colSelectIndex) {
                                al.remove(ReferenceFormatPreferencePage.this.colSelectIndex);
                                al.add(i, dragObj);
                                ReferenceFormatPreferencePage.this.colSelectIndex = i;
                            }
                            ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                            ReferenceFormatPreferencePage.this.formatEditView.refresh();
                        }
                        return;
                    }
                    ++i;
                }
                Rectangle rect = new Rectangle(0, 0, 0, 0);
                if (ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount() > 0) {
                    rect = ti.getBounds(ReferenceFormatPreferencePage.this.formatEditView.getTable().getColumnCount() - 1);
                }
                Point pt = ti.getParent().toDisplay(rect.x + rect.width, rect.y + rect.height);
                int x = pt.x;
                Rectangle area = ti.getParent().getClientArea();
                pt = ti.getParent().toDisplay(area.x + area.width, area.y + area.height);
                int width = pt.x - x;
                if (x <= mousePt.x && mousePt.x <= x + width) {
                    if (ReferenceFormatPreferencePage.this.colSelectIndex != al.size() - 1) {
                        if (ReferenceFormatPreferencePage.this.colSelectIndex >= 0 && ReferenceFormatPreferencePage.this.colSelectIndex < al.size()) {
                            Object dragObj = al.get(ReferenceFormatPreferencePage.this.colSelectIndex);
                            al.add(dragObj);
                            al.remove(ReferenceFormatPreferencePage.this.colSelectIndex);
                            ReferenceFormatPreferencePage.this.colSelectIndex = al.size() - 1;
                        } else {
                            Object dragObj = null;
                            al.add(dragObj);
                            new TableColumn(ReferenceFormatPreferencePage.this.formatEditView.getTable(), 0x1000000);
                            ReferenceFormatPreferencePage.this.colSelectIndex = al.size() - 1;
                        }
                        ReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditView();
                        ReferenceFormatPreferencePage.this.formatEditView.refresh();
                    }
                    return;
                }
            }
        }

        public void dragOver(DropTargetEvent e) {
            e.feedback |= 8;
        }
    }

    public class TextDialog
    extends Dialog {
        private Text text;
        private String value;

        protected TextDialog(Shell parentShell, String value) {
            super(parentShell);
            this.text = null;
            this.value = null;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        protected Point getInitialSize() {
            return new Point(320, 180);
        }

        protected Control createDialogArea(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            this.text = new Text(composite, 2048);
            gd = new GridData(768);
            this.text.setLayoutData((Object)gd);
            if (this.value != null) {
                this.text.setText(this.value);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                if (this.text.getText().length() > 0) {
                    this.value = this.text.getText();
                } else {
                    this.text.setText(this.value);
                    return;
                }
            }
            this.setReturnCode(buttonId);
            this.close();
            super.buttonPressed(buttonId);
        }
    }

    public class ComboDialog
    extends Dialog {
        private Combo combo;
        private int index;
        private String[] items;

        protected ComboDialog(Shell parentShell, String[] items, int index) {
            super(parentShell);
            this.combo = null;
            this.index = 0;
            this.items = null;
            this.items = items;
            this.index = index;
        }

        public int getValue() {
            return this.index;
        }

        protected Point getInitialSize() {
            return new Point(320, 180);
        }

        protected Control createDialogArea(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            this.combo = new Combo(composite, 8);
            gd = new GridData(768);
            this.combo.setLayoutData((Object)gd);
            if (this.items != null) {
                this.combo.setItems(this.items);
                this.combo.select(this.index);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                int index = this.combo.getSelectionIndex();
                if (index >= 0 && index < this.items.length) {
                    this.index = index;
                } else {
                    return;
                }
            }
            this.setReturnCode(buttonId);
            this.close();
            super.buttonPressed(buttonId);
        }
    }
}

