/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import jp.sourceforge.concierge.util.Base64;
import jp.sourceforge.concierge.util.DomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccountData {
    private Document mDoc = null;
    private int mStatus = 0;
    private static int mNumber = 0;
    private String accountname = null;
    private String url = null;
    private String autofill = null;
    private String user = null;
    private String passwd = null;
    private String comment = null;
    public static final int STATUS_NOUPDATE = 0;
    public static final int STATUS_UPDATE = 1;
    public static final int STATUS_DELETE = 2;
    public static final int STATUS_NEW = 3;

    public AccountData() {
        this.newDoc();
    }

    public AccountData(Document doc) {
        if (doc == null) {
            this.newDoc();
        } else {
            this.mDoc = doc;
            this.initDoc();
            this.mStatus = 0;
        }
    }

    private void newDoc() {
        this.mDoc = DomImpl.createDocument("account", true);
        this.initDoc();
        this.mStatus = 3;
        ++mNumber;
    }

    private void initDoc() {
        Node node;
        SecretKey secretkey;
        Element root = this.mDoc.getDocumentElement();
        String value = root.getAttribute("secretkey");
        if (value == null) {
            secretkey = this.createSecretKey();
            if (secretkey != null) {
                this.setSecretKey(secretkey);
            }
        } else if (value != null && value.length() == 0 && (secretkey = this.createSecretKey()) != null) {
            this.setSecretKey(secretkey);
        }
        if ((value = root.getAttribute("name")) == null) {
            value = "untitled " + String.valueOf(mNumber);
        } else if (value.length() == 0) {
            value = "untitled " + String.valueOf(mNumber);
        }
        this.accountname = value;
        value = root.getAttribute("url");
        if (value == null) {
            value = "";
        }
        this.url = value;
        value = root.getAttribute("autofill");
        if (value == null) {
            value = "false";
        }
        this.autofill = value;
        NodeList nl = root.getElementsByTagName("user");
        String value2 = null;
        if (nl.getLength() > 0) {
            node = nl.item(0);
            value2 = DomImpl.getElementText((Element)node);
        }
        if (value2 == null) {
            value2 = "";
        }
        this.user = value2;
        value = null;
        try {
            String elementText;
            NodeList nl2 = root.getElementsByTagName("passwd");
            if (nl2.getLength() > 0 && (elementText = DomImpl.getElementText((Element)(node = nl2.item(0)))) != null && elementText.length() > 0) {
                byte[] elementData = elementText.getBytes("US-ASCII");
                ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream(elementData, elementData.length);
                byte[] decodeData = baos.toByteArray();
                SecretKey secretKey = this.getSecretKey();
                byte[] decryptData = this.decrypt(decodeData, secretKey);
                value = new String(decryptData);
            }
        }
        catch (Exception exception) {}
        if (value == null) {
            value = "";
        }
        this.passwd = value;
        nl = root.getElementsByTagName("comment");
        value2 = null;
        if (nl.getLength() > 0) {
            node = nl.item(0);
            value2 = DomImpl.getElementText((Element)node);
        }
        if (value2 == null) {
            value2 = "";
        }
        this.comment = value2;
    }

    public Document getDoc(boolean updateDoc) {
        if (updateDoc) {
            this.updateDoc();
        }
        return this.mDoc;
    }

    private void updateDoc() {
        Node node;
        Element elem;
        NodeList nl;
        Element root = this.mDoc.getDocumentElement();
        if (this.accountname != null) {
            root.setAttribute("name", this.accountname);
        }
        if (this.url != null) {
            root.setAttribute("url", this.url);
        }
        if (this.autofill != null) {
            root.setAttribute("autofill", this.autofill);
        }
        if (this.user != null) {
            nl = root.getElementsByTagName("user");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (elem == null) {
                elem = this.mDoc.createElement("user");
                root.appendChild(elem);
            }
            DomImpl.setElementText(elem, this.user);
        }
        if (this.passwd != null) {
            try {
                nl = root.getElementsByTagName("passwd");
                elem = null;
                if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                    node = elem.getFirstChild();
                    while (node != null) {
                        elem.removeChild(node);
                        node = node.getNextSibling();
                    }
                }
                if (elem == null) {
                    elem = this.mDoc.createElement("passwd");
                    root.appendChild(elem);
                }
                SecretKey secretKey = this.getSecretKey();
                byte[] srcData = this.passwd.getBytes("US-ASCII");
                byte[] encryptData = this.encrypt(srcData, secretKey);
                String encodeStr = Base64.encodeToString(encryptData, encryptData.length);
                DomImpl.setElementText(elem, encodeStr);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if (this.comment != null) {
            nl = root.getElementsByTagName("comment");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (elem == null) {
                elem = this.mDoc.createElement("comment");
                root.appendChild(elem);
            }
            DomImpl.setElementText(elem, this.comment);
        }
    }

    public int getSTATUS() {
        return this.mStatus;
    }

    public void setSTATUS(int value) {
        this.mStatus = value;
    }

    public String getName() {
        return this.accountname;
    }

    public void setName(String value) {
        if (value != null && this.accountname != null && !this.accountname.equals(value)) {
            this.accountname = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getType() {
        Element root = this.mDoc.getDocumentElement();
        String value = root.getAttribute("type");
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        if (value != null && this.url != null && !this.url.equals(value)) {
            this.url = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public boolean isAutoFill() {
        return this.autofill.equalsIgnoreCase("true");
    }

    public void setAutoFill(boolean value) {
        String autoFillString = "false";
        if (value) {
            autoFillString = "true";
        }
        if (autoFillString != null && this.autofill != null && !this.autofill.equals(autoFillString)) {
            this.autofill = autoFillString;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        if (value != null && this.user != null && !this.user.equals(value)) {
            this.user = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String value) {
        if (value != null && this.passwd != null && !this.passwd.equals(value)) {
            this.passwd = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        if (value != null && this.comment != null && !this.comment.equals(value)) {
            this.comment = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public byte[] encrypt(byte[] plaintext, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, secretKey);
            return cipher.doFinal(plaintext);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public byte[] decrypt(byte[] ciphertext, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, secretKey);
            return cipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private SecretKey createSecretKey() {
        try {
            KeyGenerator desGen = KeyGenerator.getInstance("DES");
            SecretKey desKey = desGen.generateKey();
            return desKey;
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private void setSecretKey(SecretKey desKey) {
        try {
            SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec desSpec = (DESKeySpec)desFactory.getKeySpec(desKey, DESKeySpec.class);
            byte[] rawDesKey = desSpec.getKey();
            String value = Base64.encodeToString(rawDesKey, rawDesKey.length);
            Element root = this.mDoc.getDocumentElement();
            root.setAttribute("secretkey", value);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private SecretKey getSecretKey() {
        try {
            Element root = this.mDoc.getDocumentElement();
            String value = root.getAttribute("secretkey");
            if (value != null && value.length() > 0) {
                ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream(value.getBytes(), value.getBytes().length);
                byte[] rawDesKey = baos.toByteArray();
                SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
                DESKeySpec desSpec = new DESKeySpec(rawDesKey);
                return desFactory.generateSecret(desSpec);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }
}

