/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class Base64 {
    private static final String converttable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encode(ImageData imagedata) {
        ImageLoader imgldr = new ImageLoader();
        imgldr.data = new ImageData[]{imagedata};
        ByteArrayOutputStream imgstream = new ByteArrayOutputStream();
        if (SystemUtil.GetOSType() == 1) {
            imgldr.save((OutputStream)imgstream, 3);
        } else {
            imgldr.save((OutputStream)imgstream, 0);
        }
        ByteArrayOutputStream baos = Base64.encodeToByteArrayOutputStream(imgstream.toByteArray(), imgstream.toByteArray().length);
        if (baos != null) {
            return baos.toString();
        }
        return null;
    }

    public static ImageData decode(String string) {
        try {
            ByteArrayInputStream bais;
            ImageLoader imgldr;
            ImageData[] imgdata;
            ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream(string.getBytes(), string.getBytes().length);
            byte[] decodedata = baos.toByteArray();
            if (decodedata != null && (imgdata = (imgldr = new ImageLoader()).load((InputStream)(bais = new ByteArrayInputStream(decodedata)))).length > 0) {
                if (SystemUtil.GetOSType() == 1) {
                    imgdata[0].palette.blueMask = 255;
                    imgdata[0].palette.greenMask = 65280;
                    imgdata[0].palette.redMask = 0xFF0000;
                    imgdata[0].palette.blueShift = 0;
                    imgdata[0].palette.greenShift = -8;
                    imgdata[0].palette.redShift = -16;
                }
                return imgdata[0];
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeToString(byte[] srcData, int srcLength) {
        ByteArrayOutputStream baos = Base64.encodeToByteArrayOutputStream(srcData, srcLength);
        if (baos != null) {
            return baos.toString();
        }
        return null;
    }

    public static ByteArrayOutputStream encodeToByteArrayOutputStream(byte[] srcData, int srcLength) {
        if (srcData == null) {
            return null;
        }
        if (srcData.length == 0) {
            return null;
        }
        try {
            int b;
            int b24;
            if (srcLength > srcData.length) {
                srcLength = srcData.length;
            }
            int srcAmari = srcLength % 3;
            int length = srcLength - srcAmari;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            byte[] ct = converttable.getBytes("SJIS");
            int i = 0;
            while (i < length) {
                b24 = 0;
                b24 = b = srcData[i] & 0xFF;
                b24 <<= 8;
                b = srcData[i + 1] & 0xFF;
                b24 |= b;
                b24 <<= 8;
                b = srcData[i + 2] & 0xFF;
                out.writeByte(ct[(b24 |= b) >> 18 & 0x3F]);
                out.writeByte(ct[b24 >> 12 & 0x3F]);
                out.writeByte(ct[b24 >> 6 & 0x3F]);
                out.writeByte(ct[b24 & 0x3F]);
                i += 3;
            }
            if (srcAmari == 1) {
                b24 = 0;
                b24 = b = srcData[i] & 0xFF;
                b24 <<= 8;
                b24 |= 0;
                b24 <<= 8;
                out.writeByte(ct[(b24 |= 0) >> 18 & 0x3F]);
                out.writeByte(ct[b24 >> 12 & 0x3F]);
                out.writeByte(61);
                out.writeByte(61);
            } else if (srcAmari == 2) {
                b24 = 0;
                b24 = b = srcData[i] & 0xFF;
                b24 <<= 8;
                b = srcData[i + 1] & 0xFF;
                b24 |= b;
                b24 <<= 8;
                out.writeByte(ct[(b24 |= 0) >> 18 & 0x3F]);
                out.writeByte(ct[b24 >> 12 & 0x3F]);
                out.writeByte(ct[b24 >> 6 & 0x3F]);
                out.writeByte(61);
            }
            return baos;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ByteArrayOutputStream decodeToByteArrayOutputStream(byte[] srcData, int srcLength) {
        block12: {
            int srcAmari;
            if (srcData == null) {
                return null;
            }
            if (srcData.length == 0) {
                return null;
            }
            if (srcLength > srcData.length) {
                srcLength = srcData.length;
            }
            if ((srcAmari = srcLength % 4) == 0) break block12;
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            int i = 0;
            while (i < srcLength) {
                int b24 = 0;
                byte b = srcData[i];
                int index = converttable.indexOf(b);
                b24 |= index << 18;
                b = srcData[i + 1];
                index = converttable.indexOf(b);
                b24 |= index << 12;
                b = srcData[i + 2];
                if (b != 61) {
                    index = converttable.indexOf(b);
                    b24 |= index << 6;
                    b = srcData[i + 3];
                    if (b != 61) {
                        index = converttable.indexOf(b);
                        out.writeByte((byte)((b24 |= index) >> 16 & 0xFF));
                        out.writeByte((byte)(b24 >> 8 & 0xFF));
                        out.writeByte((byte)(b24 & 0xFF));
                    } else {
                        out.writeByte((byte)(b24 >> 16 & 0xFF));
                        out.writeByte((byte)(b24 >> 8 & 0xFF));
                    }
                } else {
                    out.writeByte((byte)(b24 >> 16 & 0xFF));
                    if ((b24 >> 8 & 0xFF) != 0) {
                        out.writeByte((byte)(b24 >> 8 & 0xFF));
                    }
                }
                i += 4;
            }
            return baos;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

