/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.DomImpl_internal;
import jp.sourceforge.concierge.util.TypeDomImpl;
import jp.sourceforge.concierge.util.XMLString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataDomImpl_internal
extends DomImpl_internal {
    private static String convertLegalExpression(String name) {
        String str = "";
        name = name.trim();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                str = String.valueOf(str) + String.valueOf(c);
            } else if (Character.isWhitespace(c)) {
                str = String.valueOf(str) + "_";
            } else if (c != ':') {
                str = String.valueOf(str) + "-";
            }
            ++i;
        }
        return str;
    }

    public static void addNamespace(Element root, Document typedoc) {
        NamedNodeMap nnm = root.getAttributes();
        int len = nnm.getLength();
        int i = 0;
        while (i < len) {
            Node n = nnm.item(i);
            if (n.getNodeName().startsWith("xmlns:")) {
                root.removeAttribute(n.getNodeName());
                --i;
                --len;
            }
            ++i;
        }
        ArrayList elems = DomImpl_internal.getElements(typedoc, "element", null);
        int i2 = 0;
        while (i2 < elems.size()) {
            Element te = (Element)elems.get(i2);
            String pprefix = TypeDomImpl.getParserNSPrefix(te);
            String pns = TypeDomImpl.getParserNS(te);
            root.setAttribute("xmlns:" + pprefix, pns);
            ++i2;
        }
    }

    public static Document createDocument(Document typedoc) {
        try {
            Document doc = DomImpl.createDocument();
            Element topelem = doc.createElement("data");
            String id = String.valueOf(DomImpl.getUniqueID());
            topelem.setAttribute("id", id);
            topelem.setAttribute("lastmod", id);
            doc.appendChild(topelem);
            if (typedoc == null) {
                return doc;
            }
            topelem.setAttribute("tid", String.valueOf(DomImpl.getID(typedoc)));
            topelem.setAttribute("name", TypeDomImpl.getTypeName(typedoc));
            DataDomImpl_internal.addNamespace(topelem, typedoc);
            ArrayList telems = TypeDomImpl.getAllElements(typedoc);
            int i = 0;
            while (i < telems.size()) {
                Element te = (Element)telems.get(i);
                String name = TypeDomImpl.getElementName(te);
                Element de = DataDomImpl_internal.appendElement(doc, DataDomImpl_internal.convertLegalExpression(name), null);
                de.setAttribute("parser", TypeDomImpl.getParser(te));
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static void setType(Document doc, String type) {
        doc.getDocumentElement().setAttribute("name", type);
    }

    protected static void setType(Document doc, Document typedoc) {
        DataDomImpl_internal.setType(doc, TypeDomImpl.getTypeName(typedoc));
        DataDomImpl_internal.addNamespace(doc.getDocumentElement(), typedoc);
    }

    protected static String getType(Document doc) {
        return doc.getDocumentElement().getAttribute("name");
    }

    protected static void setFilePath(Document doc, String path) {
        doc.getDocumentElement().setAttribute("filepath", path);
    }

    protected static String getFilePath(Document doc) {
        return doc.getDocumentElement().getAttribute("filepath");
    }

    protected static void setFileName(Document doc, String name) {
        doc.getDocumentElement().setAttribute("filename", name);
    }

    protected static String getFileName(Document doc) {
        return doc.getDocumentElement().getAttribute("filename");
    }

    protected static void removeFilePath(Document doc) {
        doc.getDocumentElement().removeAttribute("filepath");
    }

    protected static ArrayList getAllParsersElements(Document doc) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nl = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                list.add(n);
            }
            ++i;
        }
        return list;
    }

    protected static Element getElement(Document doc, String name) {
        NodeList nl = doc.getElementsByTagName(DataDomImpl_internal.convertLegalExpression(name));
        Element elem = null;
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setElementContent(Element data, String content) {
        String parsername;
        Document doc;
        Document document = doc = data.getOwnerDocument();
        synchronized (document) {
            parsername = data.getAttribute("parser");
        }
        ITypeParser parser = FrameworkPlugin.getParserPlugin(parsername).createInstance();
        if (content != null) {
            parser.addToElement(data, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getElementContent(Element data) {
        String parsername;
        Document doc;
        Document document = doc = data.getOwnerDocument();
        synchronized (document) {
            parsername = data.getAttribute("parser");
        }
        ITypeParser parser = FrameworkPlugin.getParserPlugin(parsername).createInstance();
        return parser.getViewForm(data);
    }

    protected static Element replaceElement(Element elem, String name, String pref, String type) {
        Element newelem = DomImpl_internal.createElement(elem, DataDomImpl_internal.convertLegalExpression(name), pref);
        newelem.setAttribute("parser", type);
        elem.getParentNode().replaceChild(newelem, elem);
        return newelem;
    }

    protected static Element appendElement(Document doc, String name, String pref, String type) {
        Element newelem = DomImpl_internal.appendElement(doc, DataDomImpl_internal.convertLegalExpression(name), pref);
        newelem.setAttribute("parser", type);
        return newelem;
    }

    protected static ArrayList getElements(Element elem, String name, String pref) {
        return DomImpl_internal.getElements(elem, DataDomImpl_internal.convertLegalExpression(name), pref);
    }

    public static String getStringOfDocumentQueryByPath(String path) {
        return XMLString.getElementQueryStringByFullPath("@filepath", path, "data");
    }

    public static String getStringOfDocumentQueryByType(String type) {
        return XMLString.getElementQueryStringByFullPath("@name", type, "data");
    }

    public static String getStringOfDocumentQueryByTypeID(String typeid) {
        return XMLString.getElementQueryStringByFullPath("@tid", typeid, "data");
    }

    public static String getStringOfDocumentQueryByID(long id) {
        return XMLString.getElementQueryStringByFullPath("@id", String.valueOf(id), "data");
    }

    public static String getStringOfDocumentQueryByNameValue(String prefix, String name, String value) {
        String elemname = DataDomImpl_internal.convertLegalExpression(name);
        return XMLString.getElementQueryStringByFullPath(elemname, value, "data");
    }

    protected static String getAllText(Document doc) {
        String str = "";
        ArrayList list = DataDomImpl_internal.getAllParsersElements(doc);
        int i = 0;
        while (i < list.size()) {
            if (str.length() > 0) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + DomImpl_internal.getAllText((Element)list.get(i));
            ++i;
        }
        return str;
    }

    protected static boolean isInstance(Document doc) {
        return doc.getDocumentElement().getNodeName().compareTo("data") == 0;
    }
}

