/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.SystemUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.program.Program;
import org.w3c.dom.Document;

public class FileLauncher {
    public static boolean isDirectory(File file) {
        String extension;
        boolean isDirectory = file.isDirectory();
        if (SystemUtil.GetOSType() == 1 && ((extension = FilenameUtils.getExtension((String)file.getName())).equals("app") || extension.equals("wdgt") || extension.equals("pkg"))) {
            isDirectory = false;
        }
        return isDirectory;
    }

    public static boolean isDirectory(String filepath) {
        return FileLauncher.isDirectory(new File(filepath));
    }

    public static void LaunchBrowser(String url) {
        if (url != null) {
            Program program = Program.findProgram((String)"html");
            System.out.println("Open URL:" + url);
            if (program != null) {
                program.execute(url);
            } else {
                try {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url});
                }
                catch (IOException iOException) {
                    System.err.println("not found browser");
                }
            }
        }
    }

    public static void LaunchFile(Document doc) {
        String path = DataDomImpl.getFilePath(doc);
        if (path.length() == 0 && ((path = FrameworkPlugin.getPathFromID(DomImpl.getID(doc))) == null || path.length() == 0)) {
            return;
        }
        FileLauncher.LaunchFile(new File(path));
    }

    public static void LaunchFile(File file) {
        if (file.isFile()) {
            if (!FileLauncher.isArchive(file.getName())) {
                Program.launch((String)file.getAbsolutePath());
            }
        } else {
            Program.launch((String)file.getAbsolutePath());
        }
    }

    public static boolean isArchive(File file) {
        return FileLauncher.isArchive(file.getName());
    }

    public static boolean isArchive(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return extension.equalsIgnoreCase("zip") || extension.equalsIgnoreCase("gz") || extension.equalsIgnoreCase("tgz") || extension.equalsIgnoreCase("tar-gz") || extension.equalsIgnoreCase("tar") || extension.equalsIgnoreCase("gtar") || extension.equalsIgnoreCase("gnutar") || extension.equalsIgnoreCase("lha") || extension.equalsIgnoreCase("lzh") || extension.equalsIgnoreCase("sit") || extension.equalsIgnoreCase("sitx");
    }
}

