/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import com.google.gdata.client.Query;
import com.google.gdata.client.calendar.CalendarQuery;
import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.calendar.CalendarEventFeed;
import com.google.gdata.data.extensions.EventEntry;
import com.google.gdata.data.extensions.When;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class Holiday {
    private static final String defaultlocale = "japanese";
    private Hashtable<String, String> holidayList = new Hashtable();
    private int startyear = 0;
    private int endyear = 0;
    private boolean error = false;

    private Date getDate(int y, int m, int d) {
        Calendar cd = Calendar.getInstance();
        cd.set(y, m, d);
        return cd.getTime();
    }

    private String getYMD(long ms) {
        Calendar cd = Calendar.getInstance();
        cd.setTimeInMillis(ms);
        int y = cd.get(1);
        int m = cd.get(2);
        int d = cd.get(5);
        return String.valueOf(y) + "/" + m + "/" + d;
    }

    private String getYMD(int yv, int mv, int dv) {
        Calendar cd = Calendar.getInstance();
        cd.set(yv, mv, dv);
        int y = cd.get(1);
        int m = cd.get(2);
        int d = cd.get(5);
        return String.valueOf(y) + "/" + m + "/" + d;
    }

    public void initHolidaysByYear(int syear, int eyear, String locale) {
        try {
            if (locale == null) {
                locale = defaultlocale;
            }
            URL feed = new URL("http://www.google.com/calendar/feeds/" + locale + "@holiday.calendar.google.com/public/full");
            CalendarService calServ = new CalendarService("google-calendar");
            DateTime st = new DateTime(this.getDate(syear, 0, 1));
            DateTime et = new DateTime(this.getDate(eyear, 11, 31));
            CalendarQuery query = new CalendarQuery(feed);
            query.setMaxResults(1000);
            query.setMinimumStartTime(st);
            query.setMaximumStartTime(et);
            CalendarEventFeed result = (CalendarEventFeed)calServ.query((Query)query, CalendarEventFeed.class);
            this.holidayList.clear();
            int i = 0;
            while (i < result.getEntries().size()) {
                EventEntry ee = (EventEntry)result.getEntries().get(i);
                List ti = ee.getTimes();
                int j = 0;
                while (j < ti.size()) {
                    When wh = (When)ti.get(j);
                    this.holidayList.put(this.getYMD(wh.getStartTime().getValue()), ee.getTitle().getPlainText());
                    ++j;
                }
                ++i;
            }
            this.startyear = syear;
            this.endyear = eyear;
            return;
        }
        catch (Exception exception) {
            this.error = true;
            return;
        }
    }

    public boolean isHoliday(int year, int month, int day, String locale) {
        return this.getHolidayName(year, month, day, locale) != null;
    }

    public String getHolidayName(int year, int month, int day, String locale) {
        if (year < 1900 || year > 2100 || this.error) {
            return null;
        }
        if (this.startyear == 0 || this.endyear == 0 || year < this.startyear || year > this.endyear) {
            this.initHolidaysByYear(year - 5, year + 5, locale);
        }
        return this.holidayList.get(this.getYMD(year, month - 1, day));
    }
}

