/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatAuthorsItemData;
import jp.sourceforge.concierge.util.ReferenceFormatData;
import jp.sourceforge.concierge.util.ReferenceFormatIdentifiersItemData;
import jp.sourceforge.concierge.util.ReferenceFormatItem;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceFormatDomImpl {
    private static Hashtable<String, ReferenceFormatData> formatdatalist = null;
    public static final String collection = "referenceformat";

    private static ReferenceFormatData getNewFormatDataFromXMLDB(Document typedoc) {
        ReferenceFormatData fodt = null;
        String xpath = "/format[@typeid='" + String.valueOf(DomImpl.getID(typedoc)) + "']";
        Request req = new Request(4, xpath, collection);
        ArrayList<Document> docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        if (docs.size() > 0) {
            Document doc = docs.get(0);
            Element root_elem = doc.getDocumentElement();
            String selectString = root_elem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node rfnd_node = root_elem.getFirstChild();
            while (rfnd_node != null) {
                if (rfnd_node.getNodeType() == 1) {
                    if (count == select) {
                        fodt = new ReferenceFormatData(((Element)rfnd_node).getAttribute("formatname"));
                        fodt.setFontname(((Element)rfnd_node).getAttribute("fontname"));
                        String fontsize = ((Element)rfnd_node).getAttribute("fontsize");
                        fodt.setFontSize(Integer.valueOf(fontsize));
                        Node rftid_node = rfnd_node.getFirstChild();
                        while (rftid_node != null) {
                            if (rftid_node.getNodeType() == 1) {
                                String itemname;
                                Element typeelem;
                                int i;
                                ArrayList typeelems;
                                String name;
                                String classname = ((Element)rftid_node).getAttribute("class");
                                if (classname.equalsIgnoreCase("ReferenceFormatTypeItemData") || classname.equalsIgnoreCase("ReferenceFormatItem")) {
                                    name = ((Element)rftid_node).getAttribute("name");
                                    typeelems = TypeDomImpl.getAllElements(typedoc);
                                    i = 0;
                                    while (i < typeelems.size()) {
                                        typeelem = (Element)typeelems.get(i);
                                        itemname = TypeDomImpl.getElementName(typeelem);
                                        if (itemname.equals(name)) {
                                            ReferenceFormatItem foit = new ReferenceFormatItem(name);
                                            foit.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                            foit.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                            foit.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                            fodt.addItemList(foit);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.equalsIgnoreCase("ReferenceFormatAuthorsItemData")) {
                                    name = ((Element)rftid_node).getAttribute("name");
                                    typeelems = TypeDomImpl.getAllElements(typedoc);
                                    i = 0;
                                    while (i < typeelems.size()) {
                                        typeelem = (Element)typeelems.get(i);
                                        itemname = TypeDomImpl.getElementName(typeelem);
                                        if (itemname.equals(name)) {
                                            ReferenceFormatAuthorsItemData rfaid = new ReferenceFormatAuthorsItemData(name);
                                            fodt.addItemList(rfaid);
                                            rfaid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                            rfaid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                            rfaid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                            String indexStr = ((Element)rftid_node).getAttribute("index");
                                            int index = 0;
                                            try {
                                                index = Integer.valueOf(indexStr);
                                            }
                                            catch (Exception exception) {}
                                            rfaid.setIndex(index);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.equalsIgnoreCase("ReferenceFormatIdentifiersItemData")) {
                                    name = ((Element)rftid_node).getAttribute("name");
                                    typeelems = TypeDomImpl.getAllElements(typedoc);
                                    i = 0;
                                    while (i < typeelems.size()) {
                                        typeelem = (Element)typeelems.get(i);
                                        itemname = TypeDomImpl.getElementName(typeelem);
                                        if (itemname.equals(name)) {
                                            ReferenceFormatIdentifiersItemData rfiid = new ReferenceFormatIdentifiersItemData(name);
                                            fodt.addItemList(rfiid);
                                            rfiid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                            rfiid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                            rfiid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                            String idtype = ((Element)rftid_node).getAttribute("idtype");
                                            rfiid.setItem(idtype);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.equalsIgnoreCase("String")) {
                                    name = ((Element)rftid_node).getAttribute("name");
                                    fodt.addItemList(new String(name));
                                }
                            }
                            rftid_node = rftid_node.getNextSibling();
                        }
                        break;
                    }
                    ++count;
                }
                rfnd_node = rfnd_node.getNextSibling();
            }
        }
        if (fodt == null) {
            fodt = ReferenceFormatDomImpl.createDefaultNewFormatData(typedoc);
        }
        return fodt;
    }

    public static void initializeFormatDataList() {
        if (formatdatalist != null) {
            formatdatalist.clear();
            formatdatalist = null;
        }
        formatdatalist = new Hashtable();
        String xpath = "/type";
        Request req = new Request(4, xpath, "type");
        ArrayList<Document> list = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("ReferenceFormatDomImpl Result size = " + list.size());
        int i = 0;
        while (i < list.size()) {
            Document typedoc = list.get(i);
            ReferenceFormatData fodt = ReferenceFormatDomImpl.getNewFormatDataFromXMLDB(typedoc);
            formatdatalist.put(String.valueOf(DomImpl.getID(typedoc)), fodt);
            ++i;
        }
    }

    public static void setFormatData(String tid, ReferenceFormatData fodt) {
        if (formatdatalist == null) {
            formatdatalist = new Hashtable();
        }
        formatdatalist.put(tid, fodt);
    }

    public static void setFormatData(long typeid, ReferenceFormatData fodt) {
        if (formatdatalist == null) {
            formatdatalist = new Hashtable();
        }
        formatdatalist.put(String.valueOf(typeid), fodt);
    }

    public static ReferenceFormatData getFormatData(String tid) {
        if (formatdatalist != null) {
            return formatdatalist.get(tid);
        }
        String xpath = "/type[@id='" + tid + "']";
        System.out.println("ReferenceFormatDomImpl xpath = " + xpath);
        Request req = new Request(4, xpath, "type");
        ArrayList<Document> docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("ReferenceFormatDomImpl Result size = " + docs.size());
        if (docs.size() > 0) {
            Document typedoc = docs.get(0);
            return ReferenceFormatDomImpl.createDefaultNewFormatData(typedoc);
        }
        return null;
    }

    private static ReferenceFormatData createDefaultNewFormatData(Document typedoc) {
        ReferenceFormatData fodt = new ReferenceFormatData("Default");
        ArrayList elems = TypeDomImpl.getAllElements(typedoc);
        int i = 0;
        while (i < elems.size()) {
            if (i > 0) {
                fodt.addItemList(new String(", "));
            }
            Element elem = (Element)elems.get(i);
            String item = TypeDomImpl.getElementName(elem);
            String parser = TypeDomImpl.getParser(elem);
            if (parser.equalsIgnoreCase("identifiers")) {
                fodt.addItemList(new ReferenceFormatIdentifiersItemData(item));
            } else if (parser.equalsIgnoreCase("authors")) {
                fodt.addItemList(new ReferenceFormatAuthorsItemData(item));
            } else {
                fodt.addItemList(new ReferenceFormatItem(item));
            }
            ++i;
        }
        return fodt;
    }

    public static String getNewPlainText(Document datadoc) {
        Element root_elem = datadoc.getDocumentElement();
        String tid = root_elem.getAttribute("tid");
        if (tid == null || tid.length() == 0) {
            return null;
        }
        ReferenceFormatData fodt = ReferenceFormatDomImpl.getFormatData(tid);
        if (fodt == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> itemList = fodt.getItemList();
        int i = 0;
        while (i < itemList.size()) {
            String value;
            Object obj = itemList.get(i);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                ReferenceFormatIdentifiersItemData rfiid = (ReferenceFormatIdentifiersItemData)obj;
                value = ReferenceFormatDomImpl.getItemIdentifiers(datadoc, rfiid.toString(), rfiid.getItem());
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatAuthorsItemData) {
                ReferenceFormatAuthorsItemData rfaid = (ReferenceFormatAuthorsItemData)obj;
                value = ReferenceFormatDomImpl.getItemAuthors(datadoc, rfaid.toString(), rfaid.getIndex());
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatItem) {
                ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                String text = ReferenceFormatDomImpl.getItemText(datadoc, foit.toString());
                if (foit.getItemName().equalsIgnoreCase("Title")) {
                    if (text.endsWith(".")) {
                        text = text.substring(0, text.length() - 1);
                    } else if (text.endsWith("\uff0e")) {
                        text = text.substring(0, text.length() - 1);
                    }
                }
                strBuf.append(text);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String getNewRTFText(Document[] datadocs) {
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        int i = 0;
        while (i < datadocs.length) {
            ReferenceFormatData fodt;
            Document datadoc = datadocs[i];
            Element root_elem = datadoc.getDocumentElement();
            String tid = root_elem.getAttribute("tid");
            if (tid != null && tid.length() > 0 && (fodt = ReferenceFormatDomImpl.getFormatData(tid)) != null) {
                String font = new String();
                if (fodt.getFontItemIndex() == 0) {
                    if (fonttblBuf.indexOf("\\f0\\fswiss\\fcharset77 Helvetica;") == -1) {
                        fonttblBuf.append("\\f0\\fswiss\\fcharset77 Helvetica;");
                    }
                    font = "\\f0\\fs" + String.valueOf(fodt.getFontSize() * 2);
                } else if (fodt.getFontItemIndex() == 1) {
                    if (fonttblBuf.indexOf("\\f1\\froman\\fcharset77 Times-Roman;") == -1) {
                        fonttblBuf.append("\\f1\\froman\\fcharset77 Times-Roman;");
                    }
                    font = "\\f1\\fs" + String.valueOf(fodt.getFontSize() * 2);
                } else if (fodt.getFontItemIndex() == 2) {
                    if (fonttblBuf.indexOf("\\f2\\fmodern\\fcharset77 Courier;") == -1) {
                        fonttblBuf.append("\\f2\\fmodern\\fcharset77 Courier;");
                    }
                    font = "\\f2\\fs" + String.valueOf(fodt.getFontSize() * 2);
                }
                StringBuffer strBuf = new StringBuffer();
                ArrayList<Object> itemList = fodt.getItemList();
                int j = 0;
                while (j < itemList.size()) {
                    String value;
                    Object obj = itemList.get(j);
                    if (obj instanceof String) {
                        String value2 = (String)obj;
                        strBuf.append(value2);
                    } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                        ReferenceFormatIdentifiersItemData rfiid = (ReferenceFormatIdentifiersItemData)obj;
                        value = new String();
                        value = String.valueOf(value) + "{";
                        value = rfiid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                        value = rfiid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                        value = rfiid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                        value = String.valueOf(value) + " ";
                        value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemIdentifiers(datadoc, rfiid.toString(), rfiid.getItem()));
                        value = String.valueOf(value) + "}";
                        strBuf.append(value);
                    } else if (obj instanceof ReferenceFormatAuthorsItemData) {
                        ReferenceFormatAuthorsItemData rfaid = (ReferenceFormatAuthorsItemData)obj;
                        value = new String();
                        value = String.valueOf(value) + "{";
                        value = rfaid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                        value = rfaid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                        value = rfaid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                        value = String.valueOf(value) + " ";
                        value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemAuthors(datadoc, rfaid.toString(), rfaid.getIndex()));
                        value = String.valueOf(value) + "}";
                        strBuf.append(value);
                    } else if (obj instanceof ReferenceFormatItem) {
                        ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                        value = new String();
                        value = String.valueOf(value) + "{";
                        value = foit.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                        value = foit.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                        value = foit.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                        value = String.valueOf(value) + " ";
                        String text = ReferenceFormatDomImpl.getItemText(datadoc, foit.toString());
                        if (foit.getItemName().equalsIgnoreCase("Title")) {
                            if (text.endsWith(".")) {
                                text = text.substring(0, text.length() - 1);
                            } else if (text.endsWith("\uff0e")) {
                                text = text.substring(0, text.length() - 1);
                            }
                        }
                        value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(text);
                        value = String.valueOf(value) + "}";
                        strBuf.append(value);
                    }
                    ++j;
                }
                if (strBuf.length() > 0) {
                    strBuf.insert(0, "{" + font + " ");
                    strBuf.append("\\par}");
                }
                outBuf.append(strBuf);
            }
            ++i;
        }
        if (fonttblBuf.length() > 0) {
            fonttblBuf.insert(0, "{\\fonttbl");
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1{\\colortbl;\\red255\\green255\\blue255;}" + fonttblBuf.toString();
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String getNewRTFText(Document datadoc) {
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        Element root_elem = datadoc.getDocumentElement();
        String tid = root_elem.getAttribute("tid");
        if (tid == null || tid.length() == 0) {
            return null;
        }
        ReferenceFormatData fodt = ReferenceFormatDomImpl.getFormatData(tid);
        if (fodt == null) {
            return null;
        }
        String font = new String();
        if (fodt.getFontItemIndex() == 0) {
            if (fonttblBuf.indexOf("\\f0\\fswiss\\fcharset77 Helvetica;") == -1) {
                fonttblBuf.append("\\f0\\fswiss\\fcharset77 Helvetica;");
            }
            font = "\\f0\\fs" + String.valueOf(fodt.getFontSize() * 2);
        } else if (fodt.getFontItemIndex() == 1) {
            if (fonttblBuf.indexOf("\\f1\\froman\\fcharset77 Times-Roman;") == -1) {
                fonttblBuf.append("\\f1\\froman\\fcharset77 Times-Roman;");
            }
            font = "\\f1\\fs" + String.valueOf(fodt.getFontSize() * 2);
        } else if (fodt.getFontItemIndex() == 2) {
            if (fonttblBuf.indexOf("\\f2\\fmodern\\fcharset77 Courier;") == -1) {
                fonttblBuf.append("\\f2\\fmodern\\fcharset77 Courier;");
            }
            font = "\\f2\\fs" + String.valueOf(fodt.getFontSize() * 2);
        }
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> itemList = fodt.getItemList();
        int j = 0;
        while (j < itemList.size()) {
            String value;
            Object obj = itemList.get(j);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                ReferenceFormatIdentifiersItemData rfiid = (ReferenceFormatIdentifiersItemData)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = rfiid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = rfiid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = rfiid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemIdentifiers(datadoc, rfiid.toString(), rfiid.getItem()));
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatAuthorsItemData) {
                ReferenceFormatAuthorsItemData rfaid = (ReferenceFormatAuthorsItemData)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = rfaid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = rfaid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = rfaid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemAuthors(datadoc, rfaid.toString(), rfaid.getIndex()));
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatItem) {
                ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = foit.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = foit.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = foit.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                String text = ReferenceFormatDomImpl.getItemText(datadoc, foit.toString());
                if (foit.getItemName().equalsIgnoreCase("Title")) {
                    if (text.endsWith(".")) {
                        text = text.substring(0, text.length() - 1);
                    } else if (text.endsWith("\uff0e")) {
                        text = text.substring(0, text.length() - 1);
                    }
                }
                value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(text);
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            }
            ++j;
        }
        if (strBuf.length() > 0) {
            strBuf.insert(0, "{" + font + " ");
            strBuf.append("\\par}");
        }
        outBuf.append(strBuf);
        if (fonttblBuf.length() > 0) {
            fonttblBuf.insert(0, "{\\fonttbl");
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1{\\colortbl;\\red255\\green255\\blue255;}" + fonttblBuf.toString();
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String getNewHTMLText(Document[] datadocs) {
        StringBuffer outBuf = new StringBuffer();
        int i = 0;
        while (i < datadocs.length) {
            ReferenceFormatData fodt;
            Document datadoc = datadocs[i];
            Element root_elem = datadoc.getDocumentElement();
            String tid = root_elem.getAttribute("tid");
            if (tid != null && tid.length() > 0 && (fodt = ReferenceFormatDomImpl.getFormatData(tid)) != null) {
                StringBuffer strBuf = new StringBuffer();
                ArrayList<Object> itemList = fodt.getItemList();
                int j = 0;
                while (j < itemList.size()) {
                    String value;
                    Object obj = itemList.get(j);
                    if (obj instanceof String) {
                        String value2 = (String)obj;
                        strBuf.append(value2);
                    } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                        ReferenceFormatIdentifiersItemData rfiid = (ReferenceFormatIdentifiersItemData)obj;
                        value = ReferenceFormatDomImpl.getItemIdentifiers(datadoc, rfiid.toString(), rfiid.getItem());
                        if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                            if (rfiid.getBold()) {
                                value = "<b>" + value + "</b>";
                            }
                            if (rfiid.getItalic()) {
                                value = "<i>" + value + "</i>";
                            }
                            if (rfiid.getUnderline()) {
                                value = "<u>" + value + "</u>";
                            }
                        }
                        strBuf.append(value);
                    } else if (obj instanceof ReferenceFormatAuthorsItemData) {
                        ReferenceFormatAuthorsItemData rfaid = (ReferenceFormatAuthorsItemData)obj;
                        value = ReferenceFormatDomImpl.getItemAuthors(datadoc, rfaid.toString(), rfaid.getIndex());
                        if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                            if (rfaid.getBold()) {
                                value = "<b>" + value + "</b>";
                            }
                            if (rfaid.getItalic()) {
                                value = "<i>" + value + "</i>";
                            }
                            if (rfaid.getUnderline()) {
                                value = "<u>" + value + "</u>";
                            }
                        }
                        strBuf.append(value);
                    } else if (obj instanceof ReferenceFormatItem) {
                        ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                        value = ReferenceFormatDomImpl.getItemText(datadoc, foit.toString());
                        if (foit.getItemName().equalsIgnoreCase("Title")) {
                            if (value.endsWith(".")) {
                                value = value.substring(0, value.length() - 1);
                            } else if (value.endsWith("\uff0e")) {
                                value = value.substring(0, value.length() - 1);
                            }
                        }
                        if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                            if (foit.getBold()) {
                                value = "<b>" + value + "</b>";
                            }
                            if (foit.getItalic()) {
                                value = "<i>" + value + "</i>";
                            }
                            if (foit.getUnderline()) {
                                value = "<u>" + value + "</u>";
                            }
                        }
                        strBuf.append(value);
                    }
                    ++j;
                }
                outBuf.append(strBuf);
                outBuf.append("<br>");
            }
            ++i;
        }
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    public static String getNewHTMLText(Document datadoc) {
        StringBuffer outBuf = new StringBuffer();
        Element root_elem = datadoc.getDocumentElement();
        String tid = root_elem.getAttribute("tid");
        if (tid == null || tid.length() == 0) {
            return null;
        }
        ReferenceFormatData fodt = ReferenceFormatDomImpl.getFormatData(tid);
        if (fodt == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> itemList = fodt.getItemList();
        int j = 0;
        while (j < itemList.size()) {
            String value;
            Object obj = itemList.get(j);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceFormatIdentifiersItemData) {
                ReferenceFormatIdentifiersItemData rfiid = (ReferenceFormatIdentifiersItemData)obj;
                value = ReferenceFormatDomImpl.getItemIdentifiers(datadoc, rfiid.toString(), rfiid.getItem());
                if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (rfiid.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (rfiid.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (rfiid.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatAuthorsItemData) {
                ReferenceFormatAuthorsItemData rfaid = (ReferenceFormatAuthorsItemData)obj;
                value = ReferenceFormatDomImpl.getItemAuthors(datadoc, rfaid.toString(), rfaid.getIndex());
                if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (rfaid.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (rfaid.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (rfaid.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceFormatItem) {
                ReferenceFormatItem foit = (ReferenceFormatItem)obj;
                value = ReferenceFormatDomImpl.getItemText(datadoc, foit.toString());
                if (foit.getItemName().equalsIgnoreCase("Title")) {
                    if (value.endsWith(".")) {
                        value = value.substring(0, value.length() - 1);
                    } else if (value.endsWith("\uff0e")) {
                        value = value.substring(0, value.length() - 1);
                    }
                }
                if ((value = ReferenceFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (foit.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (foit.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (foit.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            }
            ++j;
        }
        outBuf.append(strBuf);
        outBuf.append("<br>");
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    private static String getItemIdentifiers(Document datadoc, String tagname, String identifiersType) {
        ITypeParser p;
        IParserPlugin pp;
        Element elem3;
        String parsername;
        String value = null;
        ArrayList al1 = DomImpl.getElements(datadoc, tagname);
        if (al1.size() > 0 && (parsername = (elem3 = (Element)al1.get(0)).getAttribute("parser")).equals("identifiers") && (pp = FrameworkPlugin.getParserPlugin(parsername)) != null && (p = pp.createInstance()) != null) {
            Document schemedoc = p.getScheme();
            Element s_root = schemedoc.getDocumentElement();
            Node s_node = s_root.getFirstChild();
            ArrayList al2 = DomImpl.getElements(elem3, s_node.getNodeName());
            int j = 0;
            while (j < al2.size()) {
                Element e = (Element)al2.get(j);
                String type = e.getAttribute("type");
                if (type != null && identifiersType.equals(type)) {
                    value = DomImpl.getAllText(e);
                    break;
                }
                ++j;
            }
            p = null;
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static String getItemAuthors(Document datadoc, String tagname, int ruleIndex) {
        ITypeParser p;
        Element elem3;
        String parsername;
        IParserPlugin pp;
        StringBuffer strBuf = new StringBuffer();
        ArrayList al1 = DomImpl.getElements(datadoc, tagname);
        if (al1.size() > 0 && (pp = FrameworkPlugin.getParserPlugin(parsername = (elem3 = (Element)al1.get(0)).getAttribute("parser"))) != null && (p = pp.createInstance()) != null) {
            Document schemedoc = p.getScheme();
            Element s_root = schemedoc.getDocumentElement();
            Node s_node = s_root.getFirstChild();
            ArrayList al2 = DomImpl.getElements(elem3, s_node.getNodeName());
            if (ruleIndex == 0) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors001(al2, "&", false));
            } else if (ruleIndex == 1) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors001(al2, "and", false));
            } else if (ruleIndex == 2) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors001(al2, "&", true));
            } else if (ruleIndex == 3) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors001(al2, "and", true));
            } else if (ruleIndex == 9) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors002(al2, "&"));
            } else if (ruleIndex == 10) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors002(al2, "and"));
            } else if (ruleIndex == 8) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors003(al2, ""));
            } else if (ruleIndex == 4) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors004(al2, "&", false));
            } else if (ruleIndex == 5) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors004(al2, "and", false));
            } else if (ruleIndex == 6) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors006(al2, "and", false, ""));
            } else if (ruleIndex == 7) {
                strBuf.append(ReferenceFormatDomImpl.getAuthors005(al2, "and", false));
            }
            p = null;
        }
        return strBuf.toString();
    }

    private static String getItemText(Document datadoc, String tagname) {
        ITypeParser p;
        Element elem3;
        String parsername;
        IParserPlugin pp;
        StringBuffer strBuf = new StringBuffer();
        ArrayList al1 = DomImpl.getElements(datadoc, tagname);
        if (al1.size() > 0 && (pp = FrameworkPlugin.getParserPlugin(parsername = (elem3 = (Element)al1.get(0)).getAttribute("parser"))) != null && (p = pp.createInstance()) != null) {
            Document schemedoc = p.getScheme();
            Element s_root = schemedoc.getDocumentElement();
            Node s_node = s_root.getFirstChild();
            ArrayList al2 = DomImpl.getElements(elem3, s_node.getNodeName());
            int j = 0;
            while (j < al2.size()) {
                if (j > 0) {
                    strBuf.append(", ");
                }
                Element e = (Element)al2.get(j);
                strBuf.append(DomImpl.getAllText(e));
                ++j;
            }
            p = null;
        }
        return strBuf.toString();
    }

    public static String rtfEncode(String rtfStr) {
        return ReferenceFormatDomImpl.rtfUTFEncode(rtfStr);
    }

    public static String rtfShiftJISEncode(String rtfStr) {
        try {
            byte[] data = rtfStr.getBytes("SJIS");
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                int c = data[i] & 0xFF;
                if (129 <= c && c <= 159 || 224 <= c && c <= 239 || 240 <= c && c <= 252) {
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                    c = data[++i] & 0xFF;
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                } else if (c == 123 || c == 125 || c == 92) {
                    strBuf.append("\\");
                    strBuf.append((char)data[i]);
                } else {
                    strBuf.append((char)data[i]);
                }
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String rtfUTFEncode(String rtfStr) {
        try {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < rtfStr.length()) {
                strBuf.append("\\");
                strBuf.append("u");
                char c = rtfStr.charAt(i);
                int u = c & 0xFFFF;
                strBuf.append(Integer.toString(u));
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String htmlEncode(String htmlStr) {
        htmlStr = htmlStr.replaceAll("&", "&amp;");
        htmlStr = htmlStr.replaceAll("<", "&lt;");
        htmlStr = htmlStr.replaceAll(">", "&gt;");
        htmlStr = htmlStr.replaceAll("\"", "&quot;");
        htmlStr = htmlStr.replaceAll("'", "&#39;");
        return htmlStr;
    }

    private static String getAuthors001(ArrayList al2, String AndString, boolean UpperCase) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                if (j < al2.size() - 1) {
                    strBuf.append(", ");
                } else {
                    strBuf.append(" " + AndString + " ");
                }
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            if (UpperCase) {
                strBuf.append(lastname.toUpperCase());
            } else {
                strBuf.append(lastname);
            }
            strBuf.append(", ");
            k = 0;
            while (k < initials.length()) {
                c = initials.charAt(k);
                strBuf.append(c);
                strBuf.append(".");
                ++k;
            }
            ++j;
        }
        return strBuf.toString();
    }

    private static String getAuthors002(ArrayList al2, String AndString) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                if (j < al2.size() - 1) {
                    strBuf.append(", ");
                } else {
                    strBuf.append(" " + AndString + " ");
                }
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            strBuf.append(String.valueOf(lastname) + " " + initials);
            ++j;
        }
        return strBuf.toString();
    }

    private static String getAuthors003(ArrayList al2, String TermString) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                strBuf.append(", ");
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            strBuf.append(String.valueOf(lastname) + " " + initials);
            ++j;
        }
        strBuf.append(TermString);
        return strBuf.toString();
    }

    private static String getAuthors004(ArrayList al2, String AndString, boolean UpperCase) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                if (j < al2.size() - 1) {
                    strBuf.append(", ");
                } else {
                    strBuf.append(" " + AndString + " ");
                }
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            if (UpperCase) {
                strBuf.append(lastname.toUpperCase());
            } else {
                strBuf.append(lastname);
            }
            strBuf.append(", ");
            k = 0;
            while (k < initials.length()) {
                if (k > 0) {
                    strBuf.append(" ");
                }
                c = initials.charAt(k);
                strBuf.append(c);
                strBuf.append(".");
                ++k;
            }
            ++j;
        }
        return strBuf.toString();
    }

    private static String getAuthors006(ArrayList al2, String AndString, boolean UpperCase, String TermString) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                if (j < al2.size() - 1) {
                    strBuf.append(", ");
                } else {
                    strBuf.append(" " + AndString + " ");
                }
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            if (UpperCase) {
                strBuf.append(lastname.toUpperCase());
            } else {
                strBuf.append(lastname);
            }
            strBuf.append(", ");
            k = 0;
            while (k < initials.length()) {
                if (k > 0) {
                    strBuf.append(" ");
                }
                c = initials.charAt(k);
                strBuf.append(c);
                ++k;
            }
            ++j;
        }
        strBuf.append(TermString);
        return strBuf.toString();
    }

    private static String getAuthors005(ArrayList al2, String AndString, boolean UpperCase) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < al2.size()) {
            char c;
            if (j > 0) {
                if (j < al2.size() - 1) {
                    strBuf.append(", ");
                } else {
                    strBuf.append(" " + AndString + " ");
                }
            }
            String firstname = null;
            String middlename = null;
            String lastname = null;
            Element e = (Element)al2.get(j);
            ArrayList al3 = DomImpl.getElements(e, "auth:firstname");
            firstname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:middlename");
            middlename = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            al3 = DomImpl.getElements(e, "auth:lastname");
            lastname = al3.size() > 0 ? DomImpl.getElementText((Element)al3.get(0)) : "";
            StringBuffer initials = new StringBuffer();
            int k = 0;
            while (k < firstname.length()) {
                c = firstname.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            k = 0;
            while (k < middlename.length()) {
                c = middlename.charAt(k);
                if ('A' > c || c > 'Z') break;
                initials.append(c);
                ++k;
            }
            if (j == 0) {
                strBuf.append(lastname);
                strBuf.append(", ");
                k = 0;
                while (k < initials.length()) {
                    if (k > 0) {
                        strBuf.append(" ");
                    }
                    c = initials.charAt(k);
                    strBuf.append(c);
                    strBuf.append(".");
                    ++k;
                }
            } else {
                k = 0;
                while (k < initials.length()) {
                    c = initials.charAt(k);
                    strBuf.append(c);
                    strBuf.append(". ");
                    ++k;
                }
                strBuf.append(lastname);
            }
            ++j;
        }
        return strBuf.toString();
    }
}

