/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatAuthorsItemData;
import jp.sourceforge.concierge.util.ReferenceFormatData;
import jp.sourceforge.concierge.util.ReferenceFormatIdentifiersItemData;
import jp.sourceforge.concierge.util.ReferenceFormatItem;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceFormatTypeData {
    private Document typedoc = null;
    private ArrayList<ReferenceFormatData> formatList = null;
    private int formatListIndex = 0;
    String[] schemaitems = null;

    public ReferenceFormatTypeData(Document typedoc) {
        this.typedoc = typedoc;
        this.formatList = new ArrayList();
        this.getSchemaItems();
    }

    public String[] getSchemaItems() {
        if (this.schemaitems == null) {
            ArrayList typeElems = TypeDomImpl.getAllElements(this.typedoc);
            this.schemaitems = new String[typeElems.size()];
            int j = 0;
            while (j < typeElems.size()) {
                Element typeelem = (Element)typeElems.get(j);
                this.schemaitems[j] = TypeDomImpl.getElementName(typeelem);
                ++j;
            }
        }
        return this.schemaitems;
    }

    public long getID() {
        return DomImpl.getID(this.typedoc);
    }

    public String getTypeName() {
        return TypeDomImpl.getTypeName(this.typedoc);
    }

    public ArrayList getFormatList() {
        return this.formatList;
    }

    public ReferenceFormatData newReferenceFormatData(String formatname) {
        ReferenceFormatData fodt = new ReferenceFormatData(formatname);
        this.formatList.add(fodt);
        ArrayList elems = TypeDomImpl.getAllElements(this.typedoc);
        int i = 0;
        while (i < elems.size()) {
            if (i > 0) {
                fodt.addItemList(new String(", "));
            }
            Element elem = (Element)elems.get(i);
            String item = TypeDomImpl.getElementName(elem);
            String parser = TypeDomImpl.getParser(elem);
            if (parser.equalsIgnoreCase("identifiers")) {
                System.out.println("identifiers");
                fodt.addItemList(new ReferenceFormatIdentifiersItemData(item));
            } else if (parser.equalsIgnoreCase("authors")) {
                System.out.println("authors");
                fodt.addItemList(new ReferenceFormatAuthorsItemData(item));
            } else {
                fodt.addItemList(new ReferenceFormatItem(item));
            }
            ++i;
        }
        return fodt;
    }

    public void addFormatData(ReferenceFormatData fodt) {
        if (fodt == null) {
            return;
        }
        this.formatList.add(fodt);
    }

    public void removeFormatData(ReferenceFormatData fodt) {
        if (fodt == null) {
            return;
        }
        this.formatList.remove(fodt);
    }

    public int getFormatListIndex() {
        return this.formatListIndex;
    }

    public void setFormatListIndex(int index) {
        this.formatListIndex = index;
    }
}

