/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader {
    public static String openFileDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4096);
        String[] ext = new String[]{"*.xml", "*.*"};
        fd.setFilterExtensions(ext);
        String path = fd.open();
        return path;
    }

    public static String[] openFilesDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4098);
        String[] ext = new String[]{"*.xml"};
        fd.setFilterExtensions(ext);
        String path = fd.open();
        if (path != null) {
            String[] filenames = fd.getFileNames();
            if (filenames != null) {
                int i = 0;
                while (i < filenames.length) {
                    filenames[i] = String.valueOf(fd.getFilterPath()) + File.separator + filenames[i];
                    ++i;
                }
            }
            return filenames;
        }
        return null;
    }

    public static String openDirectoryDialog(Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(shell, 4096);
        String path = dd.open();
        return path;
    }

    public static void ImportXMLFileToConciergeDatabase(String filepath, Object requestSender) {
        File file = new File(filepath);
        if (file.exists()) {
            XMLReader.ImportXMLFileToConciergeDatabase(file, requestSender);
        }
    }

    public static void ImportXMLFileToConciergeDatabase(File file, Object requestSender) {
        if (file != null && file.exists()) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            ArrayList<String> filenames = new ArrayList<String>();
            ArrayList<Document> docs = new ArrayList<Document>();
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    Document doc = XMLReader.XMLFileToDoc(files[i]);
                    if (doc != null) {
                        String kind = XMLReader.WhatKindOfDoument(doc);
                        if (kind.equals("data")) {
                            long id = DomImpl.getID(doc);
                            File aFile = new File(files[i].getParentFile(), String.valueOf(id));
                            if (aFile.exists() && aFile.isFile()) {
                                DataDomImpl.setFilePath(doc, aFile.getAbsolutePath());
                            }
                            String newId = String.valueOf(DomImpl.getUniqueID());
                            doc.getDocumentElement().setAttribute("id", newId);
                            reqs.add(new Request(1, doc, "data"));
                            filenames.add(DataDomImpl.getFileName(doc));
                            docs.add(doc);
                        } else if (kind.equals("type")) {
                            reqs.add(new Request(1, doc, "type"));
                        }
                    }
                    ++i;
                }
            } else {
                Document doc = XMLReader.XMLFileToDoc(file);
                if (doc != null) {
                    String kind = XMLReader.WhatKindOfDoument(doc);
                    if (kind.equals("data")) {
                        long id = DomImpl.getID(doc);
                        File aFile = new File(file.getParentFile(), String.valueOf(id));
                        if (aFile.exists() && aFile.isFile()) {
                            DataDomImpl.setFilePath(doc, aFile.getAbsolutePath());
                        }
                        String newId = String.valueOf(DomImpl.getUniqueID());
                        doc.getDocumentElement().setAttribute("id", newId);
                        reqs.add(new Request(1, doc, "data"));
                        filenames.add(DataDomImpl.getFileName(doc));
                        docs.add(doc);
                    } else if (kind.equals("type")) {
                        reqs.add(new Request(1, doc, "type"));
                    }
                }
            }
            try {
                FrameworkPlugin.getDefault().updateDocuments(reqs, requestSender);
            }
            catch (Exception exception) {}
            try {
                reqs.clear();
                int i = 0;
                while (i < docs.size()) {
                    Document doc = (Document)docs.get(i);
                    DataDomImpl.setFileName(doc, (String)filenames.get(i));
                    reqs.add(new Request(3, doc, "data"));
                    ++i;
                }
                FrameworkPlugin.getDefault().updateDocuments(reqs, requestSender);
            }
            catch (Exception exception) {}
        }
    }

    public static ArrayList<Document> XMLFileToDocs(File file) {
        if (file != null && file.exists()) {
            ArrayList<Document> list = new ArrayList<Document>();
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    String kind;
                    Document doc = XMLReader.XMLFileToDoc(files[i]);
                    if (doc != null && (kind = XMLReader.WhatKindOfDoument(doc)).equals("data")) {
                        long id = DomImpl.getID(doc);
                        File aFile = new File(String.valueOf(id));
                        if (aFile.exists() && aFile.isFile()) {
                            DataDomImpl.setFilePath(doc, aFile.getAbsolutePath());
                        }
                        list.add(doc);
                    }
                    ++i;
                }
            } else {
                String kind;
                Document doc = XMLReader.XMLFileToDoc(file);
                if (doc != null && (kind = XMLReader.WhatKindOfDoument(doc)).equals("data")) {
                    long id = DomImpl.getID(doc);
                    File aFile = new File(String.valueOf(id));
                    if (aFile.exists() && aFile.isFile()) {
                        DataDomImpl.setFilePath(doc, aFile.getAbsolutePath());
                    }
                    list.add(doc);
                }
            }
            return list;
        }
        return null;
    }

    public static String WhatKindOfDoument(Document doc) {
        Element rootElem = DomImpl.getRootElement(doc);
        String nodeName = rootElem.getNodeName();
        return nodeName;
    }

    public static Document XMLFileToDoc(InputStream is) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document XMLFileToDoc(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

