/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWriter {
    public static void DocToXMLFile(Document doc, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            result.setOutputStream(new FileOutputStream(outFile));
            transformer.transform(domSource, result);
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocToZipFile(Document doc, String entryName, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(domSource, result);
            XMLWriter.ByteArrayOutputStreamToZipFile(baos, entryName, outFile);
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocToZipFileWithHead(Document doc, String entryName, File outFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource domSource = new DOMSource();
            domSource.setNode(doc);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(domSource, result);
            ByteArrayOutputStream tos = null;
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            ByteArrayInputStream bais = null;
            try {
                int count;
                byte[] buff;
                byte[] buf = baos.toByteArray();
                bais = new ByteArrayInputStream(buf);
                tos = new ByteArrayOutputStream();
                zos = new ZipOutputStream(tos);
                ZipEntry ze = null;
                try {
                    ze = new ZipEntry(entryName);
                    zos.putNextEntry(ze);
                    buff = new byte[0x100000];
                    while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                        zos.write(buff, 0, count);
                    }
                    zos.closeEntry();
                    buff = null;
                }
                catch (Exception exception) {}
                zos.finish();
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {}
                    bais = null;
                }
                if (tos != null) {
                    try {
                        tos.close();
                    }
                    catch (Exception exception) {}
                    tos = null;
                }
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (Exception exception) {}
                    zos = null;
                }
                fos = new FileOutputStream(outFile);
                zos = new ZipOutputStream(fos);
                bais = new ByteArrayInputStream(buf);
                try {
                    zos.putNextEntry(ze);
                    buff = new byte[0x100000];
                    while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                        zos.write(buff, 0, count);
                    }
                    zos.closeEntry();
                    buff = null;
                }
                catch (Exception exception) {}
                zos.finish();
            }
            catch (Exception exception) {}
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
                bais = null;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
                zos = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            result.getOutputStream().close();
        }
        catch (Exception exception) {}
    }

    public static void DocsToZipFileWithHead(ArrayList<Document> list, File outFile) {
        block32: {
            ZipOutputStream zosAll = null;
            FileOutputStream fos = null;
            try {
                int i = 0;
                while (i < list.size()) {
                    try {
                        Document doc = list.get(i);
                        String entryName = String.valueOf(String.valueOf(i)) + ".xml";
                        TransformerFactory tf = TransformerFactory.newInstance();
                        Transformer transformer = tf.newTransformer();
                        DOMSource domSource = new DOMSource();
                        domSource.setNode(doc);
                        StreamResult result = new StreamResult();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        result.setOutputStream(baos);
                        transformer.transform(domSource, result);
                        ByteArrayOutputStream tos = null;
                        ZipOutputStream zos = null;
                        ByteArrayInputStream bais = null;
                        try {
                            int count;
                            byte[] buff;
                            byte[] buf = baos.toByteArray();
                            bais = new ByteArrayInputStream(buf);
                            tos = new ByteArrayOutputStream();
                            zos = new ZipOutputStream(tos);
                            ZipEntry ze = null;
                            try {
                                ze = new ZipEntry(entryName);
                                zos.putNextEntry(ze);
                                buff = new byte[0x100000];
                                while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                                    zos.write(buff, 0, count);
                                }
                                zos.closeEntry();
                                buff = null;
                            }
                            catch (Exception exception) {}
                            zos.finish();
                            if (bais != null) {
                                try {
                                    bais.close();
                                }
                                catch (Exception exception) {}
                                bais = null;
                            }
                            if (tos != null) {
                                try {
                                    tos.close();
                                }
                                catch (Exception exception) {}
                                tos = null;
                            }
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (Exception exception) {}
                                zos = null;
                            }
                            if (fos == null) {
                                fos = new FileOutputStream(outFile);
                            }
                            if (zosAll == null) {
                                zosAll = new ZipOutputStream(fos);
                            }
                            bais = new ByteArrayInputStream(buf);
                            try {
                                zosAll.putNextEntry(ze);
                                buff = new byte[0x100000];
                                while ((count = bais.read(buff, 0, 0x100000)) != -1) {
                                    zosAll.write(buff, 0, count);
                                }
                                zosAll.closeEntry();
                                buff = null;
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {}
                        if (bais != null) {
                            try {
                                bais.close();
                            }
                            catch (Exception exception) {}
                            bais = null;
                        }
                        result.getOutputStream().close();
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                zosAll.finish();
                if (zosAll != null) {
                    try {
                        zosAll.close();
                    }
                    catch (Exception exception) {}
                    zosAll = null;
                }
                if (fos == null) break block32;
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String SaveXMLFileDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{"XML Files", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.xml", "."});
        Date dNow = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dialog.setFileName(String.valueOf(dateFormat.format(dNow)) + ".xml");
        dialog.setText("Export XML");
        String resultPath = dialog.open();
        return resultPath;
    }

    public static void createZipFile(File srcFile, File dstFile) {
        if (!srcFile.exists()) {
            return;
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(dstFile);
            zos = new ZipOutputStream(fos);
            XMLWriter.PutFileInZipOutputStream(zos, srcFile, "");
            zos.finish();
        }
        catch (Exception exception) {}
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Exception exception) {}
            zos = null;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            fos = null;
        }
    }

    private static void PutFileInZipOutputStream(ZipOutputStream zos, File srcFile, String parentPath) {
        if (srcFile.isFile()) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(srcFile);
                bis = new BufferedInputStream(fis);
                XMLWriter.writeZipOutputStream(zos, String.valueOf(parentPath) + srcFile.getName(), bis);
            }
            catch (Exception exception) {}
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
                bis = null;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
                fis = null;
            }
        } else {
            try {
                ZipEntry zed = new ZipEntry(String.valueOf(parentPath) + srcFile.getName() + "/");
                zos.putNextEntry(zed);
                zos.closeEntry();
                File[] files = srcFile.listFiles();
                int i = 0;
                while (i < files.length) {
                    XMLWriter.PutFileInZipOutputStream(zos, files[i], String.valueOf(parentPath) + srcFile.getName() + "/");
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void writeZipOutputStream(ZipOutputStream zos, String entryName, InputStream is) {
        try {
            int count;
            ZipEntry ze = new ZipEntry(entryName);
            zos.putNextEntry(ze);
            byte[] buf = new byte[0x100000];
            while ((count = is.read(buf, 0, 0x100000)) != -1) {
                zos.write(buf, 0, count);
            }
            zos.closeEntry();
            buf = null;
        }
        catch (Exception exception) {}
    }

    public static void ByteArrayOutputStreamToZipFile(ByteArrayOutputStream baos, String entryName, File outFile) {
        block12: {
            try {
                FileOutputStream fos = null;
                ZipOutputStream zos = null;
                ByteArrayInputStream bais = null;
                try {
                    fos = new FileOutputStream(outFile);
                    zos = new ZipOutputStream(fos);
                    byte[] buf = baos.toByteArray();
                    bais = new ByteArrayInputStream(buf);
                    XMLWriter.writeZipOutputStream(zos, entryName, bais);
                    zos.finish();
                }
                catch (Exception exception) {}
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {}
                    bais = null;
                }
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (Exception exception) {}
                    zos = null;
                }
                if (fos == null) break block12;
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
            catch (Exception exception) {}
        }
    }

    public static void UnZipToLog(String filename) {
        try {
            ZipFile zipFile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                ZipEntry e = all.nextElement();
                if (e.isDirectory()) {
                    System.out.println("Directory = " + e.getName());
                    continue;
                }
                System.out.println("File = " + e.getName());
            }
        }
        catch (Exception exception) {}
    }

    public static String SaveZipFileDialog(Shell shell, String filename) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{"ZIP Files", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.zip", "."});
        if (filename == null) {
            Date dNow = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            filename = dateFormat.format(dNow);
        }
        dialog.setFileName(String.valueOf(filename) + ".zip");
        dialog.setText("Export ZIP");
        String resultPath = dialog.open();
        return resultPath;
    }

    public static String saveDirectoryDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 8192);
        String path = dialog.open();
        return path;
    }

    public static void ExportXMLDocumentWithSaveDialog(ArrayList<Document> docs, Shell shell) {
        String path = XMLWriter.saveDirectoryDialog(shell);
        if (path != null && path.length() > 0) {
            File folder = new File(path);
            XMLWriter.ExportXMLDocument(docs, folder);
        }
    }

    public static void ExportXMLDocument(ArrayList<Document> docs, File folder) {
        if (folder != null && docs != null) {
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (folder.isDirectory()) {
                int i = 0;
                while (i < docs.size()) {
                    block10: {
                        try {
                            String extension;
                            File srcFile;
                            Document doc = docs.get(i);
                            long id = DomImpl.getID(doc);
                            String filename = String.valueOf(String.valueOf(id)) + ".xml";
                            File xmlFile = new File(folder, filename);
                            XMLWriter.DocToXMLFile(doc, xmlFile);
                            String path = FrameworkPlugin.getPathFromID(DomImpl.getID(doc));
                            if (path == null || path.length() <= 0 || !(srcFile = new File(path)).exists()) break block10;
                            filename = String.valueOf(id);
                            String originalFilename = DataDomImpl.getFileName(doc);
                            if (originalFilename != null && (extension = FilenameUtils.getExtension((String)originalFilename)) != null && extension.length() > 0) {
                                filename = String.valueOf(filename) + "." + extension;
                            }
                            File dstFile = new File(folder, filename);
                            try {
                                if (srcFile.isFile()) {
                                    FileUtils.copyFile((File)srcFile, (File)dstFile);
                                }
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                            }
                        }
                        catch (Exception exc) {
                            System.err.println(exc.getMessage());
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

