/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.CalItem;
import jp.sourceforge.concierge.plugin.footprint.CalTitle;
import jp.sourceforge.concierge.plugin.footprint.CalTitleListener;
import jp.sourceforge.concierge.plugin.footprint.Category;
import jp.sourceforge.concierge.plugin.footprint.CategoryViewer;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialog;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.Holiday;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;

public class Footprint
extends ConciergeViewPart {
    private FootprintDialog dialog;
    private Composite datelist;
    private CategoryViewer category;
    private CalTitle dtitle;
    private ImageHyperlink addcatbtn;
    private ImageHyperlink delcatbtn;
    private int caldate;
    private ImageDescriptor addimg = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.footprint", (String)"icons/catplus.png");
    private ImageDescriptor delimg = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.footprint", (String)"icons/catminus.png");
    private ArrayList<CalItem> dateitems = new ArrayList();
    private Holiday holidayCache = new Holiday();
    private FootprintMenuManager mmanager = null;

    private void setdateitem(int year, int month, int date) {
        ArrayList docs;
        CalItem di;
        int dofw = CalendarUtil.getDayOfWeek((int)year, (int)month, (int)1) - 1;
        int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
        int pyear = year;
        int pmonth = month - 1;
        if (pmonth == 0) {
            pyear = year - 1;
            pmonth = 12;
        }
        int nyear = year;
        int nmonth = month + 1;
        if (nmonth > 12) {
            nyear = year + 1;
            nmonth = 1;
        }
        FootprintPlugin fp = FootprintPlugin.getDefault();
        int pnofd = CalendarUtil.getNumberOfDays((int)pyear, (int)pmonth);
        int i = 0;
        int j = pnofd - dofw + 1;
        while (i < dofw) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(pyear, pmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(pyear, pmonth, j, "japanese") || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(pyear, pmonth, j, "japanese"));
            di.clearAll();
            docs = fp.getDocuments(pyear, pmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        i = dofw;
        j = 1;
        while (i < dofw + nofd) {
            di = this.dateitems.get(i);
            di.setDate(year, month, j);
            di.setHoliday(this.holidayCache.isHoliday(year, month, j, "japanese") || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(year, month, j, "japanese"));
            if (j == date) {
                di.select();
            } else {
                di.deselect();
            }
            di.clearAll();
            docs = fp.getDocuments(year, month, j);
            di.setDocuments(docs);
            di.setEnabled(true);
            ++i;
            ++j;
        }
        i = dofw + nofd;
        j = 1;
        while (i < 42) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(nyear, nmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(nyear, nmonth, j, "japanese") || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(nyear, nmonth, j, "japanese"));
            di.clearAll();
            docs = fp.getDocuments(nyear, nmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        this.datelist.layout();
    }

    private void resizeCalItem(Control[] calitems, Point parentsize) {
        int nw = (parentsize.x - 1) / 7;
        int nh = (parentsize.y - 1) / 6;
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 6) {
                Composite comp = (Composite)calitems[x + y * 7];
                int px = nw * x + 1;
                int py = nh * y + 1;
                int w = x == 6 ? parentsize.x - nw * 6 - 2 : nw - 1;
                int h = y == 5 ? parentsize.y - nh * 5 - 2 : nh - 1;
                comp.setBounds(px, py, w, h);
                ++y;
            }
            ++x;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite maincomp = new Composite(parent, 0);
        GridLayout glmn = new GridLayout(1, true);
        glmn.marginHeight = 0;
        glmn.marginWidth = 0;
        glmn.verticalSpacing = 0;
        glmn.horizontalSpacing = 0;
        maincomp.setLayout((Layout)glmn);
        maincomp.setLayoutData((Object)new GridData(1808));
        SashForm sf = new SashForm(maincomp, 65792);
        sf.setLayoutData((Object)new GridData(1808));
        sf.SASH_WIDTH = 2;
        Composite calarea = new Composite((Composite)sf, 2048);
        GridLayout glca = new GridLayout(1, true);
        glca.marginHeight = 0;
        glca.marginWidth = 0;
        glca.verticalSpacing = 0;
        glca.horizontalSpacing = 0;
        calarea.setLayout((Layout)glca);
        GraphicUtil.setBackground((Control)calarea, (int)1);
        Composite harea = new Composite(calarea, 0);
        GridLayout glha = new GridLayout(2, true);
        glha.marginHeight = 0;
        glha.marginWidth = 0;
        glha.verticalSpacing = 0;
        glha.horizontalSpacing = 0;
        harea.setLayout((Layout)glha);
        harea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)harea, (int)1);
        Label label = new Label(harea, 4);
        label.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)label, (int)1);
        label.setText("Category");
        Composite cmdarea = new Composite(harea, 0);
        FormLayout flcma = new FormLayout();
        flcma.marginHeight = 0;
        flcma.marginWidth = 0;
        cmdarea.setLayout((Layout)flcma);
        cmdarea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)cmdarea, (int)1);
        this.delcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData dbfd = new FormData();
        dbfd.right = new FormAttachment(95, 0);
        this.delcatbtn.setLayoutData((Object)dbfd);
        GraphicUtil.setBackground((Control)this.delcatbtn, (int)1);
        this.delcatbtn.setImage(this.delimg.createImage());
        this.delcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (!FootprintPlugin.showConfirm(Footprint.this.delcatbtn.getShell(), "Footprints associated with this category will belong to <UNKNOWN>. OK?")) {
                    return;
                }
                Footprint.this.category.deleteCategory();
                Footprint.this.dialog.update();
                int i = 0;
                while (i < Footprint.this.dateitems.size()) {
                    CalItem ci = (CalItem)Footprint.this.dateitems.get(i);
                    ci.update();
                    ++i;
                }
            }
        });
        this.addcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData abfd = new FormData();
        abfd.right = new FormAttachment((Control)this.delcatbtn, -5);
        this.addcatbtn.setLayoutData((Object)abfd);
        this.addcatbtn.setImage(this.addimg.createImage());
        GraphicUtil.setBackground((Control)this.addcatbtn, (int)1);
        this.addcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Footprint.this.category.addCategory();
                Footprint.this.dialog.update();
            }
        });
        FootprintPlugin fp = FootprintPlugin.getDefault();
        this.category = new CategoryViewer(calarea, fp.getCategories());
        this.category.addCheckListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Category cg = (Category)e.getElement();
                int i = 0;
                while (i < Footprint.this.dateitems.size()) {
                    CalItem ci = (CalItem)Footprint.this.dateitems.get(i);
                    ci.categoryVisible(cg.name, e.getChecked());
                    ++i;
                }
            }
        });
        Calendar cd = Calendar.getInstance();
        int calyear = cd.get(1);
        int calmonth = cd.get(2) + 1;
        this.caldate = cd.get(5);
        this.holidayCache.initHolidaysByYear(calyear - 5, calyear + 5, "japanese");
        Composite darea = new Composite((Composite)sf, 2048);
        GridLayout glda = new GridLayout(1, true);
        glda.marginHeight = 10;
        glda.marginWidth = 10;
        glda.verticalSpacing = 0;
        glda.horizontalSpacing = 0;
        darea.setLayout((Layout)glda);
        GraphicUtil.setBackground((Control)darea, (int)1);
        sf.setWeights(new int[]{20, 80});
        Composite tt = new Composite(darea, 0);
        tt.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)tt, (int)1);
        this.dtitle = new CalTitle(tt, calyear, calmonth);
        this.dtitle.setListener(new CalTitleListener(){

            public void calendarChanged(int year, int month) {
                int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
                if (Footprint.this.caldate > nofd) {
                    Footprint.this.caldate = nofd;
                }
                Footprint.this.setdateitem(year, month, Footprint.this.caldate);
            }
        });
        this.datelist = new Composite(darea, 0);
        GridData dtgd = new GridData(1808);
        dtgd.minimumHeight = 240;
        dtgd.minimumWidth = 490;
        this.datelist.setLayoutData((Object)dtgd);
        GraphicUtil.setBackground((Control)this.datelist, (int)15);
        this.datelist.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Composite comp = (Composite)e.widget;
                Point r = comp.getSize();
                Control[] chld = comp.getChildren();
                Footprint.this.resizeCalItem(chld, r);
            }
        });
        this.dialog = (FootprintDialog)FootprintPlugin.getDefault().getDialog(darea.getShell(), 1264);
        int i = 0;
        while (i < 42) {
            Composite comp = new Composite(this.datelist, 0);
            GraphicUtil.setBackground((Control)comp, (int)1);
            CalItem di = new CalItem(comp, calyear, calmonth, i, this.category, this.dialog);
            this.dateitems.add(di);
            di.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    CalItem c = (CalItem)e.data;
                    c.createItem(Footprint.this.category.getCurrentCategory());
                }

                public void mouseDown(MouseEvent e) {
                    IWorkbenchPage page;
                    IViewPart tview;
                    int i = 0;
                    while (i < 42) {
                        CalItem it = (CalItem)Footprint.this.dateitems.get(i);
                        it.deselect();
                        ++i;
                    }
                    CalItem c = (CalItem)e.data;
                    c.select();
                    Document doc = c.getSelectedDocument();
                    if (doc != null) {
                        if (e.button != 1 || (e.stateMask & 0x40000) != 0 && e.button == 1) {
                            c.showTooltip(false);
                            Control ctrl = c.getSelectedControl();
                            ((Footprint)Footprint.this).mmanager.document = doc;
                            ((Footprint)Footprint.this).mmanager.calitem = c;
                            Menu m = Footprint.this.mmanager.createContextMenu(ctrl);
                            ctrl.setMenu(m);
                        }
                        return;
                    }
                    Footprint.this.caldate = c.getDay();
                    FootprintPlugin fp = FootprintPlugin.getDefault();
                    ArrayList al = fp.getDocuments(c.getYear(), c.getMonth(), c.getDay());
                    if (al == null) {
                        al = new ArrayList();
                    }
                    if ((tview = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("jp.sourceforge.concierge.plugin.tabulator")) == null) {
                        return;
                    }
                    ((ConciergeViewPart)tview).setDocuments(al);
                }
            });
            ++i;
        }
        this.resizeCalItem(this.datelist.getChildren(), this.datelist.getSize());
        this.setdateitem(calyear, calmonth, this.caldate);
        this.hookContextMenu();
    }

    private void fillContextMenu(IMenuManager manager) {
        Action openA = new Action(){

            public void run() {
                ((Footprint)Footprint.this).mmanager.calitem.openItem(((Footprint)Footprint.this).mmanager.document);
            }
        };
        openA.setText("Open");
        Action deleteA = new Action(){

            public void run() {
                if (!MessageDialog.openConfirm((Shell)Footprint.this.datelist.getShell(), (String)"Delete", (String)"Delete?")) {
                    return;
                }
                ((Footprint)Footprint.this).mmanager.calitem.deleteItem(((Footprint)Footprint.this).mmanager.document);
                FootprintPlugin.getDefault().deleteDocument(((Footprint)Footprint.this).mmanager.document, true, null);
            }
        };
        deleteA.setText("Delete");
        manager.add((IAction)openA);
        manager.add((IAction)deleteA);
    }

    private void hookContextMenu() {
        this.mmanager = new FootprintMenuManager("#PopupMenu");
        this.mmanager.setRemoveAllWhenShown(true);
        this.mmanager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Footprint.this.fillContextMenu(manager);
            }
        });
    }

    public void setFocus() {
        this.datelist.setFocus();
    }

    public void Update(ArrayList reqs, Object sender) {
        FootprintPlugin fp = FootprintPlugin.getDefault();
        if (sender.equals(fp.getBundle().getSymbolicName())) {
            return;
        }
        int i = 0;
        while (i < reqs.size()) {
            Request r = (Request)reqs.get(i);
            if (r.collection.compareTo("data") == 0) {
                Document doc = (Document)r.data;
                String type = DataDomImpl.getType((Document)doc);
                if (r.command == 2) {
                    if (type.compareTo("Note") == 0) {
                        fp.deleteDocument(doc, false, null);
                        int j = 0;
                        while (j < this.dateitems.size()) {
                            CalItem ci = this.dateitems.get(j);
                            ci.deleteItem(doc);
                            ++j;
                        }
                    }
                    this.dialog.removeEmbeddedObjectByDocument(doc);
                }
                if (r.command != 1) {
                    int cfr_ignored_0 = r.command;
                }
            }
            ++i;
        }
    }

    private class FootprintMenuManager
    extends MenuManager {
        public Document document;
        public CalItem calitem;

        public FootprintMenuManager(String id) {
            super(id);
            this.document = null;
            this.calitem = null;
        }
    }
}

