/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DataDomTransfer;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.widget.Drawer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolTip;
import org.w3c.dom.Document;

public class FootprintDrawer
extends Drawer {
    private TableTreeViewer idlist;
    private ArrayList doclist = new ArrayList();
    private ToolTip tooltip;

    private void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        Table tbl = this.idlist.getTableTree().getTable();
        DragSource dragSource = new DragSource((Control)tbl, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    public FootprintDrawer(Shell parent, int width) {
        super(parent, width);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        l.setText("Related Items");
        this.idlist = new TableTreeViewer(parent, 772);
        this.idlist.getTableTree().setLayoutData((Object)new GridData(1808));
        Table tbl = this.idlist.getTableTree().getTable();
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText("Type");
        tc.setWidth(200);
        this.idlist.setContentProvider((IContentProvider)new DocTreeContentProvider());
        this.idlist.setLabelProvider((IBaseLabelProvider)new DocTreeLabelProvider());
        DataDomTransfer dataDomTransfer = DataDomTransfer.getInstance();
        Transfer[] transferTypes = new Transfer[]{dataDomTransfer};
        this.addDragSupport(3, transferTypes, (DragSourceListener)new DragDrawerAdapter());
        this.idlist.setInput((Object)this.doclist);
        this.idlist.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection sel = (IStructuredSelection)e.getSelection();
                if (sel.isEmpty()) {
                    FootprintDrawer.this.tooltip.setVisible(false);
                    return;
                }
                Object o = sel.getFirstElement();
                if (!(o instanceof Document)) {
                    return;
                }
                String txt = DomImpl.getAllText((Document)((Document)o));
                if (txt.length() == 0) {
                    txt = "NO DATA";
                }
                FootprintDrawer.this.tooltip.setMessage(txt);
                FootprintDrawer.this.tooltip.setVisible(true);
            }
        });
        this.idlist.getTableTree().getTable().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TableItem ti = FootprintDrawer.this.idlist.getTableTree().getTable().getItem(new Point(e.x, e.y));
                if (ti == null || ti.getText().length() == 0) {
                    FootprintDrawer.this.tooltip.setVisible(false);
                }
            }
        });
        this.idlist.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                FootprintDrawer.this.tooltip.setVisible(false);
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.tooltip = new ToolTip(parent.getShell(), 4096);
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private Documents getType(String type) {
        int i = 0;
        while (i < this.doclist.size()) {
            Documents docs = (Documents)this.doclist.get(i);
            if (docs.type.equals(type)) {
                return docs;
            }
            ++i;
        }
        Documents docs = new Documents(type);
        this.doclist.add(docs);
        return docs;
    }

    public void setDocuments(ArrayList docs) {
        this.doclist.clear();
        int i = 0;
        while (i < docs.size()) {
            Document d = (Document)docs.get(i);
            String t = DataDomImpl.getType((Document)d);
            Documents ds = this.getType(t);
            ds.documents.add(d);
            ++i;
        }
        Collections.sort(this.doclist, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Documents d1 = (Documents)obj1;
                Documents d2 = (Documents)obj2;
                return d1.type.compareToIgnoreCase(d2.type);
            }
        });
    }

    private class Documents {
        public String type;
        public ArrayList documents;

        public Documents(String type) {
            this.type = type;
            this.documents = new ArrayList();
        }
    }

    private class DocTreeContentProvider
    implements ITreeContentProvider {
        private DocTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof Documents) {
                return ((Documents)arg0).documents.toArray();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            return arg0 instanceof Documents;
        }

        public Object[] getElements(Object dataset) {
            return ((ArrayList)dataset).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DocTreeLabelProvider
    implements ITableLabelProvider {
        private DocTreeLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int index) {
            return null;
        }

        public String getColumnText(Object arg0, int index) {
            if (arg0 instanceof Documents) {
                return ((Documents)arg0).type;
            }
            if (arg0 instanceof Document) {
                return String.valueOf(DomImpl.getID((Document)((Document)arg0)));
            }
            return null;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private class DragDrawerAdapter
    extends DragSourceAdapter {
        private Document[] docs = null;

        private DragDrawerAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            System.out.println("dragSetData");
            if (DataDomTransfer.getInstance().isSupportedType(e.dataType) && this.docs != null) {
                e.data = this.docs;
            }
        }

        public void dragStart(DragSourceEvent e) {
            System.out.println("dragStart");
            this.docs = null;
            IStructuredSelection selection = (IStructuredSelection)FootprintDrawer.this.idlist.getSelection();
            if (selection != null && selection.size() > 0) {
                Object[] obj = selection.toArray();
                this.docs = new Document[obj.length];
                int i = 0;
                while (i < obj.length) {
                    this.docs[i] = (Document)obj[i];
                    ++i;
                }
            }
            e.doit = true;
        }

        public void dragFinished(DragSourceEvent e) {
            System.out.println("dragFinished");
            this.docs = null;
        }
    }
}

