/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Database;
import org.apache.xindice.server.UglyBrowser;
import org.apache.xindice.server.rpc.RPCMessageInterface;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationException;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcServer;
import org.w3c.dom.Document;

public class XindiceServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$server$XindiceServlet == null ? (class$org$apache$xindice$server$XindiceServlet = XindiceServlet.class$("org.apache.xindice.server.XindiceServlet")) : class$org$apache$xindice$server$XindiceServlet));
    private static final String DEFAULT_XMLRPC_DRIVER = "xerces";
    protected XmlRpcServer xmlrpcServer;
    static /* synthetic */ Class class$org$apache$xindice$server$XindiceServlet;

    public void destroy() {
        String[] databases = Database.listDatabases();
        for (int i = 0; i < databases.length; ++i) {
            String name = databases[i];
            try {
                Database.getDatabase(name).close();
                log.info((Object)("Database '" + name + "' successfully closed"));
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error closing database '" + name + "'"), (Throwable)e);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UglyBrowser.doGet(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] result = this.xmlrpcServer.execute((InputStream)request.getInputStream());
        response.setContentType("text/xml");
        response.setContentLength(result.length);
        ServletOutputStream output = response.getOutputStream();
        output.write(result);
        output.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        Configuration configuration = this.loadConfiguration(servletConfig);
        try {
            Configuration xmlRpcDriverConfiguration;
            Configuration[] rootConfigurations = configuration.getChildren("root-collection");
            if (rootConfigurations.length == 0) {
                throw new ConfigurationException("The database configuration is missing the <root-collection> element");
            }
            for (int i = 0; i < rootConfigurations.length; ++i) {
                Configuration rootConfiguration = rootConfigurations[i];
                String name = rootConfiguration.getAttribute("name");
                String dbRoot = rootConfiguration.getAttribute("dbroot", "./db/");
                if (!new File(dbRoot).isAbsolute()) {
                    String realPath = servletConfig.getServletContext().getRealPath("/WEB-INF");
                    String home = System.getProperty("xindice.db.home");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("xindice.db.home is set to " + home));
                    }
                    if (home != null) {
                        dbRoot = new File(home + File.separator + dbRoot).getCanonicalPath();
                    } else if (realPath != null) {
                        dbRoot = new File(realPath + File.separator + dbRoot).getCanonicalPath();
                        log.warn((Object)("The database '" + name + "' root directory has been set to " + dbRoot + ". Keep in mind that if a war upgrade will take place the database will be lost."));
                    } else {
                        throw new ConfigurationException("The database '" + name + "' configuration points to a relative path, " + "but there was no " + "xindice.db.home" + " property set. " + "Furthermore, the war was not unpacked by the application server " + "so Xindice was unable to find a database location " + "Please check /WEB-INF/system.xml and set an absolute path " + "as the \"dbroot\" attribute of \"root-collection\" " + "or specify a suitable " + "xindice.db.home" + " system property.");
                    }
                    rootConfiguration.setAttribute("dbroot", dbRoot);
                }
                Database.getDatabase(rootConfiguration);
                log.info((Object)("Database '" + name + "' successfully opened"));
            }
            XmlRpc.setEncoding((String)"UTF8");
            String xmlrpcDriver = DEFAULT_XMLRPC_DRIVER;
            Configuration xmlRpcConfiguration = configuration.getChild("xml-rpc");
            if (xmlRpcConfiguration != null && (xmlRpcDriverConfiguration = xmlRpcConfiguration.getChild("driver")) != null) {
                xmlrpcDriver = xmlRpcDriverConfiguration.getAttribute("name", DEFAULT_XMLRPC_DRIVER);
            }
            try {
                XmlRpc.setDriver((String)xmlrpcDriver);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to set driver for XmlRpc to: " + xmlrpcDriver, e);
            }
            this.xmlrpcServer = new XmlRpcServer();
            try {
                this.xmlrpcServer.addHandler("$default", (Object)new RPCMessageInterface());
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to add default handler to XmlRpc server.", e);
            }
            log.info((Object)"Xindice server successfully started");
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize database, throwing ServletException", (Throwable)e);
            this.destroy();
            throw new ServletException("Error while handling the configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadConfiguration(ServletConfig servletConfig) {
        try {
            Document configurationDocument;
            String path = servletConfig.getInitParameter("xindice.configuration");
            if (path != null) {
                InputStream inputStream = null;
                if (path.startsWith("/")) {
                    log.debug((Object)("Loading configuration from filesystem path " + path));
                    inputStream = new FileInputStream(path);
                } else {
                    log.debug((Object)("Loading configuration from context path " + path));
                    ServletContext context = servletConfig.getServletContext();
                    inputStream = context.getResourceAsStream(path);
                }
                try {
                    configurationDocument = DOMParser.toDocument(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            log.debug((Object)"Loading the standard configuration");
            configurationDocument = DOMParser.toDocument("<xindice>    <root-collection dbroot=\"./db/\" name=\"db\">        <queryengine>            <resolver autoindex=\"false\" class=\"org.apache.xindice.core.query.XPathQueryResolver\" />            <resolver class=\"org.apache.xindice.core.xupdate.XUpdateQueryResolver\" />        </queryengine>    </root-collection>    <xml-rpc>        <driver name=\"xerces\" />    </xml-rpc></xindice>");
            return new Configuration(configurationDocument, false);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to load configuration.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

