/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ByteBuffer
extends OutputStream
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$util$ByteBuffer == null ? (class$org$apache$xindice$util$ByteBuffer = ByteBuffer.class$("org.apache.xindice.util.ByteBuffer")) : class$org$apache$xindice$util$ByteBuffer));
    static final long serialVersionUID = -3900903004630456844L;
    private transient int length = 0;
    private byte[] buffer = null;
    private boolean locked = false;
    static /* synthetic */ Class class$org$apache$xindice$util$ByteBuffer;

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public ByteBuffer(String value) {
        try {
            this.buffer = value.getBytes("utf-8");
            this.length = this.buffer.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java doesn't seem to support UTF-8");
        }
    }

    public ByteBuffer(StringBuffer value) {
        this(value.toString());
    }

    public ByteBuffer(byte[] value, boolean copy) {
        this.length = value.length;
        if (copy) {
            this.buffer = new byte[this.length];
            System.arraycopy(value, 0, this.buffer, 0, this.length);
        } else {
            this.buffer = value;
        }
    }

    public ByteBuffer(byte[] value) {
        this.length = value.length;
        this.buffer = new byte[this.length];
        System.arraycopy(value, 0, this.buffer, 0, this.length);
    }

    public ByteBuffer() {
        this(64);
    }

    public int capacity() {
        return this.buffer.length;
    }

    public void ensureCapacity(int size) {
        if (this.locked) {
            return;
        }
        this.checkCapacity(size);
    }

    private void checkCapacity(int size) {
        if (size > this.buffer.length) {
            int newsize = (this.buffer.length + 1) * 2;
            if (size > newsize) {
                newsize = size;
            }
            byte[] old = this.buffer;
            this.buffer = new byte[newsize];
            System.arraycopy(old, 0, this.buffer, 0, old.length);
        }
    }

    public void pack() {
        if (this.locked) {
            return;
        }
        if (this.buffer.length > this.length) {
            byte[] value = new byte[this.length];
            System.arraycopy(this.buffer, 0, value, 0, this.length);
            this.buffer = value;
        }
    }

    public void append(byte[] value) {
        if (this.locked) {
            return;
        }
        this.checkCapacity(this.length + value.length);
        System.arraycopy(value, 0, this.buffer, this.length, value.length);
        this.length += value.length;
    }

    public void append(char[] value) {
        this.append(new String(value));
    }

    public void append(String value) {
        try {
            this.append(value.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java doesn't seem to know UTF-8...");
        }
    }

    public void append(StringBuffer value) {
        this.append(value.toString());
    }

    public void append(ByteBuffer value) {
        block2: {
            try {
                value.writeTo(this);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public void append(boolean value) {
        this.append(String.valueOf(value));
    }

    public void append(char value) {
        if (this.locked) {
            return;
        }
        this.append(new char[]{value});
    }

    public void append(byte value) {
        if (this.locked) {
            return;
        }
        this.checkCapacity(this.length + 1);
        this.buffer[this.length++] = value;
    }

    public void append(double value) {
        this.append(String.valueOf(value));
    }

    public void append(float value) {
        this.append(String.valueOf(value));
    }

    public void append(int value) {
        this.append(String.valueOf(value));
    }

    public void append(long value) {
        this.append(String.valueOf(value));
    }

    public void append(Object value) {
        this.append(String.valueOf(value));
    }

    public void insert(byte[] value, int pos) {
        if (this.locked) {
            return;
        }
        if (pos < 0 || pos >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.checkCapacity(this.length + value.length);
        byte[] temp = new byte[this.length - pos];
        System.arraycopy(this.buffer, pos, temp, 0, temp.length);
        System.arraycopy(temp, 0, this.buffer, pos + value.length, temp.length);
        System.arraycopy(value, 0, this.buffer, pos, value.length);
        this.length += value.length;
    }

    public void insert(char[] value, int pos) {
        if (this.locked) {
            return;
        }
        this.insert(new String(value), pos);
    }

    public void insert(String value, int pos) {
        try {
            this.insert(value.getBytes("utf-8"), pos);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java doesn't seem to support UTF-8");
        }
    }

    public void insert(StringBuffer value, int pos) {
        this.insert(value.toString(), pos);
    }

    public void insert(ByteBuffer value, int pos) {
        this.insert(value.toByteArray(), pos);
    }

    public void insert(boolean value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void insert(char value, int pos) {
        this.insert(new char[]{value}, pos);
    }

    public void insert(byte value, int pos) {
        if (this.locked) {
            return;
        }
        if (pos < 0 || pos >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.checkCapacity(this.length + 1);
        byte[] temp = new byte[this.length - pos];
        System.arraycopy(this.buffer, pos, temp, 0, temp.length);
        System.arraycopy(temp, 0, this.buffer, pos + 1, temp.length);
        this.buffer[pos] = value;
        ++this.length;
    }

    public void insert(double value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void insert(float value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void insert(int value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void insert(long value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void insert(Object value, int pos) {
        this.insert(String.valueOf(value), pos);
    }

    public void delete(int pos, int width) {
        if (this.locked) {
            return;
        }
        if (pos + width > this.length) {
            width = this.length - pos;
        }
        byte[] temp = new byte[this.length - (pos + width)];
        System.arraycopy(this.buffer, pos + width, temp, 0, temp.length);
        System.arraycopy(temp, 0, this.buffer, pos, temp.length);
        this.length -= width;
    }

    public void replace(byte[] value, int pos, int width) {
        this.delete(pos, width);
        this.insert(value, pos);
    }

    public void replace(String value, int pos, int width) {
        try {
            this.replace(value.getBytes("utf-8"), pos, width);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java doesn't seem to know UTF-8");
        }
    }

    public void replace(StringBuffer value, int pos, int width) {
        this.replace(value.toString(), pos, width);
    }

    public void replace(ByteBuffer value, int pos, int width) {
        this.replace(value.toByteArray(), pos, width);
    }

    public void replace(boolean value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(char value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(double value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(float value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(int value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(long value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public void replace(Object value, int pos, int width) {
        this.replace(String.valueOf(value), pos, width);
    }

    public byte[] toByteArray() {
        byte[] value = new byte[this.length];
        System.arraycopy(this.buffer, 0, value, 0, this.length);
        return value;
    }

    public String toString() {
        try {
            return new String(this.buffer, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java doesn't seem to support UTF-8");
        }
    }

    public int length() {
        return this.length;
    }

    public void setLength(int value) {
        if (this.locked) {
            return;
        }
        if (value < 0 || value > this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.length = value;
    }

    public int size() {
        return this.length;
    }

    public void reset() {
        if (this.locked) {
            return;
        }
        this.length = 0;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    public void setByteAt(int index, byte value) {
        if (this.locked) {
            return;
        }
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[index] = value;
    }

    public void reverse() {
        if (this.locked) {
            return;
        }
        byte b = 0;
        for (int i = 0; i < this.length / 2; ++i) {
            b = this.buffer[i];
            this.buffer[i] = this.buffer[this.length - 1 - i];
            this.buffer[this.length - 1 - i] = b;
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer, 0, this.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.length);
    }

    public void chunkTo(OutputStream out, int chunkSize) throws IOException {
        int size = 0;
        for (int pos = 0; pos < this.length; pos += size) {
            size = this.length - pos > chunkSize ? chunkSize : this.length - pos;
            out.write(this.buffer, pos, size);
            Thread.yield();
        }
    }

    public void chunkTo(OutputStream out) throws IOException {
        this.chunkTo(out, 2048);
    }

    public void readFrom(InputStream in) throws IOException {
        if (this.locked) {
            throw new IOException("ByteBuffer Is Locked");
        }
        int size = in.available();
        this.checkCapacity(this.length + size);
        in.read(this.buffer, this.length, size);
        this.length += size;
    }

    public void write(int b) throws IOException {
        if (this.locked) {
            throw new IOException("ByteBuffer Is Locked");
        }
        this.checkCapacity(this.length + 1);
        this.buffer[this.length++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        if (this.locked) {
            throw new IOException("ByteBuffer Is Locked");
        }
        this.checkCapacity(this.length + b.length);
        System.arraycopy(b, 0, this.buffer, this.length, b.length);
        this.length += b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.locked) {
            throw new IOException("ByteBuffer Is Locked");
        }
        this.checkCapacity(this.length + len);
        System.arraycopy(b, off, this.buffer, this.length, len);
        this.length += len;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.length = this.buffer.length;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.pack();
        out.defaultWriteObject();
    }

    public void lock() {
        if (!this.locked) {
            this.pack();
            this.locked = true;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

