/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.util.StringTokenizer;

public final class StringUtilities {
    private StringUtilities() {
    }

    public static int stringToInt(String value, int defvalue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defvalue;
        }
    }

    public static int stringToInt(String value) {
        return StringUtilities.stringToInt(value, 0);
    }

    public static String leftJustify(String value, int width) {
        StringBuffer sb = new StringBuffer(width);
        sb.append(value);
        for (int i = sb.length(); i < width; ++i) {
            sb.append(' ');
        }
        if (sb.length() > width) {
            sb.setLength(width);
        }
        return sb.toString();
    }

    public static String rightJustify(String value, int width) {
        StringBuffer sb = new StringBuffer(width);
        sb.append(value);
        for (int i = sb.length(); i < width; ++i) {
            sb.insert(0, ' ');
        }
        if (sb.length() > width) {
            return sb.toString().substring(sb.length() - width);
        }
        return sb.toString();
    }

    public static int findWhiteSpace(String value, int start) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > ' ') continue;
            return i;
        }
        return -1;
    }

    public static int findWhiteSpace(String value) {
        return StringUtilities.findWhiteSpace(value, 0);
    }

    public static String javaEncode(String value) {
        StringTokenizer st = new StringTokenizer(value, "\b\t\n\f\r\"'\\", true);
        StringBuffer sb = new StringBuffer(value.length());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\b")) {
                sb.append("\\b");
            } else if (token.equals("\t")) {
                sb.append("\\t");
            }
            if (token.equals("\n")) {
                sb.append("\\n");
                continue;
            }
            if (token.equals("\f")) {
                sb.append("\\f");
                continue;
            }
            if (token.equals("\r")) {
                sb.append("\\r");
                continue;
            }
            if (token.equals("\"")) {
                sb.append("\\\"");
                continue;
            }
            if (token.equals("'")) {
                sb.append("\\'");
                continue;
            }
            if (token.equals("\\")) {
                sb.append("\\\\");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }
}

