/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int id;
    int width = -1;
    int itemCount = 0;
    int[] childIds;

    public TreeItem(Tree parent, int style) {
        this(TreeItem.checkNull(parent), null, style, -1, true);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(TreeItem.checkNull(parent), null, style, TreeItem.checkIndex(index), true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, -1, true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, TreeItem.checkIndex(index), true);
    }

    TreeItem(Tree parent, TreeItem parentItem, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        this.parentItem = parentItem;
        if (create) {
            parent.createItem(this, parentItem, index);
        }
    }

    boolean _getExpanded() {
        int[] state = new int[1];
        OS.GetDataBrowserItemState(this.parent.handle, this.id, state);
        return (state[0] & 2) != 0;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static Tree checkNull(Tree parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    static int checkIndex(int index) {
        if (index < 0) {
            SWT.error(6);
        }
        return index;
    }

    int calculateWidth(int index, GC gc) {
        if (index == 0 && this.width != -1) {
            return this.width;
        }
        int width = 0;
        Image image = this.getImage(index);
        String text = this.getText(index);
        gc.setFont(this.getFont(index));
        if (image != null) {
            width += image.getBounds().width + this.parent.getGap();
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        if (this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.index = index;
            event.gc = gc;
            short[] height = new short[1];
            OS.GetDataBrowserTableViewRowHeight(this.parent.handle, height);
            event.width = width;
            event.height = height[0];
            this.parent.sendEvent(41, event);
            if (this.parent.itemHeight < event.height) {
                this.parent.itemHeight = event.height;
                OS.SetDataBrowserTableViewRowHeight(this.parent.handle, (short)event.height);
            }
            width = event.width;
        }
        if (index == 0) {
            this.width = width;
        }
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.cached = false;
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        int count = this.parent.getItemCount(this);
        if (index < 0 || index >= count) {
            SWT.error(6);
        }
        this.parent.clear(this, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.parent.clearAll(this, all);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds() {
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Rect rect = new Rect();
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[0].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, columnId, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect.left;
        int y = rect.top;
        int width = 0;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            x += bounds.width + 2;
        }
        GC gc = new GC(this.parent);
        Point extent = gc.stringExtent(this.text);
        gc.dispose();
        width += extent.x;
        if (this.parent.columnCount > 0) {
            width = Math.min(width, rect.right - x);
        }
        int height = rect.bottom - rect.top;
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.parent.handle, rect);
            x -= rect.left;
            y -= rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds(int index) {
        int height;
        int width;
        int y;
        int x;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, columnId, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] disclosure = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.parent.handle, disclosure, new boolean[1]);
        if (OS.VERSION >= 4160 && disclosure[0] != columnId) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            x = rect.left;
            y = rect.top;
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, columnId, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            x = rect2.left;
            y = rect2.top;
            width = rect.right - rect2.left + 1;
            height = rect2.bottom - rect2.top + 1;
        }
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.parent.handle, rect);
            x -= rect.left;
            y -= rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return (this.state & 0x100) != 0 ? false : this._getExpanded();
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        Rectangle bounds;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, columnId, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect.left;
        int y = rect.top;
        int width = 0;
        if (index == 0 && this.image != null) {
            bounds = this.image.getBounds();
            width += bounds.width;
        }
        if (index != 0 && this.images != null && this.images[index] != null) {
            bounds = this.images[index].getBounds();
            width += bounds.width;
        }
        int height = rect.bottom - rect.top + 1;
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.parent.handle, rect);
            x -= rect.left;
            y -= rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index >= this.itemCount) {
            this.error(6);
        }
        return this.parent._getItem(this, index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.parent.getItemCount(this);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.parent.getItems(this);
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != this) {
            return -1;
        }
        return this.parent._indexOf(this, item);
    }

    void redraw(int propertyID) {
        Rect rect;
        this.cached = true;
        if (this.parent.ignoreRedraw) {
            return;
        }
        if (this.parent.drawCount != 0 && propertyID != 1024) {
            return;
        }
        int parentHandle = this.parent.handle;
        int parentID = this.parentItem == null ? 0 : this.parentItem.id;
        int[] ids = new int[]{this.id};
        if (propertyID == 0) {
            if ((this.parent.style & 0x20) != 0) {
                OS.UpdateDataBrowserItems(parentHandle, parentID, ids.length, ids, 0, 1024);
            }
            if (this.parent.columnCount == 0) {
                OS.UpdateDataBrowserItems(parentHandle, parentID, ids.length, ids, 0, this.parent.column_id);
            } else {
                int i = 0;
                while (i < this.parent.columnCount) {
                    OS.UpdateDataBrowserItems(parentHandle, parentID, ids.length, ids, 0, this.parent.columns[i].id);
                    ++i;
                }
            }
        } else {
            OS.UpdateDataBrowserItems(parentHandle, parentID, ids.length, ids, 0, propertyID);
        }
        if (propertyID == 1024 && OS.GetDataBrowserItemPartBounds(parentHandle, this.id, propertyID, 0, rect = new Rect()) == 0) {
            Rect controlRect = new Rect();
            if (!OS.HIVIEW) {
                OS.GetControlBounds(parentHandle, controlRect);
            }
            int x = rect.left - controlRect.left;
            int y = rect.top - controlRect.top - 1;
            int width = rect.right - rect.left;
            int height = 1;
            this.redrawWidget(parentHandle, x, y, width, height, false);
        }
    }

    void releaseChildren(boolean destroy) {
        if (destroy) {
            this.parent.releaseItems(this.childIds);
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parentItem = null;
        this.id = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        int i = this.itemCount - 1;
        while (i >= 0) {
            TreeItem item = this.parent._getItem(this.childIds[i], false);
            if (item != null && !item.isDisposed()) {
                item.dispose();
            }
            --i;
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == color) {
            return;
        }
        if (this.background != null && this.background.equals(color)) {
            return;
        }
        this.background = color;
        this.cached = true;
        this.redraw(0);
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new Color[count];
        }
        if (this.cellBackground[index] == color) {
            return;
        }
        if (this.cellBackground[index] != null && this.cellBackground[index].equals(color)) {
            return;
        }
        this.cellBackground[index] = color;
        this.cached = true;
        this.redraw(0);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.cached = true;
        this.redraw(1024);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (expanded == this.getExpanded()) {
            return;
        }
        this.parent.ignoreExpand = true;
        if (expanded) {
            OS.OpenDataBrowserContainer(this.parent.handle, this.id);
        } else {
            OS.CloseDataBrowserContainer(this.parent.handle, this.id);
        }
        this.parent.ignoreExpand = false;
        this.cached = true;
        this.parent.setScrollWidth(true);
        this.parent.fixScrollBar();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.cached = true;
        this.redraw(0);
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[count];
        }
        if (this.cellFont[index] == font) {
            return;
        }
        if (this.cellFont[index] != null && this.cellFont[index].equals(font)) {
            return;
        }
        this.cellFont[index] = font;
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == color) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(color)) {
            return;
        }
        this.foreground = color;
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new Color[count];
        }
        if (this.cellForeground[index] == color) {
            return;
        }
        if (this.cellForeground[index] != null && this.cellForeground[index].equals(color)) {
            return;
        }
        this.cellForeground[index] = color;
        this.cached = true;
        this.redraw(0);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.cached = true;
        this.redraw(1024);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.images == null) {
                this.images = new Image[count];
            }
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.parent.setItemCount(this, count);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

