/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
extends ExtensionPoint {
    protected String name;
    protected String nameLang;
    protected String uri;
    protected String email;

    public Person() {
    }

    public Person(String string) {
        if (string == null) {
            throw new NullPointerException("Name must have a value");
        }
        this.name = string;
    }

    public Person(String string, String string2, String string3) {
        this(string);
        this.uri = string2;
        this.email = string3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNameLang() {
        return this.nameLang;
    }

    public void setNameLang(String string) {
        this.nameLang = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void generate(ExtensionProfile extensionProfile, XmlWriter xmlWriter, XmlWriter.Namespace namespace, String string, Collection<XmlWriter.Attribute> collection) throws IOException {
        this.generateStartElement(xmlWriter, namespace, string, collection, null);
        if (this.name != null && this.name.trim().length() > 0) {
            ArrayList<XmlWriter.Attribute> arrayList;
            if (this.nameLang != null) {
                arrayList = new ArrayList<XmlWriter.Attribute>(1);
                arrayList.add(new XmlWriter.Attribute("xml:lang", this.nameLang));
            } else {
                arrayList = null;
            }
            xmlWriter.simpleElement(Namespaces.atomNs, "name", arrayList, this.name);
        }
        if (this.uri != null && this.uri.trim().length() > 0) {
            xmlWriter.simpleElement(Namespaces.atomNs, "uri", null, this.uri);
        }
        if (this.email != null && this.email.trim().length() > 0) {
            xmlWriter.simpleElement(Namespaces.atomNs, "email", null, this.email);
        }
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(namespace, string);
    }

    public void generateAtom(ExtensionProfile extensionProfile, XmlWriter xmlWriter, String string) throws IOException {
        this.generate(extensionProfile, xmlWriter, Namespaces.atomNs, string, null);
    }

    public void generateRss(XmlWriter xmlWriter, String string) throws IOException {
        String string2 = new String();
        if (this.email != null) {
            string2 = string2 + this.email;
        }
        if (this.name != null) {
            if (this.email != null) {
                string2 = string2 + " (";
            }
            string2 = string2 + this.name;
            if (this.email != null) {
                string2 = string2 + ")";
            }
        }
        xmlWriter.simpleElement(Namespaces.rssNs, string, null, string2);
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile extensionProfile) throws IOException {
            super(extensionProfile, Person.class);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://www.w3.org/2005/Atom")) {
                if (string2.equals("name")) {
                    return new NameHandler();
                }
                if (string2.equals("uri")) {
                    return new UriHandler();
                }
                if (string2.equals("email")) {
                    return new EmailHandler();
                }
            } else {
                return super.getChildHandler(string, string2, attributes);
            }
            return null;
        }

        class EmailHandler
        extends XmlParser.ElementHandler {
            EmailHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.email != null) {
                    throw new ParseException("Duplicate email.");
                }
                if (this.value == null) {
                    throw new ParseException("Email must have a value.");
                }
                Person.this.email = this.value;
            }
        }

        class UriHandler
        extends XmlParser.ElementHandler {
            UriHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.uri != null) {
                    throw new ParseException("Duplicate URI.");
                }
                if (this.value == null) {
                    throw new ParseException("URI must have a value.");
                }
                Person.this.uri = this.value;
            }
        }

        class NameHandler
        extends XmlParser.ElementHandler {
            NameHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.name != null) {
                    throw new ParseException("Duplicate name.");
                }
                if (this.value == null) {
                    throw new ParseException("Name must have a value.");
                }
                Person.this.name = this.value;
                Person.this.nameLang = this.xmlLang;
            }
        }
    }
}

