/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Rating
extends ExtensionPoint
implements Extension {
    protected String rel;
    protected Integer rating;
    protected Integer min;
    protected Integer max;
    protected Integer numRaters;

    public String getRel() {
        return this.rel;
    }

    public void setRel(String string) {
        this.rel = string;
    }

    public int getValue() {
        return this.rating;
    }

    public void setValue(int n) {
        this.rating = n;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getNumRaters() {
        return this.numRaters;
    }

    public void setNumRaters(int n) {
        this.numRaters = n;
    }

    public static ExtensionDescription getDefaultDescription(boolean bl) {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(Rating.class);
        extensionDescription.setNamespace(Namespaces.gNs);
        extensionDescription.setLocalName("rating");
        extensionDescription.setRepeatable(bl);
        return extensionDescription;
    }

    public static ExtensionDescription getDefaultDescription() {
        return Rating.getDefaultDescription(true);
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            arrayList.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.rating != null) {
            arrayList.add(new XmlWriter.Attribute("value", this.rating.toString()));
        }
        if (this.min != null) {
            arrayList.add(new XmlWriter.Attribute("min", this.min.toString()));
        }
        if (this.max != null) {
            arrayList.add(new XmlWriter.Attribute("max", this.max.toString()));
        }
        if (this.numRaters != null) {
            arrayList.add(new XmlWriter.Attribute("numRaters", this.numRaters.toString()));
        }
        this.generateStartElement(xmlWriter, Namespaces.gNs, "rating", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.gNs, "rating");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler(extensionProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extensionProfile) throws ParseException, IOException {
            super(extensionProfile, Rating.class);
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException, NumberFormatException {
            if (string.equals("")) {
                if (string2.equals("value")) {
                    Rating.this.rating = Integer.parseInt(string3);
                } else if (string2.equals("max")) {
                    Rating.this.max = Integer.parseInt(string3);
                } else if (string2.equals("min")) {
                    Rating.this.min = Integer.parseInt(string3);
                } else if (string2.equals("rel")) {
                    Rating.this.rel = string3;
                } else if (string2.equals("numRaters")) {
                    Rating.this.numRaters = Integer.parseInt(string3);
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (Rating.this.rating == null) {
                throw new ParseException("g:rating/@value is required.");
            }
            if (Rating.this.max == null) {
                throw new ParseException("g:rating/@max is required.");
            }
            if (Rating.this.min == null) {
                throw new ParseException("g:rating/@min is required.");
            }
            if (Rating.this.rating > Rating.this.max || Rating.this.rating < Rating.this.min) {
                throw new ParseException("g:rating/@value should lie in between g:rating/@min and g:rating/@max.");
            }
        }
    }

    public static final class Rel {
        public static final String OVERALL = null;
        public static final String QUALITY = "http://schemas.google.com/g/2005#quality";
        public static final String PRICE = "http://schemas.google.com/g/2005#price";
    }
}

