/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexTopic;

public class IndexEntry
extends Index
implements IIndexEntry {
    String keyword;
    List topics;

    public IndexEntry(Comparator comparator, String keyword) {
        this(comparator, keyword, new ArrayList());
    }

    public IndexEntry(Comparator comparator, String keyword, List topics) {
        super(comparator);
        this.keyword = keyword;
        this.topics = topics;
    }

    public IndexEntry(Comparator comparator, String keyword, List topics, List subentries) {
        super(comparator, subentries);
        this.keyword = keyword;
        this.topics = topics;
    }

    public void addTopic(String label, String href, String location) {
        this.topics.add(new IndexTopic(label, href, location));
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List getTopicList() {
        return this.topics;
    }

    public IHelpResource[] getTopics() {
        if (this.topics == null) {
            return new IHelpResource[0];
        }
        IHelpResource[] topicArray = new IHelpResource[this.topics.size()];
        this.topics.toArray(topicArray);
        return topicArray;
    }

    public IIndexEntry[] getSubentries() {
        return this.getEntries();
    }
}

