/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.carbon;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class CarbonUIEnhancer
implements IStartup {
    private static final int kHICommandPreferences = 1886545254;
    private static final int kHICommandAbout = 1633841013;
    private static final int kHICommandServices = 1936028278;
    private static final String RESOURCE_BUNDLE = "org.eclipse.ui.carbon.Messages";
    private static final String TOOLBAR_BUTTON_TOGGLE_FLAGS = "toolbarButtonToggleFlags";
    private String fAboutActionName;

    public CarbonUIEnhancer() {
        IProduct product = Platform.getProduct();
        String productName = null;
        if (product != null) {
            productName = product.getName();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        try {
            String format;
            if (productName != null && (format = resourceBundle.getString("AboutAction.format")) != null) {
                this.fAboutActionName = MessageFormat.format(format, productName);
            }
            if (this.fAboutActionName == null) {
                this.fAboutActionName = resourceBundle.getString("AboutAction.name");
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (this.fAboutActionName == null) {
            this.fAboutActionName = "About";
        }
    }

    public void earlyStartup() {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                CarbonUIEnhancer.this.hookApplicationMenu(display);
                CarbonUIEnhancer.this.hookToolbarButtonCallback();
                CarbonUIEnhancer.this.hookWorkbenchListener();
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    CarbonUIEnhancer.this.modifyWindowShell(windows[i]);
                    ++i;
                }
            }
        });
    }

    protected void hookWorkbenchListener() {
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                CarbonUIEnhancer.this.modifyWindowShell(window);
            }
        });
    }

    protected void modifyWindowShell(IWorkbenchWindow window) {
        boolean coolBarInitiallyVsible = ((WorkbenchWindow)window).getCoolBarVisible();
        boolean perspectiveBarInitiallyVsible = ((WorkbenchWindow)window).getPerspectiveBarVisible();
        if (coolBarInitiallyVsible || perspectiveBarInitiallyVsible) {
            Shell shell = window.getShell();
            boolean[] switchArray = new boolean[]{coolBarInitiallyVsible, perspectiveBarInitiallyVsible};
            shell.setData(TOOLBAR_BUTTON_TOGGLE_FLAGS, (Object)switchArray);
            int windowHandle = OS.GetControlOwner((int)shell.handle);
            OS.ChangeWindowAttributes((int)windowHandle, (int)64, (int)0);
        }
    }

    protected void hookToolbarButtonCallback() {
        Object target = new Object(){

            int toolbarProc(int nextHandler, int theEvent, int userData) {
                int eventKind = OS.GetEventKind((int)theEvent);
                if (eventKind != 150) {
                    return -9874;
                }
                int[] theWindow = new int[1];
                OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)2003398244, null, (int)4, null, (int[])theWindow);
                int[] theRoot = new int[1];
                OS.GetRootControl((int)theWindow[0], (int[])theRoot);
                Widget widget = Display.getCurrent().findWidget(theRoot[0]);
                if (!(widget instanceof Shell)) {
                    return -9874;
                }
                Shell shell = (Shell)widget;
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    if (windows[i].getShell() == shell) {
                        WorkbenchWindow castedWindow = (WorkbenchWindow)windows[i];
                        boolean[] switchFlags = (boolean[])shell.getData(CarbonUIEnhancer.TOOLBAR_BUTTON_TOGGLE_FLAGS);
                        if (switchFlags == null) {
                            return -9874;
                        }
                        boolean coolbarVisible = castedWindow.getCoolBarVisible();
                        boolean perspectivebarVisible = castedWindow.getPerspectiveBarVisible();
                        if (switchFlags[0]) {
                            castedWindow.setCoolBarVisible(!coolbarVisible);
                        }
                        if (switchFlags[1]) {
                            castedWindow.setPerspectiveBarVisible(!perspectivebarVisible);
                        }
                        shell.layout();
                        return 0;
                    }
                    ++i;
                }
                return -9874;
            }
        };
        Callback commandCallback = new Callback(target, "toolbarProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{2003398244, 150};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
    }

    private void hookApplicationMenu(Display display) {
        Object target = new Object(){

            int commandProc(int nextHandler, int theEvent, int userData) {
                if (OS.GetEventKind((int)theEvent) == 1) {
                    HICommand command = new HICommand();
                    OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1751346532, null, (int)14, null, (HICommand)command);
                    switch (command.commandID) {
                        case 1886545254: {
                            return CarbonUIEnhancer.this.runAction("preferences");
                        }
                        case 1633841013: {
                            return CarbonUIEnhancer.this.runAction("about");
                        }
                    }
                }
                return -9874;
            }
        };
        final Callback commandCallback = new Callback(target, "commandProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{1668113523, 1};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
        int[] outMenu = new int[1];
        short[] outIndex = new short[1];
        if (OS.GetIndMenuItemWithCommandID((int)0, (int)1886545254, (int)1, (int[])outMenu, (short[])outIndex) == 0 && outMenu[0] != 0) {
            int menu = outMenu[0];
            int l = this.fAboutActionName.length();
            char[] buffer = new char[l];
            this.fAboutActionName.getChars(0, l, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)0, (int)0, (int)1633841013);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)1, (int)64, (int)0);
            OS.EnableMenuCommand((int)menu, (int)1886545254);
            OS.DisableMenuCommand((int)menu, (int)1936028278);
        }
        display.disposeExec(new Runnable(){

            public void run() {
                commandCallback.dispose();
            }
        });
    }

    private int runAction(String actionId) {
        Shell shell;
        Menu menubar;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (menubar = (shell = window.getShell()).getMenuBar()) != null) {
            int i = 0;
            while (i < menubar.getItemCount()) {
                MenuItem mi = menubar.getItem(i);
                Menu m = mi.getMenu();
                int j = 0;
                while (j < m.getItemCount()) {
                    IAction action;
                    ActionContributionItem aci;
                    String id;
                    MenuItem mi2 = m.getItem(j);
                    Object o = mi2.getData();
                    if (o instanceof ActionContributionItem && (id = (aci = (ActionContributionItem)o).getId()) != null && id.equals(actionId) && (action = aci.getAction()) != null && action.isEnabled()) {
                        action.run();
                        return 0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return -9874;
    }
}

