/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFilePluginContentConsumer
extends ContentConsumer {
    private IPluginEntry pluginEntry;
    private ISite site;
    private boolean closed = false;
    private Map renames = new HashMap(2);
    private List installedFiles;

    public SiteFilePluginContentConsumer(IPluginEntry pluginEntry, ISite site) {
        this.pluginEntry = pluginEntry;
        this.site = site;
        this.installedFiles = new ArrayList();
    }

    /*
     * Exception decompiling
     */
    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 359->363)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        Iterator it = this.renames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String temporary = (String)entry.getKey();
            String original = (String)entry.getValue();
            ErrorRecoveryLog.getLog().appendPath("RENAME", temporary);
            File fileToRename = new File(temporary);
            boolean sucess = false;
            if (fileToRename.exists()) {
                File renamedFile = new File(original);
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (sucess) continue;
            String msg = NLS.bind((String)Messages.ContentConsumer_UnableToRename, (Object[])new String[]{temporary, original});
            throw Utilities.newCoreException(msg, new Exception(msg));
        }
        if (this.site instanceof SiteFile) {
            ((SiteFile)this.site).addPluginEntry(this.pluginEntry);
        }
        this.closed = true;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        boolean success = true;
        InstallRegistry.unregisterPlugin(this.pluginEntry);
        Iterator it = this.renames.values().iterator();
        while (it.hasNext()) {
            String originalName = (String)it.next();
            ErrorRecoveryLog.getLog().appendPath("DELETE", originalName);
            File fileToRemove = new File(originalName);
            if (!fileToRemove.exists() || fileToRemove.delete()) continue;
            String msg = NLS.bind((String)Messages.SiteFilePluginContentConsumer_unableToDelete, (Object[])new String[]{originalName});
            UpdateCore.log(msg, null);
            success = false;
        }
        if (success) {
            Iterator iter = this.installedFiles.iterator();
            File featureFile = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                featureFile = new File(path);
                UpdateManagerUtils.removeFromFileSystem(featureFile);
            }
            try {
                URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString());
                String pluginPath = newURL.getFile();
                UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(pluginPath));
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(e.getMessage(), e);
            }
        }
        this.closed = true;
    }
}

