/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kind {
    private static Map<String, List<Class<Adaptor>>> kindAdaptors = new HashMap<String, List<Class<Adaptor>>>();

    public static boolean isKindCategory(Category category) {
        return "http://schemas.google.com/g/2005#kind".equals(category.getScheme());
    }

    public static String getKindServiceName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        try {
            int n;
            URL uRL = new URL(string);
            String[] stringArray = uRL.getHost().split("\\W");
            for (int i = n = stringArray.length - 1; i >= 0; --i) {
                if (i != n) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(stringArray[i]);
            }
            String[] stringArray2 = uRL.getPath().split("\\W");
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].length() <= 0) continue;
                stringBuilder.append(".");
                stringBuilder.append(stringArray2[i]);
            }
            if (uRL.getRef() != null) {
                String[] stringArray3 = uRL.getRef().split("\\W");
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (stringArray3[i].length() <= 0) continue;
                    stringBuilder.append(".");
                    stringBuilder.append(stringArray3[i]);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Kind term must be a valid URL", malformedURLException);
        }
        return stringBuilder.toString();
    }

    public static Class<Adaptor> getAdaptorClass(String string, Adaptable adaptable) throws AdaptorException {
        Object object;
        String string2;
        ClassLoader classLoader = adaptable.getClass().getClassLoader();
        List<Class<Adaptor>> list = kindAdaptors.get(string);
        if (list == null) {
            list = new ArrayList<Class<Adaptor>>();
            string2 = Kind.getKindServiceName(string);
            try {
                InputStream inputStream = classLoader.getResourceAsStream("META-INF/gdata/kinds/" + string2);
                if (inputStream == null) {
                    return null;
                }
                BufferedReader object2 = new BufferedReader(new InputStreamReader(inputStream));
                while ((object = object2.readLine()) != null) {
                    if (((String)object).charAt(0) == '#') continue;
                    list.add(classLoader.loadClass((String)object));
                }
            }
            catch (IOException iOException) {
                throw new AdaptorException("Unable to load Adaptor service info", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AdaptorException("Unable to load Adaptor class", classNotFoundException);
            }
            kindAdaptors.put(string, list);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        string2 = null;
        for (Class<Adaptor> clazz : list) {
            object = adaptable.getClass();
            while (Adaptable.class.isAssignableFrom((Class<?>)object)) {
                if (((Class)object).isAssignableFrom(clazz)) {
                    return clazz;
                }
                object = ((Class)object).getSuperclass();
            }
        }
        return null;
    }

    public static Adaptor getAdaptor(String string, Adaptable adaptable) throws AdaptorException {
        Class<Adaptor> clazz = Kind.getAdaptorClass(string, adaptable);
        if (clazz == null) {
            return null;
        }
        Adaptor adaptor = adaptable.getAdaptor(clazz);
        if (adaptor == null) {
            Class<?> clazz2;
            Constructor<Adaptor> constructor = null;
            for (clazz2 = adaptable.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                try {
                    constructor = clazz.getConstructor(clazz2);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (constructor == null) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AdaptorException("Unable to construct Adaptor " + clazz + " instance for " + adaptable.getClass());
                }
            }
            try {
                adaptor = clazz2 == null ? constructor.newInstance(new Object[0]) : constructor.newInstance(adaptable);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new AdaptorException("Unable to create kind Adaptor", exception);
            }
            adaptable.addAdaptor(adaptor);
        }
        return adaptor;
    }

    public static class AdaptorException
    extends ServiceException {
        public AdaptorException(String string) {
            super(string);
            this.setHttpErrorCodeOverride(500);
        }

        public AdaptorException(String string, Throwable throwable) {
            super(string, throwable);
            this.setHttpErrorCodeOverride(500);
        }

        public AdaptorException(Throwable throwable) {
            super(throwable);
            this.setHttpErrorCodeOverride(500);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdaptableHelper
    implements Adaptable {
        private List<Adaptor> adaptors = new ArrayList<Adaptor>();

        @Override
        public void addAdaptor(Adaptor adaptor) {
            this.adaptors.add(adaptor);
        }

        @Override
        public Collection<Adaptor> getAdaptors() {
            return this.adaptors;
        }

        @Override
        public <E extends Adaptor> E getAdaptor(Class<E> clazz) {
            for (Adaptor adaptor : this.adaptors) {
                if (!adaptor.getClass().equals(clazz)) continue;
                return (E)adaptor;
            }
            return null;
        }
    }

    public static interface Adaptor {
        public void declareExtensions(ExtensionProfile var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adaptable {
        public void addAdaptor(Adaptor var1);

        public Collection<Adaptor> getAdaptors();

        public <E extends Adaptor> E getAdaptor(Class<E> var1);
    }

    @Target(value={ElementType.TYPE})
    public static @interface Term {
        public String value();
    }
}

