/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoGetter;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PubMedSAX
extends PaperInfoGetter {
    public PubMedSAX() {
        super("PubMedSAX");
    }

    public Hashtable fetchURLParameter(String id) throws CannotGetPaperInfoException {
        try {
            String urlAddress = null;
            urlAddress = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=";
            String en = URLEncoder.encode(id, "UTF-8");
            urlAddress = String.valueOf(urlAddress) + en + "[UID]";
            urlAddress = String.valueOf(urlAddress) + "&retmax=1&usehistory=y";
            System.out.println("iPapers URL:" + urlAddress);
            URL url = new URL(urlAddress);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputStream is = url.openStream();
            InputSource inputSource = new InputSource(is);
            XmlSAX_QueryKeyAndWebEnv xsqw = new XmlSAX_QueryKeyAndWebEnv();
            saxParser.parse(inputSource, (DefaultHandler)xsqw);
            Hashtable<String, String> urlInfo = new Hashtable<String, String>();
            urlInfo.put("QuerrKey", xsqw.getQueryKey());
            urlInfo.put("WebEnv", xsqw.getWebEnv());
            is.close();
            return urlInfo;
        }
        catch (MalformedURLException malformedURLException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (SAXException sAXException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (IOException iOException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
    }

    public PaperInfo fetchInfo(String id) throws CannotGetPaperInfoException {
        try {
            Hashtable urlInfo = this.fetchURLParameter(id);
            String urlAddress = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed";
            urlAddress = String.valueOf(urlAddress) + "&query_key=";
            urlAddress = String.valueOf(urlAddress) + urlInfo.get("QueryKey");
            urlAddress = String.valueOf(urlAddress) + "&WebEnv=";
            urlAddress = String.valueOf(urlAddress) + urlInfo.get("WebEnv");
            urlAddress = String.valueOf(urlAddress) + "&retmode=xml";
            URL url = new URL(urlAddress);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputStream is = url.openStream();
            InputSource inputSource = new InputSource(is);
            XmlSAX_Result xsr = new XmlSAX_Result();
            saxParser.parse(inputSource, (DefaultHandler)xsr);
            Hashtable items = new Hashtable();
            items = xsr.getItems();
            is.close();
            ArticleInfo info = new ArticleInfo();
            info.setAbstract((String)items.get("Abstract"));
            info.setAuthor((String)items.get("Author"));
            info.setTitle((String)items.get("Title"));
            info.setJournal((String)items.get("Journal"));
            info.setVolume((String)items.get("Volume"));
            info.setIssue((String)items.get("Number"));
            info.setPages((String)items.get("Pages"));
            return info;
        }
        catch (MalformedURLException malformedURLException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (SAXException sAXException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (IOException iOException) {
            throw new CannotGetPaperInfoException(id, "PubMed");
        }
        catch (CannotGetPaperInfoException e) {
            throw e;
        }
    }

    public ArrayList search(String query) throws Exception {
        ArrayList result = new ArrayList();
        return result;
    }

    public class XmlSAX_QueryKeyAndWebEnv
    extends DefaultHandler {
        String elementpath = null;
        String QueryKey = "";
        String WebEnv = "";

        public String getQueryKey() {
            return this.QueryKey;
        }

        public String getWebEnv() {
            return this.WebEnv;
        }

        public void startDocument() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
        }

        public void characters(char[] ch, int start, int length) {
            if (this.elementpath.equalsIgnoreCase("eSearchResult/QueryKey")) {
                this.QueryKey = new String(ch, start, length);
            } else if (this.elementpath.equalsIgnoreCase("eSearchResult/WebEnv")) {
                this.WebEnv = new String(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            String[] values = this.elementpath.split("/");
            this.elementpath = "";
            int i = 0;
            while (i < values.length - 1) {
                this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
                ++i;
            }
        }

        public void endDocument() {
            System.out.println("iPapers ===>endDocument");
        }
    }

    public class XmlSAX_Result
    extends DefaultHandler {
        private final int AUTHOR_INDEX = 0;
        private final int TITLE_INDEX = 1;
        private final int JOURNAL_INDEX = 2;
        private final int YEAR_INDEX = 3;
        private final int VOLUME_INDEX = 4;
        private final int NUMBER_INDEX = 5;
        private final int PAGES_INDEX = 6;
        private final int ABSTRACT_INDEX = 7;
        private final int IDS_INDEX = 8;
        private final int URL_INDEX = 9;
        private String[] properties = new String[]{"Author", "Title", "Journal", "Year", "Volume", "Number", "Pages", "Abstract", "IDs", "URL"};
        String elementpath = null;
        private Hashtable<String, String> items = null;
        private ArrayList<Hashtable<String, String>> authors = null;
        private Hashtable<String, String> author = null;
        private String idtype = null;

        public Hashtable getItems() {
            return this.items;
        }

        public void startDocument() {
            System.out.println("iPapers ===>startDocument");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation")) {
                this.items = new Hashtable();
                int i = 0;
                while (i < this.properties.length) {
                    this.items.put(this.properties[i], new String());
                    ++i;
                }
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList")) {
                this.authors = new ArrayList();
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author")) {
                this.author = new Hashtable();
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                this.idtype = atts.getValue("IdType");
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/ArticleTitle")) {
                String value = this.items.get(this.properties[1]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[1], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/PMID")) {
                String value = new String(ch, start, length);
                String url = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/elink.fcgi?dbfrom=pubmed&id=" + value + "&retmode=ref&cmd=prlinks";
                this.items.put(this.properties[9], url);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                if (this.idtype.equalsIgnoreCase("pubmed") || this.idtype.equalsIgnoreCase("doi")) {
                    String cont = this.items.get(this.properties[8]);
                    String newValue = String.valueOf(this.idtype) + ":=" + new String(ch, start, length);
                    cont = cont != null && cont.length() > 0 ? String.valueOf(cont) + ", " + newValue : newValue;
                    this.items.put(this.properties[8], cont);
                }
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Abstract/AbstractText")) {
                String value = this.items.get(this.properties[7]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[7], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/MedlineJournalInfo/MedlineTA")) {
                String value = this.items.get(this.properties[2]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[2], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Pagination/MedlinePgn")) {
                String value = this.items.get(this.properties[6]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[6], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/Issue")) {
                String value = this.items.get(this.properties[5]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[5], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/Volume")) {
                String value = this.items.get(this.properties[4]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[4], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/PubDate/MedlineDate")) {
                String value = new String(ch, start, length);
                String[] values = value.split(" ");
                if (values.length > 0) {
                    this.items.put(this.properties[3], values[0]);
                }
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/PubDate/Year")) {
                String value = new String(ch, start, length);
                this.items.put(this.properties[3], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/LastName")) {
                String value = new String(ch, start, length);
                this.author.put("LastName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/FirstName")) {
                String value = new String(ch, start, length);
                this.author.put("FirstName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/MiddleName")) {
                String value = new String(ch, start, length);
                this.author.put("MiddleName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/Initials")) {
                String value = new String(ch, start, length);
                this.author.put("Initials", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/ForeName")) {
                String value = new String(ch, start, length);
                this.author.put("ForeName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/CollectiveName")) {
                String value = new String(ch, start, length);
                this.author.put("CollectiveName", value);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            int i;
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author") && this.authors != null) {
                if (this.author != null && !this.author.isEmpty()) {
                    this.authors.add(this.author);
                }
                this.author = null;
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList") && this.authors != null) {
                String name = "";
                i = 0;
                while (i < this.authors.size()) {
                    Hashtable<String, String> ht = this.authors.get(i);
                    String CollectiveName = ht.get("CollectiveName");
                    String Initials = ht.get("Initials");
                    String LastName = ht.get("LastName");
                    if (LastName == null) {
                        LastName = "";
                    }
                    if (Initials == null) {
                        Initials = "";
                    }
                    String value = "";
                    if (CollectiveName != null) {
                        value = CollectiveName;
                    } else if (LastName != null) {
                        value = LastName;
                        if (Initials != null) {
                            value = String.valueOf(value) + " " + Initials;
                        }
                    }
                    if (value.length() > 0) {
                        if (name.length() > 0) {
                            name = String.valueOf(name) + ", ";
                        }
                        name = String.valueOf(name) + value;
                    }
                    ++i;
                }
                if (name.length() > 0) {
                    this.items.put(this.properties[0], name);
                }
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                this.idtype = null;
            }
            String[] values = this.elementpath.split("/");
            this.elementpath = "";
            i = 0;
            while (i < values.length - 1) {
                this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
                ++i;
            }
        }

        public void endDocument() {
            System.out.println("iPapers ===>endDocument");
        }
    }
}

