/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.QueryComposeData;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearch;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearchList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryComposeDialog
extends Dialog {
    private static final int NUMBER_OF_ITEMS = 5;
    public static final int ADD = 0;
    public static final int EDIT = 1;
    public static final int REMOVE = 2;
    private SmartSearch item = null;
    private QueryComposeAreaList area = null;
    private Label name = null;
    private Text txtName = null;
    private Label time = null;
    private Text txtTime = null;
    private Label period = null;
    private CCombo comPeriod = null;
    private int mode;

    public QueryComposeDialog(Shell parent) {
        super(parent);
    }

    public QueryComposeDialog(Shell parent, SmartSearch smartSearchItem, int m) {
        super(parent);
        this.item = smartSearchItem;
        this.mode = m;
    }

    protected void configureShell(Shell myshell) {
        super.configureShell(myshell);
        myshell.setText("Smart search Edit Dialog for iPapers");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Group rig = new Group(parent, 64);
        rig.setLayoutData((Object)new GridData(1808));
        rig.setLayout((Layout)new FormLayout());
        rig.setText("SmartSearch Info");
        this.name = new Label((Composite)rig, 0);
        this.name.setText("Name");
        this.name.setAlignment(131072);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        this.name.setLayoutData((Object)fd);
        this.txtName = new Text((Composite)rig, 2052);
        this.txtName.setSize(400, 36);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment((Control)this.name);
        this.txtName.setLayoutData((Object)fd);
        this.time = new Label((Composite)rig, 0);
        this.time.setText("Latest Search");
        this.time.setAlignment(131072);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment((Control)this.txtName);
        this.time.setLayoutData((Object)fd);
        this.txtTime = new Text((Composite)rig, 2052);
        this.txtTime.setSize(400, 36);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment((Control)this.time);
        this.txtTime.setLayoutData((Object)fd);
        this.period = new Label((Composite)rig, 0);
        this.period.setText("Periodic search");
        this.period.setAlignment(131072);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.txtName);
        fd.left = new FormAttachment(0, 0);
        this.period.setLayoutData((Object)fd);
        this.comPeriod = new CCombo((Composite)rig, 4);
        this.comPeriod.add("Manually");
        this.comPeriod.add("Daily");
        this.comPeriod.add("Weekly");
        this.comPeriod.add("Monthly");
        this.comPeriod.select(0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.txtName);
        fd.left = new FormAttachment((Control)this.time);
        this.comPeriod.setLayoutData((Object)fd);
        this.area = new QueryComposeAreaList(parent);
        int i = 0;
        while (i < 5) {
            this.area.addArea();
            ++i;
        }
        if (this.mode == 0) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            this.txtTime.setText(df.format(this.item.getSearchTime()));
            this.time.setText("Search From");
        } else if (this.mode == 1) {
            this.txtName.setText(this.item.getName());
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            this.txtTime.setText(df.format(this.item.getSearchTime()));
            this.comPeriod.setText(this.item.getPeriod());
            int i2 = 0;
            while (i2 < 5) {
                if (this.item.get(i2).getTarget() != null) {
                    this.area.get((int)i2).target.setText(this.item.get(i2).getTarget());
                }
                if (this.item.get(i2).getKeyword() != null) {
                    this.area.get((int)i2).keyword.setText(this.item.get(i2).getKeyword());
                }
                if (this.item.get(i2).getParameter() != null) {
                    this.area.get((int)i2).parameter.setText(this.item.get(i2).getParameter());
                }
                ++i2;
            }
        }
        dialog.layout();
        return dialog;
    }

    protected void buttonPressed(int button) {
        if (button == 0) {
            if (this.txtName.getText() != null) {
                this.item.setName(this.txtName.getText());
                this.item.setPeriod(this.comPeriod.getText());
                DateFormat df = DateFormat.getDateTimeInstance(2, 2);
                Date date = null;
                try {
                    date = df.parse(this.txtTime.getText());
                }
                catch (ParseException e) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                }
                this.item.setSearchTime(new Timestamp(date.getTime()));
                int i = 0;
                while (i < 5) {
                    this.item.get(i).setTarget(this.area.get((int)i).target.getText());
                    this.item.get(i).setKeyword(this.area.get((int)i).keyword.getText());
                    this.item.get(i).setParameter(this.area.get((int)i).parameter.getText());
                    ++i;
                }
            }
            if (this.mode == 0) {
                SmartSearchList.getInstance().addSmartSearch(this.item);
            } else if (this.mode == 1) {
                SmartSearchList.getInstance().updateSmartSearch(this.item);
            }
            this.item.setTimer();
            this.close();
        } else if (button == 1) {
            this.close();
        }
    }

    private static class QueryComposeArea {
        public Composite parent = null;
        public CCombo target = null;
        public CCombo keyword = null;
        public CCombo parameter = null;
        private Group above = null;
        public Group rig = null;

        public QueryComposeArea(Composite p) {
            this.parent = p;
        }

        public QueryComposeArea(Composite p, Group a) {
            this.parent = p;
            this.above = a;
        }

        private void addQueryArea() {
            this.rig = new Group(this.parent, 64);
            this.rig.setLayoutData((Object)new GridData(768));
            this.rig.setLayout((Layout)new FormLayout());
            FormData fdr = new FormData();
            fdr.top = this.above != null ? new FormAttachment((Control)this.above, 0) : new FormAttachment(0, 0);
            this.target = new CCombo((Composite)this.rig, 65544);
            this.target.setBounds(0, 0, 150, 200);
            String[] stringArray = QueryComposeData.targetData;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String t = stringArray[n];
                this.target.add(t);
                ++n;
            }
            this.target.select(0);
            this.target.setVisibleItemCount(QueryComposeData.targetData.length);
            this.target.setLayoutData((Object)fdr);
            this.target.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    QueryComposeData.setParameterItems(QueryComposeArea.this.target.getText(), QueryComposeArea.this.parameter, QueryComposeArea.this.keyword);
                }
            });
            fdr = new FormData();
            fdr.top = this.above != null ? new FormAttachment((Control)this.above, 0) : new FormAttachment(0, 0);
            fdr.left = new FormAttachment((Control)this.target, 0);
            this.keyword = new CCombo((Composite)this.rig, 4);
            this.keyword.setBounds(0, 0, 500, 200);
            this.keyword.add("enter keyword");
            this.keyword.setLayoutData((Object)fdr);
            fdr = new FormData();
            fdr.top = this.above != null ? new FormAttachment((Control)this.above, 0) : new FormAttachment(0, 0);
            fdr.left = new FormAttachment((Control)this.keyword, 0);
            this.parameter = new CCombo((Composite)this.rig, 8);
            this.parameter.setBounds(0, 0, 150, 100);
            this.parameter.add("");
            this.parameter.add("Include");
            this.parameter.add("Exclude");
            this.parameter.select(0);
            this.parameter.setVisibleItemCount(3);
            this.parameter.setLayoutData((Object)fdr);
        }
    }

    private class QueryComposeAreaList {
        ArrayList<QueryComposeArea> list = new ArrayList();
        Composite parent;

        public QueryComposeAreaList(Composite p) {
            this.parent = p;
        }

        public void addArea() {
            QueryComposeArea a = null;
            if (this.list.size() == 0) {
                a = new QueryComposeArea(this.parent);
                a.addQueryArea();
            } else {
                Group above = this.list.get((int)(this.list.size() - 1)).rig;
                a = new QueryComposeArea(this.parent, above);
                a.addQueryArea();
            }
            this.list.add(a);
            this.parent.layout();
        }

        public QueryComposeArea get(int i) {
            return this.list.get(i);
        }
    }
}

