/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartQuery;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearch;
import jp.sourceforge.concierge.plugin.ipapers.view.SmartSearchListener;
import org.eclipse.core.runtime.ListenerList;

public class SmartSearchList {
    private final List<SmartSearch> smartList = new ArrayList<SmartSearch>();
    private final ListenerList listenerList = new ListenerList();
    private static final SmartQuery smartQuery = new SmartQuery();
    private static final SmartSearchList singleton = new SmartSearchList();

    public static SmartSearchList getInstance() {
        return singleton;
    }

    public List getSmartSearchList() {
        return this.smartList;
    }

    public SmartSearchList() {
        ArrayList lists = smartQuery.getAllSmartQuery();
        int i = 0;
        while (i < lists.size()) {
            ((SmartSearch)lists.get(i)).setTimer();
            this.initSmartSearch((SmartSearch)lists.get(i));
            ++i;
        }
    }

    public void initSmartSearch(SmartSearch item) {
        this.smartList.add(item);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            SmartSearchListener listener = (SmartSearchListener)listeners[i];
            listener.smartAdded(item);
            ++i;
        }
    }

    public void addSmartSearch(SmartSearch item) {
        this.smartList.add(item);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            SmartSearchListener listener = (SmartSearchListener)listeners[i];
            listener.smartAdded(item);
            ++i;
        }
        smartQuery.addQuery(item);
        smartQuery.saveFile();
    }

    public void removeSmartSearch(SmartSearch item) {
        this.smartList.remove(item);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            SmartSearchListener listener = (SmartSearchListener)listeners[i];
            listener.smartRemove(item);
            ++i;
        }
        smartQuery.removeQuery(item);
        smartQuery.saveFile();
    }

    public void addSmartSearchListener(SmartSearchListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeSmartSearchListener(SmartSearchListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void updateSmartSearch(SmartSearch item) {
        smartQuery.updateQuery(item);
        smartQuery.saveFile();
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            SmartSearchListener listener = (SmartSearchListener)listeners[i];
            listener.smartUpdate(item);
            ++i;
        }
    }
}

