/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.Query;
import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Feed;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.introspection.ServiceDocument;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final String SERVICE_VERSION = "GData-Java/" + Service.class.getPackage().getImplementationVersion();
    protected ExtensionProfile extProfile = new ExtensionProfile();
    protected GDataRequestFactory requestFactory = new HttpGDataRequest.Factory();
    private ContentType contentType = new ContentType("application/atom+xml; charset=utf-8");
    protected int connectTimeout = -1;
    int readTimeout = -1;

    public Service() {
        this.requestFactory.setHeader("User-Agent", this.getServiceVersion());
        new Feed().declareExtensions(this.extProfile);
    }

    public String getServiceVersion() {
        return SERVICE_VERSION;
    }

    public ExtensionProfile getExtensionProfile() {
        return this.extProfile;
    }

    public void setExtensionProfile(ExtensionProfile extensionProfile) {
        this.extProfile = extensionProfile;
    }

    public GDataRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(GDataRequestFactory gDataRequestFactory) {
        this.requestFactory = gDataRequestFactory;
    }

    public GDataRequest createRequest(GDataRequest.RequestType requestType, URL uRL, ContentType contentType) throws IOException, ServiceException {
        GDataRequest gDataRequest = this.requestFactory.getRequest(requestType, uRL, contentType);
        if (this.connectTimeout >= 0) {
            gDataRequest.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            gDataRequest.setReadTimeout(this.readTimeout);
        }
        return gDataRequest;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.connectTimeout = n;
    }

    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.readTimeout = n;
    }

    public <S extends ServiceDocument> S introspect(URL uRL, Class<S> clazz) throws IOException, ServiceException {
        String string = uRL.getQuery();
        if (string == null || string.indexOf("alt=atom-service") == -1) {
            char c = string == null ? (char)'?' : '&';
            uRL = new URL(uRL.toString() + c + "alt=atom-service");
        }
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createFeedRequest(uRL);
        try {
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            ServiceDocument serviceDocument = (ServiceDocument)clazz.newInstance();
            serviceDocument.parse(this.extProfile, inputStream);
            ServiceDocument serviceDocument2 = serviceDocument;
            return (S)serviceDocument2;
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceException("Unable to create service document instance", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceException("Unable to create service document instance", illegalAccessException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F extends BaseFeed> F getFeed(URL uRL, Class<F> clazz, DateTime dateTime) throws IOException, ServiceException {
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createFeedRequest(uRL);
        try {
            BaseFeed baseFeed;
            gDataRequest.setIfModifiedSince(dateTime);
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            try {
                baseFeed = (BaseFeed)clazz.newInstance();
                baseFeed.setService(this);
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceException("Unable to create Feed instance", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceException("Unable to create Feed instance", illegalAccessException);
            }
            baseFeed.parseAtom(this.extProfile, inputStream);
            BaseFeed baseFeed2 = baseFeed;
            return (F)baseFeed2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public <F extends BaseFeed> F getFeed(URL uRL, Class<F> clazz) throws IOException, ServiceException {
        return this.getFeed(uRL, clazz, null);
    }

    public GDataRequest createFeedRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, uRL, this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry> E getEntry(URL uRL, Class<E> clazz, DateTime dateTime) throws IOException, ServiceException {
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createEntryRequest(uRL);
        try {
            BaseEntry baseEntry;
            gDataRequest.setIfModifiedSince(dateTime);
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            try {
                baseEntry = (BaseEntry)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceException("Unable to create feed instance", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceException("Unable to create feed instance", illegalAccessException);
            }
            baseEntry.setService(this);
            baseEntry.parseAtom(this.extProfile, inputStream);
            BaseEntry baseEntry2 = baseEntry;
            return (E)baseEntry2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public <E extends BaseEntry> E getEntry(URL uRL, Class<E> clazz) throws IOException, ServiceException {
        return this.getEntry(uRL, clazz, null);
    }

    public GDataRequest createEntryRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, uRL, this.contentType);
    }

    public <F extends BaseFeed> F query(Query query, Class<F> clazz, DateTime dateTime) throws IOException, ServiceException {
        return this.getFeed(query.getUrl(), clazz, dateTime);
    }

    public <F extends BaseFeed> F query(Query query, Class<F> clazz) throws IOException, ServiceException {
        return this.query(query, clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry> E insert(URL uRL, E e) throws IOException, ServiceException {
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createInsertRequest(uRL);
        try {
            BaseEntry baseEntry;
            OutputStream outputStream = gDataRequest.getRequestStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
            XmlWriter xmlWriter = new XmlWriter(outputStreamWriter);
            e.generateAtom(xmlWriter, this.extProfile);
            ((Writer)outputStreamWriter).flush();
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            try {
                baseEntry = (BaseEntry)e.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceException("Unable to create feed instance", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceException("Unable to create feed instance", illegalAccessException);
            }
            baseEntry.parseAtom(this.extProfile, inputStream);
            baseEntry.setService(this);
            BaseEntry baseEntry2 = baseEntry;
            return (E)baseEntry2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F extends BaseFeed> F batch(URL uRL, F f) throws IOException, ServiceException, BatchInterruptedException {
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createInsertRequest(uRL);
        try {
            ExtensionPoint extensionPoint;
            BatchInterrupted batchInterrupted;
            BaseFeed baseFeed;
            OutputStream outputStream = gDataRequest.getRequestStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
            XmlWriter xmlWriter = new XmlWriter(outputStreamWriter);
            f.generateAtom(xmlWriter, this.extProfile);
            ((Writer)outputStreamWriter).flush();
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            try {
                baseFeed = (BaseFeed)f.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceException("Unable to create feed instance", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceException("Unable to create feed instance", illegalAccessException);
            }
            baseFeed.parseAtom(this.extProfile, inputStream);
            baseFeed.setService(this);
            int n = baseFeed.getEntries().size();
            if (n > 0 && (batchInterrupted = BatchUtils.getBatchInterrupted((BaseEntry)(extensionPoint = (BaseEntry)baseFeed.getEntries().get(n - 1)))) != null) {
                throw new BatchInterruptedException(baseFeed, batchInterrupted);
            }
            extensionPoint = baseFeed;
            return (F)extensionPoint;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public GDataRequest createInsertRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.INSERT, uRL, this.contentType);
    }

    public GDataRequest createBatchRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.BATCH, uRL, this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry> E update(URL uRL, E e) throws IOException, ServiceException {
        InputStream inputStream = null;
        GDataRequest gDataRequest = this.createUpdateRequest(uRL);
        try {
            BaseEntry baseEntry;
            OutputStream outputStream = gDataRequest.getRequestStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
            XmlWriter xmlWriter = new XmlWriter(outputStreamWriter);
            e.generateAtom(xmlWriter, this.extProfile);
            ((Writer)outputStreamWriter).flush();
            gDataRequest.execute();
            inputStream = gDataRequest.getResponseStream();
            try {
                baseEntry = (BaseEntry)e.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceException("Unable to create feed instance", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceException("Unable to create feed instance", illegalAccessException);
            }
            baseEntry.parseAtom(this.extProfile, inputStream);
            baseEntry.setService(this);
            BaseEntry baseEntry2 = baseEntry;
            return (E)baseEntry2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public GDataRequest createUpdateRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.UPDATE, uRL, this.contentType);
    }

    public void delete(URL uRL) throws IOException, ServiceException {
        GDataRequest gDataRequest = this.createDeleteRequest(uRL);
        gDataRequest.execute();
    }

    public GDataRequest createDeleteRequest(URL uRL) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.DELETE, uRL, this.contentType);
    }

    public static interface GDataRequestFactory {
        public void setHeader(String var1, String var2);

        public void setPrivateHeader(String var1, String var2);

        public GDataRequest getRequest(GDataRequest.RequestType var1, URL var2, ContentType var3) throws IOException, ServiceException;
    }

    public static interface GDataRequest {
        public void setConnectTimeout(int var1);

        public void setReadTimeout(int var1);

        public void setIfModifiedSince(DateTime var1);

        public OutputStream getRequestStream() throws IOException;

        public void execute() throws IOException, ServiceException;

        public InputStream getResponseStream() throws IOException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RequestType {
            QUERY,
            INSERT,
            UPDATE,
            DELETE,
            BATCH;

        }
    }
}

