/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTime
implements Comparable {
    protected long value = 0L;
    protected boolean dateOnly = false;
    protected Integer tzShift = null;
    public static final Pattern dateTimePattern = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    public static final Pattern datePattern = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    public static final Pattern dateTimeChoicePattern = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)([Tt](\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?)?([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    private static final SimpleDateFormat dateTimeFormat822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);

    public DateTime() {
    }

    public DateTime(long l) {
        this.value = l;
    }

    public DateTime(Date date) {
        this.value = date.getTime();
    }

    public DateTime(long l, int n) {
        this.value = l;
        this.tzShift = new Integer(n);
    }

    public DateTime(Date date, TimeZone timeZone) {
        this.value = date.getTime();
        this.tzShift = timeZone.getOffset(date.getTime()) / 60000;
    }

    public static DateTime now() {
        return new DateTime(new Date(), TimeZone.getTimeZone("GMT"));
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public boolean isDateOnly() {
        return this.dateOnly;
    }

    public void setDateOnly(boolean bl) {
        this.dateOnly = bl;
    }

    public Integer getTzShift() {
        return this.tzShift;
    }

    public void setTzShift(Integer n) {
        this.tzShift = n;
    }

    public int hashCode() {
        return new Long(this.value).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DateTime) {
            DateTime dateTime = (DateTime)object;
            return this.value == dateTime.value && (this.tzShift == null && dateTime.tzShift == null || this.tzShift != null && this.tzShift.equals(dateTime.tzShift));
        }
        if (object instanceof Date) {
            return this.value == ((Date)object).getTime();
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof DateTime) {
            return new Long(this.value).compareTo(new Long(((DateTime)object).value));
        }
        if (object instanceof Date) {
            return new Long(this.value).compareTo(new Long(((Date)object).getTime()));
        }
        throw new RuntimeException("Invalid type.");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        long l = this.value;
        if (this.tzShift != null) {
            l += this.tzShift.longValue() * 60000L;
        }
        gregorianCalendar.setTimeInMillis(l);
        try {
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(1), 4);
            stringBuilder.append('-');
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(2) + 1, 2);
            stringBuilder.append('-');
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(5), 2);
            if (!this.dateOnly) {
                stringBuilder.append('T');
                DateTime.appendInt(stringBuilder, gregorianCalendar.get(11), 2);
                stringBuilder.append(':');
                DateTime.appendInt(stringBuilder, gregorianCalendar.get(12), 2);
                stringBuilder.append(':');
                DateTime.appendInt(stringBuilder, gregorianCalendar.get(13), 2);
                if (gregorianCalendar.isSet(14)) {
                    stringBuilder.append('.');
                    DateTime.appendInt(stringBuilder, gregorianCalendar.get(14), 3);
                }
            }
            if (this.tzShift != null) {
                if (this.tzShift == 0) {
                    stringBuilder.append('Z');
                } else {
                    int n = this.tzShift;
                    if (this.tzShift > 0) {
                        stringBuilder.append('+');
                    } else {
                        stringBuilder.append('-');
                        n = -n;
                    }
                    int n2 = n / 60;
                    int n3 = n % 60;
                    DateTime.appendInt(stringBuilder, n2, 2);
                    stringBuilder.append(':');
                    DateTime.appendInt(stringBuilder, n3, 2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(arrayIndexOutOfBoundsException);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringRfc822() {
        assert (!this.dateOnly);
        SimpleDateFormat simpleDateFormat = dateTimeFormat822;
        synchronized (simpleDateFormat) {
            return dateTimeFormat822.format(this.value);
        }
    }

    public String toUiString() {
        StringBuilder stringBuilder = new StringBuilder();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        long l = this.value;
        if (this.tzShift != null) {
            l += this.tzShift.longValue() * 60000L;
        }
        gregorianCalendar.setTimeInMillis(l);
        try {
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(1), 4);
            stringBuilder.append('-');
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(2) + 1, 2);
            stringBuilder.append('-');
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(5), 2);
            if (!this.dateOnly) {
                stringBuilder.append(' ');
                DateTime.appendInt(stringBuilder, gregorianCalendar.get(11), 2);
                stringBuilder.append(':');
                DateTime.appendInt(stringBuilder, gregorianCalendar.get(12), 2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(arrayIndexOutOfBoundsException);
        }
        return stringBuilder.toString();
    }

    public static DateTime parseDateTime(String string) throws NumberFormatException {
        Matcher matcher = dateTimePattern.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException("Invalid date/time format.");
        }
        DateTime dateTime = new DateTime();
        dateTime.dateOnly = false;
        if (matcher.group(9) != null) {
            if (matcher.group(9).equalsIgnoreCase("Z")) {
                dateTime.tzShift = new Integer(0);
            } else {
                dateTime.tzShift = new Integer(Integer.valueOf(matcher.group(12)) * 60 + Integer.valueOf(matcher.group(13)));
                if (matcher.group(11).equals("-")) {
                    dateTime.tzShift = new Integer(-dateTime.tzShift.intValue());
                }
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        gregorianCalendar.set(Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(2)) - 1, Integer.valueOf(matcher.group(3)), Integer.valueOf(matcher.group(4)), Integer.valueOf(matcher.group(5)), Integer.valueOf(matcher.group(6)));
        if (matcher.group(8) != null && matcher.group(8).length() > 0) {
            BigDecimal bigDecimal = new BigDecimal("0." + matcher.group(8));
            gregorianCalendar.set(14, bigDecimal.movePointRight(3).intValue());
        }
        dateTime.value = gregorianCalendar.getTimeInMillis();
        if (dateTime.tzShift != null) {
            dateTime.value -= (long)(dateTime.tzShift * 60000);
        }
        return dateTime;
    }

    public static DateTime parseDate(String string) throws NumberFormatException {
        Matcher matcher = datePattern.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException("Invalid date format.");
        }
        DateTime dateTime = new DateTime();
        dateTime.dateOnly = true;
        if (matcher.group(4) != null) {
            if (matcher.group(4).equalsIgnoreCase("Z")) {
                dateTime.tzShift = new Integer(0);
            } else {
                dateTime.tzShift = new Integer(Integer.valueOf(matcher.group(7)) * 60 + Integer.valueOf(matcher.group(8)));
                if (matcher.group(6).equals("-")) {
                    dateTime.tzShift = new Integer(-dateTime.tzShift.intValue());
                }
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        gregorianCalendar.set(Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(2)) - 1, Integer.valueOf(matcher.group(3)));
        dateTime.value = gregorianCalendar.getTimeInMillis();
        if (dateTime.tzShift != null) {
            dateTime.value -= (long)(dateTime.tzShift * 60000);
        }
        return dateTime;
    }

    public static DateTime parseDateTimeChoice(String string) throws NumberFormatException {
        try {
            return DateTime.parseDateTime(string);
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = numberFormatException;
            try {
                return DateTime.parseDate(string);
            }
            catch (NumberFormatException numberFormatException3) {
                numberFormatException2 = numberFormatException3;
                throw numberFormatException2;
            }
        }
    }

    private static void appendInt(StringBuilder stringBuilder, int n, int n2) {
        if (n < 0) {
            stringBuilder.append('-');
            n = -n;
        }
        char[] cArray = new char[n2];
        for (int i = n2 - 1; i >= 0; --i) {
            cArray[i] = (char)(48 + n % 10);
            n /= 10;
        }
        stringBuilder.append(cArray);
    }

    static {
        dateTimeFormat822.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

