/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Content;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.util.Base64;
import com.google.gdata.util.common.util.Base64DecoderException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class OtherContent
extends Content {
    protected ContentType mimeType;
    protected String lang;
    protected XmlBlob xml;
    protected String text;
    protected byte[] bytes;

    public int getType() {
        if (this.xml != null) {
            return 5;
        }
        if (this.text != null) {
            return 4;
        }
        return 6;
    }

    public ContentType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(ContentType contentType) {
        this.mimeType = contentType;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public XmlBlob getXml() {
        return this.xml;
    }

    public void setXml(XmlBlob xmlBlob) {
        this.xml = xmlBlob;
        this.text = null;
        this.bytes = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.xml = null;
        this.text = string;
        this.bytes = null;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.xml = null;
        this.bytes = byArray;
        this.text = null;
    }

    public void generateAtom(XmlWriter xmlWriter) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(2);
        if (this.mimeType != null) {
            arrayList.add(new XmlWriter.Attribute("type", this.mimeType.getMediaType()));
        }
        if (this.xml == null) {
            String string;
            if (this.text != null) {
                string = this.text;
                if (this.lang != null) {
                    arrayList.add(new XmlWriter.Attribute("xml:lang", this.lang));
                }
            } else if (this.bytes != null) {
                string = Base64.encode(this.bytes);
                if (this.lang != null) {
                    arrayList.add(new XmlWriter.Attribute("xml:lang", this.lang));
                }
            } else {
                string = null;
            }
            xmlWriter.simpleElement(Namespaces.atomNs, "content", arrayList, string);
        } else {
            XmlBlob.startElement(xmlWriter, Namespaces.atomNs, "content", this.xml, arrayList, null);
            XmlBlob.endElement(xmlWriter, Namespaces.atomNs, "content", this.xml);
        }
    }

    public void generateRss(XmlWriter xmlWriter) throws IOException {
        if (this.getType() == 4) {
            xmlWriter.simpleElement(Namespaces.rssNs, "description", null, this.text);
        } else {
            this.generateAtom(xmlWriter);
        }
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        private final int type;

        AtomHandler(Attributes attributes) throws IOException {
            String string = attributes.getValue("", "type");
            if (string.endsWith("+xml") || string.endsWith("/xml")) {
                this.type = 5;
                OtherContent.this.xml = new XmlBlob();
                this.initializeXmlBlob(OtherContent.this.xml, true, true);
            } else {
                this.type = string.startsWith("text/") ? 4 : 6;
            }
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("") && string2.equals("type")) {
                OtherContent.this.mimeType = new ContentType(string3);
            }
        }

        public void processEndElement() throws ParseException {
            switch (this.type) {
                case 5: {
                    break;
                }
                case 4: {
                    OtherContent.this.text = this.value;
                    OtherContent.this.lang = this.xmlLang;
                    break;
                }
                case 6: {
                    if (this.value != null) {
                        try {
                            OtherContent.this.bytes = Base64.decode(this.value);
                        }
                        catch (Base64DecoderException base64DecoderException) {
                            throw new ParseException("Expected Base-64 content.");
                        }
                    }
                    OtherContent.this.lang = this.xmlLang;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }
}

