/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.HtmlTextConstruct;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.XhtmlTextConstruct;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public abstract class TextConstruct {
    protected String lang;

    public abstract int getType();

    public abstract boolean isEmpty();

    public abstract String getPlainText();

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public static TextConstruct create(int n, String string, XmlBlob xmlBlob) {
        switch (n) {
            case 1: {
                PlainTextConstruct plainTextConstruct = new PlainTextConstruct(string);
                return plainTextConstruct;
            }
            case 2: {
                HtmlTextConstruct htmlTextConstruct = new HtmlTextConstruct(string);
                return htmlTextConstruct;
            }
            case 3: {
                XhtmlTextConstruct xhtmlTextConstruct = new XhtmlTextConstruct(xmlBlob);
                return xhtmlTextConstruct;
            }
        }
        assert (false) : "Invalid type: " + String.valueOf(n);
        return null;
    }

    public abstract void generateAtom(XmlWriter var1, String var2) throws IOException;

    public abstract void generateRss(XmlWriter var1, String var2, RssFormat var3) throws IOException;

    public static ChildHandlerInfo getChildHandler(Attributes attributes) throws ParseException, IOException {
        String string = attributes.getValue("", "type");
        ChildHandlerInfo childHandlerInfo = new ChildHandlerInfo();
        if (string == null || string.equals("text") || string.equals("text/plain")) {
            PlainTextConstruct plainTextConstruct = new PlainTextConstruct();
            childHandlerInfo.handler = plainTextConstruct.new PlainTextConstruct.AtomHandler();
            childHandlerInfo.textConstruct = plainTextConstruct;
        } else if (string.equals("html") || string.equals("text/html")) {
            HtmlTextConstruct htmlTextConstruct = new HtmlTextConstruct();
            childHandlerInfo.handler = htmlTextConstruct.new HtmlTextConstruct.AtomHandler();
            childHandlerInfo.textConstruct = htmlTextConstruct;
        } else if (string.equals("xhtml")) {
            XhtmlTextConstruct xhtmlTextConstruct = new XhtmlTextConstruct();
            childHandlerInfo.handler = new XhtmlTextConstruct.AtomHandler(xhtmlTextConstruct);
            childHandlerInfo.textConstruct = xhtmlTextConstruct;
        } else {
            throw new ParseException("Invalid text content type: '" + string + "'.");
        }
        return childHandlerInfo;
    }

    public static class ChildHandlerInfo {
        public XmlParser.ElementHandler handler;
        public TextConstruct textConstruct;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RssFormat {
        PLAIN_TEXT,
        FULL_HTML;

    }

    public static class Type {
        public static final int TEXT = 1;
        public static final int HTML = 2;
        public static final int XHTML = 3;
    }
}

