/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.html.HtmlToText;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

public class XhtmlTextConstruct
extends TextConstruct {
    protected XmlBlob xhtml;

    public XhtmlTextConstruct() {
    }

    public XhtmlTextConstruct(XmlBlob xmlBlob) {
        this.xhtml = xmlBlob;
    }

    public XhtmlTextConstruct(XmlBlob xmlBlob, String string) {
        this.xhtml = xmlBlob;
        this.lang = string;
    }

    public int getType() {
        return 3;
    }

    public boolean isEmpty() {
        return this.xhtml == null;
    }

    public XmlBlob getXhtml() {
        if (this.xhtml == null) {
            this.xhtml = new XmlBlob();
        }
        return this.xhtml;
    }

    public void setXhtml(XmlBlob xmlBlob) {
        this.xhtml = xmlBlob;
    }

    public String getPlainText() {
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter);
            xmlWriter.innerXml(this.xhtml.getBlob());
            return HtmlToText.htmlToPlainText(stringWriter.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void generateAtom(XmlWriter xmlWriter, String string) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(2);
        arrayList.add(new XmlWriter.Attribute("type", "xhtml"));
        if (this.lang != null) {
            arrayList.add(new XmlWriter.Attribute("xml:lang", this.lang));
        }
        XmlBlob.startElement(xmlWriter, Namespaces.atomNs, string, this.xhtml, arrayList, null);
        XmlBlob.endElement(xmlWriter, Namespaces.atomNs, string, this.xhtml);
    }

    public void generateRss(XmlWriter xmlWriter, String string, TextConstruct.RssFormat rssFormat) throws IOException {
        switch (rssFormat) {
            case FULL_HTML: {
                StringWriter stringWriter = new StringWriter();
                XmlWriter xmlWriter2 = new XmlWriter(stringWriter);
                xmlWriter2.innerXml(this.xhtml.getBlob());
                xmlWriter.simpleElement(Namespaces.rssNs, string, null, stringWriter.toString());
                break;
            }
            case PLAIN_TEXT: {
                xmlWriter.simpleElement(Namespaces.rssNs, string, null, this.getPlainText());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        public AtomHandler() throws IOException {
            XhtmlTextConstruct.this.xhtml = new XmlBlob();
            this.initializeXmlBlob(XhtmlTextConstruct.this.xhtml, true, true);
            XhtmlTextConstruct.this.lang = this.xmlLang;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("http://www.w3.org/XML/1998/namespace") && string2.equals("lang")) {
                XhtmlTextConstruct.this.lang = this.xmlLang;
            }
        }
    }
}

