/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.CalItem;
import jp.sourceforge.concierge.plugin.labnote.CalTitle;
import jp.sourceforge.concierge.plugin.labnote.CalTitleListener;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.CategoryViewer;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDialog;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.Holiday;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;

public class LabNote
extends ConciergeViewPart {
    private LabnoteDialog dialog;
    private Composite datelist;
    private CategoryViewer category;
    private CalTitle dtitle;
    private ImageHyperlink addcatbtn;
    private ImageHyperlink delcatbtn;
    private int caldate;
    private ImageDescriptor addimg = LabNotePlugin.getImageDescriptor("icons/catplus.png");
    private ImageDescriptor delimg = LabNotePlugin.getImageDescriptor("icons/catminus.png");
    private ArrayList<CalItem> dateitems = new ArrayList();
    private Holiday holidayCache = new Holiday();
    private LabNoteMenuManager mmanager = null;
    private IPropertyChangeListener propertyChangeListener = null;

    private void setPropertyChangeListener() {
        this.removePropertyChangeListener();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.equals("lablocale")) {
                    if (event.getOldValue().equals(event.getNewValue())) {
                        return;
                    }
                    LabNote.this.refreshholiday((String)event.getNewValue());
                }
            }
        };
        LabNotePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void removePropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            LabNotePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    private void refreshholiday(String newlocale) {
        int cy = this.dtitle.getCurrentYear();
        this.holidayCache.initHolidaysByYear(cy - 5, cy + 5, newlocale);
        int i = 0;
        while (i < this.dateitems.size()) {
            int d;
            int m;
            CalItem ci;
            int y = (ci = this.dateitems.get(i)).getYear();
            ci.setHoliday(this.holidayCache.isHoliday(y, m = ci.getMonth(), d = ci.getDay()) || i % 7 == 0);
            ci.setNameOfDay(this.holidayCache.getHolidayName(y, m, d));
            ++i;
        }
    }

    private void setdateitem(int year, int month, int date) {
        ArrayList<Document> docs;
        CalItem di;
        int dofw = CalendarUtil.getDayOfWeek((int)year, (int)month, (int)1) - 1;
        int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
        int pyear = year;
        int pmonth = month - 1;
        if (pmonth == 0) {
            pyear = year - 1;
            pmonth = 12;
        }
        int nyear = year;
        int nmonth = month + 1;
        if (nmonth > 12) {
            nyear = year + 1;
            nmonth = 1;
        }
        LabNotePlugin fp = LabNotePlugin.getDefault();
        int pnofd = CalendarUtil.getNumberOfDays((int)pyear, (int)pmonth);
        int i = 0;
        int j = pnofd - dofw + 1;
        while (i < dofw) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(pyear, pmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(pyear, pmonth, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(pyear, pmonth, j));
            di.clearAll();
            docs = fp.getDocuments(pyear, pmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        i = dofw;
        j = 1;
        while (i < dofw + nofd) {
            di = this.dateitems.get(i);
            di.setDate(year, month, j);
            di.setHoliday(this.holidayCache.isHoliday(year, month, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(year, month, j));
            if (j == date) {
                di.select();
            } else {
                di.deselect();
            }
            di.clearAll();
            docs = fp.getDocuments(year, month, j);
            di.setDocuments(docs);
            di.setEnabled(true);
            ++i;
            ++j;
        }
        i = dofw + nofd;
        j = 1;
        while (i < 42) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(nyear, nmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(nyear, nmonth, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(nyear, nmonth, j));
            di.clearAll();
            docs = fp.getDocuments(nyear, nmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        this.datelist.layout();
    }

    private void resizeCalItem(Control[] calitems, Point parentsize) {
        int nw = (parentsize.x - 1) / 7;
        int nh = (parentsize.y - 1) / 6;
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 6) {
                Composite comp = (Composite)calitems[x + y * 7];
                int px = nw * x + 1;
                int py = nh * y + 1;
                int w = x == 6 ? parentsize.x - nw * 6 - 2 : nw - 1;
                int h = y == 5 ? parentsize.y - nh * 5 - 2 : nh - 1;
                comp.setBounds(px, py, w, h);
                ++y;
            }
            ++x;
        }
    }

    public LabNote() {
        this.setPropertyChangeListener();
        LabNotePlugin.getDefault().update(true);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite maincomp = new Composite(parent, 0);
        GridLayout glmn = new GridLayout(1, true);
        glmn.marginHeight = 0;
        glmn.marginWidth = 0;
        glmn.verticalSpacing = 0;
        glmn.horizontalSpacing = 0;
        maincomp.setLayout((Layout)glmn);
        maincomp.setLayoutData((Object)new GridData(1808));
        SashForm sf = new SashForm(maincomp, 65792);
        sf.setLayoutData((Object)new GridData(1808));
        sf.SASH_WIDTH = 2;
        Composite calarea = new Composite((Composite)sf, 2048);
        GridLayout glca = new GridLayout(1, true);
        glca.marginHeight = 0;
        glca.marginWidth = 0;
        glca.verticalSpacing = 0;
        glca.horizontalSpacing = 0;
        calarea.setLayout((Layout)glca);
        GraphicUtil.setBackground((Control)calarea, (int)1);
        Composite harea = new Composite(calarea, 0);
        GridLayout glha = new GridLayout(2, true);
        glha.marginHeight = 0;
        glha.marginWidth = 0;
        glha.verticalSpacing = 0;
        glha.horizontalSpacing = 0;
        harea.setLayout((Layout)glha);
        harea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)harea, (int)1);
        Label label = new Label(harea, 4);
        label.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)label, (int)1);
        label.setText(LabNotePlugin.getString("LabNote.2"));
        Composite cmdarea = new Composite(harea, 0);
        FormLayout flcma = new FormLayout();
        flcma.marginHeight = 0;
        flcma.marginWidth = 0;
        cmdarea.setLayout((Layout)flcma);
        cmdarea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)cmdarea, (int)1);
        this.delcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData dbfd = new FormData();
        dbfd.right = new FormAttachment(95, 0);
        this.delcatbtn.setLayoutData((Object)dbfd);
        GraphicUtil.setBackground((Control)this.delcatbtn, (int)1);
        this.delcatbtn.setImage(this.delimg.createImage());
        this.delcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (!LabNotePlugin.showConfirm(LabNote.this.delcatbtn.getShell(), LabNotePlugin.getString("LabNote.3"))) {
                    return;
                }
                LabNote.this.category.deleteCategory();
                LabNote.this.dialog.update();
                int i = 0;
                while (i < LabNote.this.dateitems.size()) {
                    CalItem ci = (CalItem)LabNote.this.dateitems.get(i);
                    ci.update();
                    ++i;
                }
            }
        });
        this.addcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData abfd = new FormData();
        abfd.right = new FormAttachment((Control)this.delcatbtn, -5);
        this.addcatbtn.setLayoutData((Object)abfd);
        this.addcatbtn.setImage(this.addimg.createImage());
        GraphicUtil.setBackground((Control)this.addcatbtn, (int)1);
        this.addcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabNote.this.category.addCategory();
                LabNote.this.dialog.update();
            }
        });
        LabNotePlugin fp = LabNotePlugin.getDefault();
        this.category = new CategoryViewer(calarea, fp.getCategories());
        this.category.addCheckListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Category cg = (Category)e.getElement();
                int i = 0;
                while (i < LabNote.this.dateitems.size()) {
                    CalItem ci = (CalItem)LabNote.this.dateitems.get(i);
                    ci.categoryVisible(cg.name, e.getChecked());
                    ++i;
                }
            }
        });
        Calendar cd = Calendar.getInstance();
        int calyear = cd.get(1);
        int calmonth = cd.get(2) + 1;
        this.caldate = cd.get(5);
        String locale = LabNotePlugin.getDefault().getPreferenceStore().getString("lablocale");
        this.holidayCache.initHolidaysByYear(calyear - 5, calyear + 5, locale);
        Composite darea = new Composite((Composite)sf, 2048);
        GridLayout glda = new GridLayout(1, true);
        glda.marginHeight = 10;
        glda.marginWidth = 10;
        glda.verticalSpacing = 0;
        glda.horizontalSpacing = 0;
        darea.setLayout((Layout)glda);
        GraphicUtil.setBackground((Control)darea, (int)1);
        sf.setWeights(new int[]{25, 75});
        Composite tt = new Composite(darea, 0);
        tt.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)tt, (int)1);
        this.dtitle = new CalTitle(tt, calyear, calmonth);
        this.dtitle.setListener(new CalTitleListener(){

            public void calendarChanged(int year, int month) {
                int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
                if (LabNote.this.caldate > nofd) {
                    LabNote.this.caldate = nofd;
                }
                LabNote.this.setdateitem(year, month, LabNote.this.caldate);
            }
        });
        this.datelist = new Composite(darea, 0);
        GridData dtgd = new GridData(1808);
        dtgd.minimumHeight = 240;
        dtgd.minimumWidth = 490;
        this.datelist.setLayoutData((Object)dtgd);
        GraphicUtil.setBackground((Control)this.datelist, (int)15);
        this.datelist.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Composite comp = (Composite)e.widget;
                Point r = comp.getSize();
                Control[] chld = comp.getChildren();
                LabNote.this.resizeCalItem(chld, r);
            }
        });
        this.dialog = (LabnoteDialog)LabNotePlugin.getDefault().getDialog(darea.getShell(), 1264);
        int i = 0;
        while (i < 42) {
            Composite comp = new Composite(this.datelist, 0);
            GraphicUtil.setBackground((Control)comp, (int)1);
            CalItem di = new CalItem(comp, calyear, calmonth, i, this.category, this.dialog);
            this.dateitems.add(di);
            di.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    CalItem c = (CalItem)e.data;
                    c.createItem(LabNote.this.category.getCurrentCategory());
                }

                public void mouseDown(MouseEvent e) {
                    IWorkbenchPage page;
                    IViewPart tview;
                    int i = 0;
                    while (i < 42) {
                        CalItem it = (CalItem)LabNote.this.dateitems.get(i);
                        it.deselect();
                        ++i;
                    }
                    CalItem c = (CalItem)e.data;
                    c.select();
                    Document doc = c.getSelectedDocument();
                    if (doc != null) {
                        if (e.button != 1 || (e.stateMask & 0x40000) != 0 && e.button == 1) {
                            c.showTooltip(false);
                            Control ctrl = c.getSelectedControl();
                            ((LabNote)LabNote.this).mmanager.document = doc;
                            ((LabNote)LabNote.this).mmanager.calitem = c;
                            Menu m = LabNote.this.mmanager.createContextMenu(ctrl);
                            ctrl.setMenu(m);
                        }
                        return;
                    }
                    LabNote.this.caldate = c.getDay();
                    LabNotePlugin fp = LabNotePlugin.getDefault();
                    ArrayList<Document> al = fp.getDocuments(c.getYear(), c.getMonth(), c.getDay());
                    if (al == null) {
                        al = new ArrayList();
                    }
                    if ((tview = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("jp.sourceforge.concierge.plugin.tabulator")) == null) {
                        return;
                    }
                    ((ConciergeViewPart)tview).setDocuments(al);
                }
            });
            ++i;
        }
        this.resizeCalItem(this.datelist.getChildren(), this.datelist.getSize());
        this.setdateitem(calyear, calmonth, this.caldate);
        this.hookContextMenu();
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("JP", "http://concierge.sourceforge.jp/manuals/labnote/manual_ja.pdf");
        ht.put("US", "http://concierge.sourceforge.jp/manuals/labnote/manual_en.pdf");
        ht.put("UK", "http://concierge.sourceforge.jp/manuals/labnote/manual_en.pdf");
        LabNotePlugin.getDefault().addHelp((IContributionManager)this.getViewSite().getActionBars().getToolBarManager(), ht, "JP");
    }

    private void fillContextMenu(IMenuManager manager) {
        Action openA = new Action(){

            public void run() {
                ((LabNote)LabNote.this).mmanager.calitem.openItem(((LabNote)LabNote.this).mmanager.document);
            }
        };
        openA.setText(LabNotePlugin.getString("LabNote.12"));
        Action deleteA = new Action(){

            public void run() {
                if (!MessageDialog.openConfirm((Shell)LabNote.this.datelist.getShell(), (String)LabNotePlugin.getString("LabNote.13"), (String)LabNotePlugin.getString("LabNote.14"))) {
                    return;
                }
                ((LabNote)LabNote.this).mmanager.calitem.deleteItem(((LabNote)LabNote.this).mmanager.document);
                LabNotePlugin.getDefault().deleteDocument(((LabNote)LabNote.this).mmanager.document, true, null);
            }
        };
        deleteA.setText(LabNotePlugin.getString("LabNote.15"));
        manager.add((IAction)openA);
        manager.add((IAction)deleteA);
    }

    private void hookContextMenu() {
        this.mmanager = new LabNoteMenuManager("#PopupMenu");
        this.mmanager.setRemoveAllWhenShown(true);
        this.mmanager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LabNote.this.fillContextMenu(manager);
            }
        });
    }

    public void setFocus() {
        this.datelist.setFocus();
    }

    public void Update(ArrayList reqs, Object sender) {
        LabNotePlugin fp = LabNotePlugin.getDefault();
        if (sender.equals(fp.getBundle().getSymbolicName())) {
            return;
        }
        int i = 0;
        while (i < reqs.size()) {
            Document doc;
            String type;
            Request r = (Request)reqs.get(i);
            if (r.collection.compareTo("data") == 0 && (type = DataDomImpl.getType((Document)(doc = (Document)r.data))).compareTo("Note") == 0) {
                if (r.command == 2) {
                    fp.deleteDocument(doc, false, null);
                    int j = 0;
                    while (j < this.dateitems.size()) {
                        CalItem ci = this.dateitems.get(j);
                        ci.deleteItem(doc);
                        ++j;
                    }
                    this.dialog.removeEmbeddedObjectByDocument(doc);
                } else if (r.command == 1 || r.command == 3) {
                    LabNotePlugin lnp = LabNotePlugin.getDefault();
                    lnp.addDocument(doc, false, sender);
                    int dy = LabNotePlugin.getYearOfDocument(doc);
                    int dm = LabNotePlugin.getMonthOfDocument(doc);
                    int dd = LabNotePlugin.getDayOfDocument(doc);
                    int j = 0;
                    while (j < this.dateitems.size()) {
                        CalItem ci = this.dateitems.get(j);
                        if (ci.getYear() == dy && ci.getMonth() == dm && ci.getDay() == dd) {
                            ci.updateAll();
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private class LabNoteMenuManager
    extends MenuManager {
        public Document document;
        public CalItem calitem;

        public LabNoteMenuManager(String id) {
            super(id);
            this.document = null;
            this.calitem = null;
        }
    }
}

