/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.HTMLDocumentParser;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDialog;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabNotePlugin
extends AbstractDocumentUIPlugin
implements IConciergeDialog {
    private static final String BUNDLE_NAME = "jp.sourceforge.concierge.plugin.labnote.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("jp.sourceforge.concierge.plugin.labnote.messages");
    private static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.labnote";
    private static final String FOOTPRINT_PLUGIN_ID = "jp.sourceforge.concierge.plugin.footprint";
    public static final String UNKNOWNCATEGORY = "<Unknown>";
    private static final String CATEGORYTAG = "category";
    private static final String CATCOLORID = "colorid";
    private static LabNotePlugin plugin;
    private long lastupdtime = 0L;
    private ArrayList<Document> noteTypeDocs;
    private Document configdocument;
    private Hashtable<Integer, YDocuments> ydocuments = new Hashtable();
    private ArrayList<Document> unknowns = new ArrayList();
    private Document miscfiledocument;
    private LabnoteDialog dialog;

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    private static Hashtable<String, Integer> parseDate(Document doc) {
        String val = LabNotePlugin.getString(doc, "Date", "date");
        if (val == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        try {
            Date d = df.parse(val);
            Calendar cd = Calendar.getInstance();
            cd.setTime(d);
            ht.put("year", cd.get(1));
            ht.put("month", cd.get(2) + 1);
            ht.put("day", cd.get(5));
        }
        catch (Exception exception) {
            return null;
        }
        return ht;
    }

    public static int getYearOfDocument(Document doc) {
        Hashtable<String, Integer> ht = LabNotePlugin.parseDate(doc);
        if (ht == null) {
            return -1;
        }
        return ht.get("year");
    }

    public static int getMonthOfDocument(Document doc) {
        Hashtable<String, Integer> ht = LabNotePlugin.parseDate(doc);
        if (ht == null) {
            return -1;
        }
        return ht.get("month");
    }

    public static int getDayOfDocument(Document doc) {
        Hashtable<String, Integer> ht = LabNotePlugin.parseDate(doc);
        if (ht == null) {
            return -1;
        }
        return ht.get("day");
    }

    private static String getString(Document doc, String itemname, String type) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname);
        if (elem == null) {
            return null;
        }
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)type);
        if (ip == null) {
            return null;
        }
        ITypeParser parser = ip.createInstance();
        return parser.getViewForm(elem);
    }

    private static void setString(Document doc, String itemname, String type, String val) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname);
        if (elem == null) {
            return;
        }
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)type);
        if (ip == null) {
            return;
        }
        ITypeParser parser = ip.createInstance();
        parser.addToElement(elem, val);
    }

    private ArrayList<Document> getAllDocuments() {
        ArrayList<Document> docs = new ArrayList<Document>();
        Enumeration<YDocuments> en = this.ydocuments.elements();
        while (en.hasMoreElements()) {
            YDocuments ydoc = en.nextElement();
            docs.addAll(ydoc.getAll());
        }
        docs.addAll(this.unknowns);
        return docs;
    }

    public void setDocument(Document doc) {
        int y = LabNotePlugin.getYearOfDocument(doc);
        if (y < 0) {
            if (!this.unknowns.contains(doc)) {
                this.unknowns.add(doc);
            }
            return;
        }
        YDocuments yd = this.ydocuments.get(y);
        if (yd == null) {
            yd = new YDocuments();
            this.ydocuments.put(y, yd);
        }
        yd.add(doc);
    }

    public ArrayList<Document> getDocuments(int year, int month, int day) {
        YDocuments y = this.ydocuments.get(year);
        if (y == null) {
            return null;
        }
        return y.getDocs(month, day);
    }

    public static String getTitle(Document doc) {
        return LabNotePlugin.getString(doc, "Title", "text");
    }

    public static String getCategory(Document doc) {
        return LabNotePlugin.getString(doc, "Category", "text");
    }

    public static Document getComment(Document doc) {
        Element body;
        Document html = DomImpl.createDocument((String)"html", (boolean)true);
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return null;
        }
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        ITypeParser parser = ip.createInstance();
        Element head = ((HTMLDocumentParser)parser).getHTMLNode(elem, "head");
        if (head != null) {
            html.getDocumentElement().appendChild(html.importNode(head, true));
        }
        if ((body = ((HTMLDocumentParser)parser).getHTMLNode(elem, "body")) != null) {
            html.getDocumentElement().appendChild(html.importNode(body, true));
        }
        return html;
    }

    public static String getCommentAsString(Document doc) {
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return null;
        }
        ITypeParser parser = ip.createInstance();
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        Element body = ((HTMLDocumentParser)parser).getHTMLNode(elem, "body");
        return DomImpl.getAllText((Element)body);
    }

    public static String getDate(Document doc) {
        return LabNotePlugin.getString(doc, "Date", "date");
    }

    public static String getKeywords(Document doc) {
        return LabNotePlugin.getString(doc, "Keywords", "keywords");
    }

    public static ArrayList<Document> getDocumentsByTheSameLastMod(Document doc) {
        Request req = new Request(4, (Object)"/*", "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        Calendar c = Calendar.getInstance();
        Hashtable<String, Integer> ht = LabNotePlugin.parseDate(doc);
        int year = ht.get("year");
        int month = ht.get("month");
        int day = ht.get("day");
        c.set(year, month - 1, day, 0, 0, 0);
        long minval = c.getTimeInMillis();
        long maxval = minval + 86400000L - 1L;
        String doctype = DataDomImpl.getType((Document)doc);
        ArrayList<Document> rdocs = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            Document d = (Document)docs.get(i);
            long lastmod = DomImpl.getLastModifiedTime((Document)d);
            if (lastmod >= minval && maxval >= lastmod && !DataDomImpl.getType((Document)d).equals(doctype)) {
                rdocs.add(d);
            }
            ++i;
        }
        return rdocs;
    }

    public static void setTitle(Document doc, String val) {
        LabNotePlugin.setString(doc, "Title", "text", val);
    }

    public static void setCategory(Document doc, String val) {
        LabNotePlugin.setString(doc, "Category", "text", val);
    }

    public static void setComment(Document doc, Document html) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        if (elem == null) {
            return;
        }
        NodeList head = html.getElementsByTagName("head");
        NodeList body = html.getElementsByTagName("body");
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return;
        }
        ITypeParser parser = ip.createInstance();
        if (head.getLength() > 0) {
            ((HTMLDocumentParser)parser).setHTMLNode(elem, (Element)head.item(0));
        }
        if (body.getLength() > 0) {
            ((HTMLDocumentParser)parser).setHTMLNode(elem, (Element)body.item(0));
        }
    }

    public static void setDate(Document doc, String val) {
        LabNotePlugin.setString(doc, "Date", "date", val);
    }

    public static void setKeywords(Document doc, String val) {
        LabNotePlugin.setString(doc, "Keywords", "keywords", val);
    }

    public void update(boolean chkupd) {
        if (chkupd && !FrameworkPlugin.databaseUpdatedSince((long)this.lastupdtime)) {
            return;
        }
        this.ydocuments.clear();
        this.unknowns.clear();
        this.noteTypeDocs = null;
        this.configdocument = null;
        Request req = new Request();
        req.collection = "type";
        req.command = 4;
        req.options = 0;
        req.data = "/type[@pluginid='jp.sourceforge.concierge.plugin.footprint']";
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() > 0) {
            ArrayList<Request> updreqs = new ArrayList<Request>();
            int i = 0;
            while (i < docs.size()) {
                Element e;
                boolean isUpdate = false;
                Document doc = (Document)docs.get(i);
                String version = TypeDomImpl.getVersion((Document)doc);
                if (version == null) {
                    System.out.println("Update Note Type Version *->0.0.0");
                    e = TypeDomImpl.getElement((Document)doc, (String)"Keywords");
                    if (e == null) {
                        TypeDomImpl.appendElement((Document)doc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)false, (boolean)true);
                    }
                    TypeDomImpl.setPluginID((Document)doc, (String)PLUGIN_ID);
                    TypeDomImpl.setVersion((Document)doc, (String)"0.0.0");
                    isUpdate = true;
                } else if (version.length() == 0) {
                    System.out.println("Update Note Type Version _->0.0.0");
                    e = TypeDomImpl.getElement((Document)doc, (String)"Keywords");
                    if (e == null) {
                        TypeDomImpl.appendElement((Document)doc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)false, (boolean)true);
                    }
                    TypeDomImpl.setPluginID((Document)doc, (String)PLUGIN_ID);
                    TypeDomImpl.setVersion((Document)doc, (String)"0.0.0");
                    isUpdate = true;
                }
                if (isUpdate) {
                    Request ureq = new Request();
                    ureq.collection = "type";
                    ureq.command = 3;
                    ureq.data = doc;
                    updreqs.add(ureq);
                }
                ++i;
            }
            if (updreqs.size() > 0) {
                FrameworkPlugin.updateDocuments(updreqs, (Object)this.getBundle().getSymbolicName());
            }
            this.noteTypeDocs = docs;
        } else {
            req = new Request();
            req.collection = "type";
            req.command = 4;
            req.options = 0;
            req.data = "/type[@pluginid='jp.sourceforge.concierge.plugin.labnote']";
            docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
            if (docs.size() == 0) {
                Document doc = TypeDomImpl.createDocument((String)"Note");
                TypeDomImpl.appendElement((Document)doc, (String)"Title", (String)"text", (boolean)true, (boolean)false, (boolean)true);
                TypeDomImpl.appendElement((Document)doc, (String)"Content", (String)"htmldocument", (boolean)true, (boolean)false, (boolean)false);
                TypeDomImpl.appendElement((Document)doc, (String)"Category", (String)"text", (boolean)true, (boolean)false, (boolean)true);
                TypeDomImpl.appendElement((Document)doc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)false, (boolean)true);
                TypeDomImpl.appendElement((Document)doc, (String)"Date", (String)"date", (boolean)true, (boolean)false, (boolean)false);
                String path = this.getFilePath("icons/labnote.png");
                if (path != null) {
                    TypeDomImpl.setImage((Document)doc, (String)path);
                }
                TypeDomImpl.setPluginID((Document)doc, (String)PLUGIN_ID);
                TypeDomImpl.setVersion((Document)doc, (String)"0.0.0");
                ArrayList<Request> reqs = new ArrayList<Request>();
                req = new Request();
                req.collection = "type";
                req.command = 1;
                req.data = doc;
                reqs.add(req);
                FrameworkPlugin.updateDocuments(reqs, (Object)this.getBundle().getSymbolicName());
                this.noteTypeDocs = new ArrayList();
                this.noteTypeDocs.add(doc);
            } else {
                this.noteTypeDocs = docs;
            }
        }
        req = new Request();
        req.collection = "data";
        req.command = 4;
        req.options = 0;
        String query = "/data[";
        int i = 0;
        while (i < this.noteTypeDocs.size()) {
            Document fd = this.noteTypeDocs.get(i);
            String t = TypeDomImpl.getTypeName((Document)fd);
            if (i > 0) {
                query = String.valueOf(query) + " or ";
            }
            query = String.valueOf(query) + "@name='" + t + "'";
            ++i;
        }
        req.data = String.valueOf(query) + "]";
        docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        i = 0;
        while (i < docs.size()) {
            Document ddoc = (Document)docs.get(i);
            Element e = DataDomImpl.getElement((Document)ddoc, (String)"Keywords");
            if (e == null) {
                DataDomImpl.appendElement((Document)ddoc, (String)"Keywords", null, (String)"keywords");
                DataDomImpl.addNamespace((Element)DomImpl.getRootElement((Document)ddoc), (Document)this.noteTypeDocs.get(0));
                this.updateDocument(ddoc, null);
            }
            this.setDocument(ddoc);
            ++i;
        }
        req.collection = "ccgconfig";
        req.command = 4;
        req.options = 0;
        req.data = "/ccgconfig[@name='Note']";
        docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() == 0) {
            Document doc = DomImpl.createDocument((String)"ccgconfig", (boolean)true);
            Element docnode = DomImpl.getRootElement((Document)doc);
            DomImpl.setAttribute((Element)docnode, (String)"name", (String)"Note");
            Element celem = DomImpl.appendElement((Element)docnode, (String)"Category");
            Element unknown = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)unknown, (String)UNKNOWNCATEGORY);
            ArrayList<Request> reqs = new ArrayList<Request>();
            req = new Request();
            req.collection = "ccgconfig";
            req.command = 1;
            req.data = doc;
            reqs.add(req);
            FrameworkPlugin.updateDocuments(reqs, (Object)this.getBundle().getSymbolicName());
            this.configdocument = doc;
        } else {
            this.configdocument = (Document)docs.get(0);
        }
        this.lastupdtime = System.currentTimeMillis();
    }

    public LabNotePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.update(false);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static LabNotePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return LabNotePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Document createDocument() {
        Document doc = DataDomImpl.createDocument((Document)LabNotePlugin.plugin.noteTypeDocs.get(0));
        return doc;
    }

    public void updateDocumentsUpdatingCategory(String oldcat, String newcat) {
        ITypeParser parser = FrameworkPlugin.getParserPlugin((String)"text").createInstance();
        ArrayList<Document> docs = this.getAllDocuments();
        int i = 0;
        while (i < docs.size()) {
            Document doc = docs.get(i);
            Element catelem = DataDomImpl.getElement((Document)doc, (String)"Category");
            String cat = parser.getViewForm(catelem);
            if (cat.compareTo(oldcat) == 0) {
                parser.addToElement(catelem, newcat);
                this.updateDocument(doc, null);
            }
            ++i;
        }
    }

    public void updateDocumentsDeletingCategory(String category) {
        this.updateDocumentsUpdatingCategory(category, UNKNOWNCATEGORY);
    }

    public void updateCategories(ArrayList newcats) {
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.configdocument), (String)"Category");
        Element celem = (Element)celems.get(0);
        DomImpl.removeChildElements((Element)celem);
        int i = 0;
        while (i < newcats.size()) {
            Category c = (Category)newcats.get(i);
            Element newelem = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)newelem, (String)c.name);
            DomImpl.setAttribute((Element)newelem, (String)CATCOLORID, (String)String.valueOf(c.colorid));
            ++i;
        }
        this.sendDocumentRequest(this.configdocument, "ccgconfig", 3, null);
    }

    public ArrayList<Category> getCategories() {
        ArrayList<Category> l = new ArrayList<Category>();
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.configdocument), (String)"Category");
        Element celem = (Element)celems.get(0);
        ArrayList cel = DomImpl.getElements((Element)celem, (String)CATEGORYTAG);
        int i = 0;
        while (i < cel.size()) {
            Element e = (Element)cel.get(i);
            String name = DomImpl.getElementText((Element)e);
            String idstr = DomImpl.getAttribute((Element)e, (String)CATCOLORID);
            if (name.compareTo(UNKNOWNCATEGORY) != 0) {
                int cid = idstr.length() > 0 ? Integer.parseInt(DomImpl.getAttribute((Element)e, (String)CATCOLORID)) : -1;
                l.add(new Category(name, cid));
            }
            ++i;
        }
        return l;
    }

    private void sendDocumentRequest(Document doc, String col, int type, Object sender) {
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request();
        req.collection = col;
        req.command = type;
        req.data = doc;
        reqs.add(req);
        if (sender == null) {
            sender = this.getBundle().getSymbolicName();
        }
        FrameworkPlugin.updateDocuments(reqs, (Object)sender);
    }

    public void addDocument(Document doc, boolean dbupdate, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        this.setDocument(doc);
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 1, sender);
        }
    }

    public void updateDocument(Document doc, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        this.setDocument(doc);
        this.sendDocumentRequest(doc, "data", 3, sender);
    }

    public void deleteDocument(Document doc, boolean dbupdate, Object sender) {
        int y;
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        if ((y = LabNotePlugin.getYearOfDocument(doc)) < 0) {
            this.unknowns.remove(doc);
        } else {
            YDocuments ydocs = this.ydocuments.get(y);
            if (ydocs != null) {
                ydocs.remove(doc);
            }
        }
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 2, sender);
        }
    }

    public static void setLocalConfiguration(String key, String val) {
        plugin.getPreferenceStore().setValue(key, val);
    }

    public static String getLocalConfiguration(String key) {
        return plugin.getPreferenceStore().getString(key);
    }

    public static void showMessage(Shell parent, String message) {
        MessageDialog.openInformation((Shell)parent, (String)"LabNote", (String)message);
    }

    public static boolean showConfirm(Shell parent, String message) {
        return MessageDialog.openConfirm((Shell)parent, (String)"LabNote", (String)message);
    }

    public ConciergeDialog getDialog(Shell shell, int style) {
        if (this.dialog == null) {
            this.dialog = new LabnoteDialog(shell, 1136);
        }
        return this.dialog;
    }

    public static Document createMiscFileDocument(String filename) {
        Document tdoc = LabNotePlugin.getMiscFileTypeDocument();
        ITypeParser parser = FrameworkPlugin.getParserPlugin((String)"text").createInstance();
        Document mdoc = DataDomImpl.createDocument((Document)tdoc);
        Element titleelem = DataDomImpl.getElement((Document)mdoc, (String)"Title");
        parser.addToElement(titleelem, FilenameUtils.getName((String)filename));
        DataDomImpl.setFilePath((Document)mdoc, (String)filename);
        return mdoc;
    }

    public static Document getMiscDocument(String filename) {
        long id = Long.parseLong(FilenameUtils.getBaseName((String)filename));
        return FrameworkPlugin.getDocumentByID((String)"data", (long)id);
    }

    public static Document getMiscFileTypeDocument() {
        if (LabNotePlugin.plugin.miscfiledocument == null) {
            String xpath = "/type[@pluginid='jp.sourceforge.concierge.plugin.miscfile']";
            Request rq = new Request(4, (Object)xpath, "type");
            ArrayList types = FrameworkPlugin.getDocumentsOfQuery((Request)rq);
            if (types.size() == 0) {
                return null;
            }
            LabNotePlugin.plugin.miscfiledocument = (Document)types.get(0);
        }
        return LabNotePlugin.plugin.miscfiledocument;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MDocuments {
        private ArrayList<ArrayList<Document>> documents = new ArrayList();

        ArrayList<Document> getDocsByDoc(Document doc) {
            int d = LabNotePlugin.getDayOfDocument(doc);
            return this.documents.get(d - 1);
        }

        public MDocuments() {
            int i = 0;
            while (i < 31) {
                this.documents.add(new ArrayList());
                ++i;
            }
        }

        public void add(Document doc) {
            ArrayList<Document> docs = this.getDocsByDoc(doc);
            if (!docs.contains(doc)) {
                docs.add(doc);
            }
        }

        public void remove(Document doc) {
            this.getDocsByDoc(doc).remove(doc);
        }

        public ArrayList<Document> getDocsByDay(int day) {
            return this.documents.get(day - 1);
        }

        ArrayList<Document> getAll() {
            ArrayList<Document> docs = new ArrayList<Document>();
            int i = 0;
            while (i < this.documents.size()) {
                ArrayList<Document> ds = this.documents.get(i);
                docs.addAll(ds);
                ++i;
            }
            return docs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YDocuments {
        private ArrayList<MDocuments> mdocuments = new ArrayList();

        private MDocuments getDocsByDoc(Document doc) {
            int m = LabNotePlugin.getMonthOfDocument(doc);
            return this.mdocuments.get(m - 1);
        }

        public YDocuments() {
            int i = 0;
            while (i < 12) {
                this.mdocuments.add(new MDocuments());
                ++i;
            }
        }

        public void add(Document doc) {
            this.getDocsByDoc(doc).add(doc);
        }

        public void remove(Document doc) {
            this.getDocsByDoc(doc).remove(doc);
        }

        public ArrayList<Document> getDocs(int m, int d) {
            return this.mdocuments.get(m - 1).getDocsByDay(d);
        }

        public ArrayList<Document> getAll() {
            ArrayList<Document> docs = new ArrayList<Document>();
            int i = 0;
            while (i < this.mdocuments.size()) {
                docs.addAll(this.mdocuments.get(i).getAll());
                ++i;
            }
            return docs;
        }

        public void clear() {
            this.mdocuments.clear();
        }
    }
}

