/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryViewer {
    private static ArrayList<Image> flags = new ArrayList();
    private static ArrayList<Color> colors = new ArrayList();
    private static Font font;
    private static int colorcounter;
    private static Image defimage;
    public static Category UNKNOWN;
    private CheckboxTableViewer tableview;
    private ArrayList<Category> categories = new ArrayList();
    private CategoryCellModifier cellmod;

    static {
        colorcounter = 0;
        defimage = LabNotePlugin.getImageDescriptor("icons/flag-bk.png").createImage();
        UNKNOWN = new Category("<Unknown>", -1);
        colors.add(new Color(null, 230, 77, 70));
        colors.add(new Color(null, 110, 47, 109));
        colors.add(new Color(null, 18, 135, 111));
        colors.add(new Color(null, 24, 49, 89));
        colors.add(new Color(null, 242, 180, 19));
        colors.add(new Color(null, 67, 21, 10));
        int sz = SystemUtil.GetOSType() == 1 ? 12 : 8;
        font = new Font(null, "Arial", sz, 1);
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-syu.png").createImage());
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-edom.png").createImage());
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-aotake.png").createImage());
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-ai.png").createImage());
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-yamabuki.png").createImage());
        flags.add(LabNotePlugin.getImageDescriptor("icons/flag-kuri.png").createImage());
    }

    public static Color getColor(int colorid) {
        return colorid >= 0 ? colors.get(colorid) : null;
    }

    public static Image getImage(int colorid) {
        return colorid >= 0 ? flags.get(colorid) : defimage;
    }

    protected void finalize() throws Throwable {
        int i = 0;
        while (i < colors.size()) {
            colors.get(i).dispose();
            ++i;
        }
        font.dispose();
        super.finalize();
    }

    private void updateData() {
        LabNotePlugin fp = LabNotePlugin.getDefault();
        fp.updateCategories(this.categories);
    }

    private void refresh() {
        this.tableview.refresh();
        this.tableview.getTable().getColumn(0).pack();
    }

    public CategoryViewer(Composite parent, ArrayList<Category> cats) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(parent, 2048);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        comp.setLayout((Layout)gl);
        Table table = new Table(comp, 67616);
        this.tableview = new CheckboxTableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        col.setMoveable(false);
        this.tableview.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table)});
        this.tableview.setColumnProperties(new String[]{LabNotePlugin.getString("CategoryViewer.16")});
        this.tableview.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.cellmod = new CategoryCellModifier((TableViewer)this.tableview);
        this.tableview.setCellModifier((ICellModifier)this.cellmod);
        this.tableview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection s = (IStructuredSelection)e.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                CellEditor[] eds = CategoryViewer.this.tableview.getCellEditors();
                if (eds.length == 0) {
                    return;
                }
                Category cat = (Category)s.getFirstElement();
                Color c = (Color)colors.get(cat.colorid);
                eds[0].getControl().setForeground(c);
            }
        });
        int i = 0;
        while (i < cats.size()) {
            Category c = cats.get(i);
            if (c.colorid < 0) {
                c.colorid = i % colors.size();
            }
            this.categories.add(c);
            ++i;
        }
        colorcounter = cats.size();
        this.tableview.setInput(this.categories);
        this.tableview.setAllChecked(true);
        this.tableview.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new CategoryDragAdapter());
        this.tableview.addDropSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new CategoryDropListener());
        this.refresh();
    }

    public void addCategory() {
        this.tableview.setCellModifier(null);
        String name = "";
        int i = 0;
        while (true) {
            name = String.valueOf(LabNotePlugin.getString("CategoryViewer.15")) + String.valueOf(i);
            boolean find = false;
            int j = 0;
            while (j < this.categories.size()) {
                if (this.categories.get((int)j).name.compareTo(name) == 0) {
                    find = true;
                    break;
                }
                ++j;
            }
            if (!find) break;
            ++i;
        }
        Category cat = new Category(name, colorcounter % flags.size());
        this.categories.add(cat);
        ++colorcounter;
        this.refresh();
        this.updateData();
        this.tableview.setChecked((Object)cat, true);
        this.tableview.setCellModifier((ICellModifier)this.cellmod);
    }

    public void deleteCategory() {
        IStructuredSelection sel = (IStructuredSelection)this.tableview.getSelection();
        if (sel == null) {
            return;
        }
        this.tableview.setCellModifier(null);
        Category c = (Category)sel.getFirstElement();
        this.categories.remove(c);
        LabNotePlugin fp = LabNotePlugin.getDefault();
        fp.updateDocumentsDeletingCategory(c.name);
        this.refresh();
        this.updateData();
        this.tableview.setCellModifier((ICellModifier)this.cellmod);
    }

    public Category getCategory(String name) {
        int i = 0;
        while (i < this.categories.size()) {
            Category c = this.categories.get(i);
            if (c.name.compareTo(name) == 0) {
                return c;
            }
            ++i;
        }
        return UNKNOWN;
    }

    public void addCheckListener(ICheckStateListener listener) {
        this.tableview.addCheckStateListener(listener);
    }

    public Category getCurrentCategory() {
        IStructuredSelection s = (IStructuredSelection)this.tableview.getSelection();
        if (s.isEmpty()) {
            return null;
        }
        return (Category)s.getFirstElement();
    }

    private class CategoryDragAdapter
    extends DragSourceAdapter {
        IStructuredSelection selection = null;

        private CategoryDragAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.selection);
        }

        public void dragStart(DragSourceEvent e) {
            this.selection = (IStructuredSelection)CategoryViewer.this.tableview.getSelection();
            if (this.selection.size() != 1) {
                this.selection = null;
                e.doit = false;
                return;
            }
            e.doit = true;
        }

        public void dragFinished(DragSourceEvent e) {
        }
    }

    private class CategoryDropListener
    extends DropTargetAdapter {
        private CategoryDropListener() {
        }

        public void dragEnter(DropTargetEvent e) {
            e.detail = 2;
        }

        public void drop(DropTargetEvent e) {
            Category oldc = (Category)((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).getFirstElement();
            Category newc = (Category)((TableItem)e.item).getData();
            ArrayList list = (ArrayList)CategoryViewer.this.tableview.getInput();
            int nidx = list.indexOf(newc);
            list.remove(oldc);
            list.add(nidx, oldc);
            CategoryViewer.this.tableview.refresh();
            CategoryViewer.this.updateData();
        }
    }

    private class CategoryCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public CategoryCellModifier(TableViewer tv) {
            this.viewer = tv;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return property.equals(LabNotePlugin.getString("CategoryViewer.9")) ? ((Category)element).name : null;
        }

        public void modify(Object element, String property, Object value) {
            if (((String)value).trim().length() == 0) {
                LabNotePlugin.showMessage(this.viewer.getTable().getShell(), LabNotePlugin.getString("CategoryViewer.10"));
                return;
            }
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            Category c = (Category)element;
            int i = 0;
            while (i < CategoryViewer.this.categories.size()) {
                Category ac = (Category)CategoryViewer.this.categories.get(i);
                if (!c.equals(ac) && ((String)value).compareTo(ac.name) == 0) {
                    LabNotePlugin.showMessage(this.viewer.getTable().getShell(), LabNotePlugin.getString("CategoryViewer.7"));
                    return;
                }
                ++i;
            }
            String oldcat = c.name;
            String newcat = (String)value;
            if (property.compareTo(LabNotePlugin.getString("CategoryViewer.12")) == 0) {
                if (c.name.compareTo((String)value) == 0) {
                    return;
                }
                c.name = (String)value;
            }
            this.viewer.refresh();
            this.viewer.getTable().getColumn(0).pack();
            LabNotePlugin fp = LabNotePlugin.getDefault();
            fp.updateDocumentsUpdatingCategory(oldcat, newcat);
            CategoryViewer.this.updateData();
        }
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    IColorProvider {
        private CategoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? ((Category)element).name : null;
        }

        public Color getForeground(Object element) {
            return (Color)colors.get(((Category)element).colorid);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            return font;
        }
    }
}

