/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.dialog;

import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.dialog.FileTypeUtils;
import jp.sourceforge.concierge.util.DomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedFile
extends EmbeddedObject {
    private Image objimage = null;
    private String filename = null;

    private void disposeImage() {
        if (this.objimage != null && !this.objimage.isDisposed() && this.filename != null && FileTypeUtils.isImage(this.filename)) {
            this.objimage.dispose();
        }
    }

    private void initByFile(String file) {
        this.filename = file;
        this.objimage = this.filename != null && FileTypeUtils.isImage(this.filename) ? new Image((Device)PlatformUI.getWorkbench().getDisplay(), this.filename) : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        Rectangle r = this.objimage.getBounds();
        this.size = new Point(r.width, r.height);
    }

    private Element createA(Document doc, String file, long id) {
        Element e = doc.createElement("a");
        e.setAttribute("href", FilenameUtils.getName((String)file));
        e.setAttribute("alt", String.valueOf(id));
        Element ie = this.createIMG(doc, "__object.gif", id);
        e.appendChild(ie);
        return e;
    }

    private Element createIMG(Document doc, String file, long id) {
        Element e = doc.createElement("img");
        e.setAttribute("src", FilenameUtils.getName((String)file));
        e.setAttribute("alt", String.valueOf(id));
        e.setAttribute("width", String.valueOf(this.size.x));
        e.setAttribute("height", String.valueOf(this.size.y));
        return e;
    }

    public EmbeddedFile(Document doc, boolean update) {
        this.document = doc;
        this.initByFile(FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc)));
        this.needupdate = update;
    }

    public EmbeddedFile(String newfile, boolean update) {
        this.document = LabNotePlugin.getMiscDocument(newfile);
        this.initByFile(newfile);
        this.needupdate = update;
    }

    public Image getObjectImage() {
        return this.objimage;
    }

    public void setFile(String newfile) {
        this.disposeImage();
        this.initByFile(newfile);
        if (newfile != null) {
            this.needupdate = true;
        }
    }

    public String getFile() {
        return this.filename;
    }

    public void setSize(Point sz) {
        if (sz != null && this.filename != null && FileTypeUtils.isImage(this.filename)) {
            this.size = sz;
        }
    }

    public Point getSize() {
        return this.size;
    }

    public Element createElement(Document doc, boolean fileexport) {
        if (this.needupdate) {
            this.save();
        }
        Element e = null;
        long id = DomImpl.getID((Document)this.document);
        String newfile = FrameworkPlugin.getPathFromID((long)id);
        e = this.filename != null && FileTypeUtils.isImage(this.filename) ? this.createIMG(doc, newfile, id) : this.createA(doc, newfile, id);
        return e;
    }

    public void refresh() {
        String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)this.document));
        if (path == null || this.filename == null) {
            this.disposeImage();
            this.initByFile(path);
            return;
        }
        try {
            Point sz = this.size;
            this.disposeImage();
            this.initByFile(path);
            if (sz != null && FileTypeUtils.isImage(path)) {
                this.size = sz;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean resizable() {
        return this.filename != null && FileTypeUtils.isImage(this.filename);
    }

    public boolean editable() {
        return true;
    }

    public boolean save() {
        if (!this.needupdate) {
            return false;
        }
        if (this.filename == null) {
            FrameworkPlugin.deleteUserFile((long)DomImpl.getID((Document)this.document));
            return true;
        }
        FrameworkPlugin.importUserFile((String)this.filename, (long)DomImpl.getID((Document)this.document));
        this.needupdate = false;
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.objimage != null && !this.objimage.isDisposed() && FileTypeUtils.isImage(this.filename)) {
            this.objimage.dispose();
        }
        super.finalize();
    }
}

