/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.dialog;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.dialog.ConciergeEditor;
import jp.sourceforge.concierge.plugin.labnote.dialog.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDialogListener;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDrawer;
import jp.sourceforge.concierge.plugin.labnote.dialog.StyleModifyListener;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.FileLauncher;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabnoteDialog
extends ConciergeDialog {
    Label datelabel;
    Label datevalue;
    Label titlelabel;
    Text titlevalue;
    Label kwdlabel;
    Text kwdvalue;
    Label catlabel;
    Combo catvalue;
    ConciergeEditor commentvalue;
    Document document;
    LabnoteDrawer drawer;
    Object sender;
    LabnoteDialogListener labnoteDialogListener;
    SelectionAdapter catseladapter;
    ModifyListener editormodlistener;
    ModifyListener titlemodlistener;
    ModifyListener keywordslistener;
    StyleModifyListener stylemodlistener;
    static final int ID_EXPORT = 200;
    static final String defaultTitle = "untitled";
    boolean isclosed = true;
    boolean ismodified = false;
    boolean issaved = false;
    boolean isrejected = false;

    private ArrayList<DataHeaderValue> makeValueTable() {
        ArrayList<DataHeaderValue> l = new ArrayList<DataHeaderValue>();
        String dt = this.getShell().getText();
        if (dt.charAt(0) == '*') {
            dt = dt.substring(1);
        }
        l.add(new DataHeaderValue(LabNotePlugin.getString("LabnoteDialog.2"), dt));
        l.add(new DataHeaderValue(this.catlabel.getText(), this.catvalue.getText()));
        l.add(new DataHeaderValue(this.titlelabel.getText(), this.titlevalue.getText()));
        l.add(new DataHeaderValue(this.kwdlabel.getText(), this.kwdvalue.getText()));
        return l;
    }

    private void modifyListenerEnabled(boolean en) {
        if (en) {
            this.catvalue.addSelectionListener((SelectionListener)this.catseladapter);
            this.titlevalue.addModifyListener(this.titlemodlistener);
            this.kwdvalue.addModifyListener(this.keywordslistener);
            this.commentvalue.getTextWidget().addModifyListener(this.editormodlistener);
            this.commentvalue.setStyleModifyListener(this.stylemodlistener);
        } else {
            this.catvalue.removeSelectionListener((SelectionListener)this.catseladapter);
            this.titlevalue.removeModifyListener(this.titlemodlistener);
            this.kwdvalue.removeModifyListener(this.keywordslistener);
            this.commentvalue.getTextWidget().removeModifyListener(this.editormodlistener);
            this.commentvalue.setStyleModifyListener(null);
        }
    }

    public LabnoteDialog(Shell parent, int style) {
        super(new Shell(parent), style);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        ITypeParser p;
        ITypeParser p2;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(parent, 0);
        GridLayout cgl = new GridLayout(1, false);
        cgl.marginWidth = 0;
        cgl.marginHeight = 0;
        cgl.verticalSpacing = 1;
        comp.setLayout((Layout)cgl);
        comp.setLayoutData((Object)new GridData(1808));
        Composite header = new Composite(comp, 0);
        header.setLayout((Layout)new FormLayout());
        header.setLayoutData((Object)new GridData(768));
        MouseTrackListener tooltipMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                Control cont = (Control)e.getSource();
                ToolTip tooltip = (ToolTip)cont.getData("ToolTip");
                Point p = cont.getSize();
                tooltip.setLocation(cont.toDisplay(p.x, p.y));
                tooltip.setVisible(true);
            }

            public void mouseExit(MouseEvent e) {
                Control cont = (Control)e.getSource();
                ToolTip tooltip = (ToolTip)cont.getData("ToolTip");
                tooltip.setVisible(false);
            }

            public void mouseHover(MouseEvent e) {
            }
        };
        FormData fd = null;
        ImageHyperlink savelink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        savelink.setLayoutData((Object)fd);
        savelink.setImage(LabNotePlugin.getImageDescriptor("icons/s.png").createImage());
        savelink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabnoteDialog.this.modifyListenerEnabled(false);
                LabnoteDialog.this.setDialogTitle(false);
                LabnoteDialog.this.setValuesToDocument();
                LabnoteDialog.this.saveDocument();
                if (LabnoteDialog.this.labnoteDialogListener != null && LabnoteDialog.this.document != null) {
                    LabnoteDialog.this.labnoteDialogListener.saveClicked(LabnoteDialog.this.document);
                }
                LabnoteDialog.this.ismodified = false;
                LabnoteDialog.this.modifyListenerEnabled(true);
            }
        });
        ToolTip tooltip = new ToolTip(savelink.getShell(), 2);
        savelink.setData("ToolTip", (Object)tooltip);
        tooltip.setMessage(LabNotePlugin.getString("LabnoteDialog.6"));
        savelink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink exportlink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)savelink, 5);
        exportlink.setLayoutData((Object)fd);
        exportlink.setImage(LabNotePlugin.getImageDescriptor("icons/e.png").createImage());
        exportlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabnoteDialog.this.modifyListenerEnabled(false);
                LabnoteDialog.this.commentvalue.exportToHtml(LabnoteDialog.this.makeValueTable(), LabNotePlugin.getDate(LabnoteDialog.this.document));
                LabnoteDialog.this.modifyListenerEnabled(true);
            }
        });
        ToolTip tooltip2 = new ToolTip(exportlink.getShell(), 2);
        exportlink.setData("ToolTip", (Object)tooltip2);
        tooltip2.setMessage(LabNotePlugin.getString("LabnoteDialog.9"));
        exportlink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink browserlink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)exportlink, 5);
        browserlink.setLayoutData((Object)fd);
        browserlink.setImage(LabNotePlugin.getImageDescriptor("icons/b.png").createImage());
        browserlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    String tempDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + ".temp";
                    File tempFolder = new File(tempDirName);
                    if (!tempFolder.exists()) {
                        tempFolder.mkdir();
                    } else {
                        long total = 0L;
                        File[] files = tempFolder.listFiles();
                        int i = 0;
                        while (i < files.length) {
                            total += files[i].length();
                            ++i;
                        }
                        if (total >= 0xA00000L) {
                            i = 0;
                            while (i < files.length) {
                                files[i].delete();
                                ++i;
                            }
                        }
                    }
                    long id = DomImpl.getID((Document)LabnoteDialog.this.document);
                    String htmlFileName = String.valueOf(tempDirName) + System.getProperty("file.separator") + String.valueOf(id) + ".html";
                    LabnoteDialog.this.modifyListenerEnabled(false);
                    LabnoteDialog.this.commentvalue.exportToHtml(htmlFileName, LabnoteDialog.this.makeValueTable());
                    LabnoteDialog.this.modifyListenerEnabled(true);
                    FileLauncher.LaunchFile((File)new File(htmlFileName));
                }
                catch (Exception excp) {
                    System.err.println(excp.getMessage());
                }
            }
        });
        ToolTip tooltip3 = new ToolTip(browserlink.getShell(), 2);
        browserlink.setData("ToolTip", (Object)tooltip3);
        tooltip3.setMessage(LabNotePlugin.getString("LabnoteDialog.16"));
        browserlink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink preferencelink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)browserlink, 5);
        preferencelink.setLayoutData((Object)fd);
        preferencelink.setImage(LabNotePlugin.getImageDescriptor("icons/p.png").createImage());
        preferencelink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"jp.sourceforge.concierge.plugin.labnote.preferences.LabNotePreferencePage", null, null);
                dialog.open();
            }
        });
        ToolTip tooltip4 = new ToolTip(preferencelink.getShell(), 2);
        preferencelink.setData("ToolTip", (Object)tooltip4);
        tooltip4.setMessage(LabNotePlugin.getString("LabnoteDialog.20"));
        preferencelink.addMouseTrackListener(tooltipMouseTrackListener);
        Label seplatorLabel = new Label(comp, 258);
        seplatorLabel.setLayoutData((Object)new GridData(768));
        Composite headgrp = new Composite(comp, 0);
        headgrp.setLayout((Layout)new GridLayout(2, false));
        GridData hggd = new GridData(768);
        headgrp.setLayoutData((Object)hggd);
        this.catlabel = new Label(headgrp, 131072);
        this.catlabel.setLayoutData((Object)new GridData(0));
        this.catlabel.setText(LabNotePlugin.getString("LabnoteDialog.3"));
        this.catvalue = new Combo(headgrp, 8);
        this.catvalue.setLayoutData((Object)new GridData(768));
        IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)"text");
        if (pp != null) {
            // empty if block
        }
        this.catseladapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabnoteDialog.this.ismodified = true;
                LabnoteDialog.this.setDialogTitle(true);
            }
        };
        this.titlelabel = new Label(headgrp, 131072);
        this.titlelabel.setLayoutData((Object)new GridData(0));
        this.titlelabel.setText(LabNotePlugin.getString("LabnoteDialog.5"));
        this.titlevalue = new Text(headgrp, 2052);
        this.titlevalue.setLayoutData((Object)new GridData(768));
        pp = FrameworkPlugin.getParserPlugin((String)"text");
        if (pp != null) {
            // empty if block
        }
        this.titlemodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabnoteDialog.this.ismodified = true;
                LabnoteDialog.this.setDialogTitle(true);
            }
        };
        this.kwdlabel = new Label(headgrp, 131072);
        this.kwdlabel.setLayoutData((Object)new GridData(0));
        this.kwdlabel.setText(LabNotePlugin.getString("LabnoteDialog.4"));
        this.kwdvalue = new Text(headgrp, 2052);
        this.kwdvalue.setLayoutData((Object)new GridData(768));
        pp = FrameworkPlugin.getParserPlugin((String)"keywords");
        if (pp != null && (p2 = pp.createInstance()) != null) {
            this.kwdvalue.setToolTipText(p2.getMessage());
        }
        this.keywordslistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabnoteDialog.this.ismodified = true;
                LabnoteDialog.this.setDialogTitle(true);
            }
        };
        LabNotePlugin fp = LabNotePlugin.getDefault();
        ArrayList<Category> l = fp.getCategories();
        this.catvalue.add("<Unknown>");
        int i = 0;
        while (i < l.size()) {
            this.catvalue.add(l.get((int)i).name);
            ++i;
        }
        if (this.catvalue.getItemCount() > 0) {
            this.catvalue.select(0);
        }
        this.catvalue.pack();
        this.commentvalue = new ConciergeEditor(comp, 0);
        GridData cmgd = new GridData(1808);
        this.commentvalue.setLayoutData(cmgd);
        IParserPlugin pp2 = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (pp2 != null && (p = pp2.createInstance()) != null) {
            this.commentvalue.setToolTipText(p.getMessage());
        }
        this.commentvalue.setSender(this.sender);
        this.editormodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabnoteDialog.this.ismodified = true;
                LabnoteDialog.this.setDialogTitle(true);
            }
        };
        this.stylemodlistener = new StyleModifyListener(){

            public void modifyStyle() {
                LabnoteDialog.this.ismodified = true;
                LabnoteDialog.this.setDialogTitle(true);
            }
        };
        this.modifyListenerEnabled(true);
        this.drawer = new LabnoteDrawer(this.getShell(), 200);
        if (this.document != null) {
            try {
                this.update();
            }
            catch (Exception exception) {}
        }
        return comp;
    }

    protected void setDialogTitle(boolean modified) {
        String dateString = LabNotePlugin.getDate(this.document);
        if (dateString == null) {
            dateString = "";
        }
        if (dateString != null) {
            String dialogTitle = dateString;
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date date = df.parse(dateString);
                if (date != null) {
                    dialogTitle = CalendarUtil.getDateString((Date)date);
                }
            }
            catch (Exception exception) {}
            if (modified) {
                this.getShell().setText("*" + dialogTitle);
            } else {
                this.getShell().setText(dialogTitle);
            }
        }
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 640);
        this.titlevalue.setFocus();
    }

    protected void handleShellCloseEvent() {
        if (this.ismodified && MessageDialog.openQuestion((Shell)this.getShell(), (String)LabNotePlugin.getString("LabnoteDialog.31"), (String)LabNotePlugin.getString("LabnoteDialog.32"))) {
            this.setValuesToDocument();
            this.saveDocument();
        }
        this.commentvalue.removePropertyChangeListener();
        this.setReturnCode(this.issaved ? 0 : 1);
        if (this.labnoteDialogListener != null && this.document != null) {
            this.labnoteDialogListener.closeClicked(this.document);
        }
        this.document = null;
        this.isclosed = true;
        super.close();
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void updateEmbeddedObjects(ArrayList objs) {
        int i = 0;
        while (i < objs.size()) {
            EmbeddedObject eo = (EmbeddedObject)objs.get(i);
            Document mdoc = eo.getDocument();
            if (eo.save()) {
                LabNotePlugin.getDefault().updateDocument(mdoc, this.sender);
            }
            ++i;
        }
    }

    private void setValuesToDocument() {
        if (this.document == null) {
            return;
        }
        String value = this.titlevalue.getText();
        if (value.length() == 0) {
            value = defaultTitle;
        }
        LabNotePlugin.setTitle(this.document, value);
        LabNotePlugin.setComment(this.document, this.commentvalue.getDocument());
        LabNotePlugin.setCategory(this.document, this.catvalue.getText());
        LabNotePlugin.setKeywords(this.document, this.kwdvalue.getText());
    }

    private void saveDocument() {
        LabNotePlugin fp = LabNotePlugin.getDefault();
        fp.updateDocument(this.document, this.sender);
        ArrayList list = this.commentvalue.getEmbeddedObject();
        if (list != null) {
            this.updateEmbeddedObjects(list);
        }
        this.issaved = true;
    }

    protected void buttonPressed(int buttonId) {
        this.modifyListenerEnabled(false);
        if (buttonId == 0) {
            this.setDialogTitle(false);
            this.setValuesToDocument();
            this.saveDocument();
            if (this.labnoteDialogListener != null && this.document != null) {
                this.labnoteDialogListener.saveClicked(this.document);
            }
            this.ismodified = false;
        } else {
            if (buttonId == 12) {
                if (this.ismodified && !MessageDialog.openQuestion((Shell)this.getShell(), (String)LabNotePlugin.getString("LabnoteDialog.33"), (String)LabNotePlugin.getString("LabnoteDialog.34"))) {
                    this.setReturnCode(this.issaved ? 0 : 1);
                    this.isclosed = true;
                    this.document = null;
                    super.close();
                    return;
                }
                this.setValuesToDocument();
                this.saveDocument();
                if (this.labnoteDialogListener != null && this.document != null) {
                    this.labnoteDialogListener.closeClicked(this.document);
                }
                this.setReturnCode(0);
                this.isclosed = true;
                this.document = null;
                FrameworkPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().setFocus();
                super.close();
                return;
            }
            if (buttonId == 200) {
                this.commentvalue.exportToHtml(null, LabNotePlugin.getDate(this.document));
            }
        }
        this.modifyListenerEnabled(true);
    }

    public int open() {
        if (this.isrejected) {
            MessageDialog.openWarning((Shell)LabNotePlugin.getDefault().getWorkbench().getDisplay().getActiveShell(), (String)LabNotePlugin.getString("LabnoteDialog.35"), (String)LabNotePlugin.getString("LabnoteDialog.36"));
            this.isrejected = false;
            return -1;
        }
        if (!this.isclosed) {
            return -1;
        }
        this.isclosed = false;
        return super.open();
    }

    public boolean close() {
        if (this.isclosed) {
            return false;
        }
        FrameworkPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().setFocus();
        this.isclosed = true;
        return super.close();
    }

    public void setDocument(Document doc) {
        this.setDocument(doc, null);
    }

    public void setDocument(Document doc, Object sender) {
        String path;
        if (sender != null && !sender.equals(LabNotePlugin.getDefault().getBundle().getSymbolicName()) && (path = DataDomImpl.getFilePath((Document)doc)) != null && path.length() > 0) {
            this.isrejected = true;
            return;
        }
        if (this.document != null && this.ismodified && MessageDialog.openQuestion((Shell)this.getShell(), (String)LabNotePlugin.getString("LabnoteDialog.37"), (String)LabNotePlugin.getString("LabnoteDialog.38"))) {
            this.setValuesToDocument();
            this.saveDocument();
        }
        if (!this.isclosed) {
            this.setDialogTitle(false);
        }
        this.issaved = false;
        this.ismodified = false;
        this.document = doc;
        this.sender = sender;
        this.update();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setTitle(String title) {
        if (this.isclosed) {
            return;
        }
        this.titlevalue.setText(title);
    }

    public void setLabnoteDialogListener(LabnoteDialogListener l) {
        this.labnoteDialogListener = l;
    }

    public void update() {
        Document comment;
        String kwds;
        if (this.isclosed) {
            return;
        }
        this.modifyListenerEnabled(false);
        String title = LabNotePlugin.getTitle(this.document);
        if (title != null) {
            this.titlevalue.setText(title);
        }
        if ((kwds = LabNotePlugin.getKeywords(this.document)) != null) {
            this.kwdvalue.setText(kwds);
        }
        if ((comment = LabNotePlugin.getComment(this.document)) != null) {
            this.commentvalue.setDocument(comment);
        }
        String category = LabNotePlugin.getCategory(this.document);
        if (this.catvalue.getItemCount() == 0) {
            return;
        }
        int idx = this.catvalue.indexOf(category);
        if (idx >= 0) {
            this.catvalue.select(idx);
        } else {
            this.catvalue.select(0);
        }
        this.modifyListenerEnabled(true);
        this.setDialogTitle(false);
        if (this.drawer.isOpened()) {
            ArrayList<Document> docs = LabNotePlugin.getDocumentsByTheSameLastMod(this.document);
            this.drawer.setDocuments(docs);
        }
    }

    public void updateCategory() {
        if (this.isclosed) {
            return;
        }
        this.catvalue.removeAll();
        LabNotePlugin fp = LabNotePlugin.getDefault();
        ArrayList<Category> l = fp.getCategories();
        Collections.sort(l, new Comparator<Category>(){

            @Override
            public int compare(Category c1, Category c2) {
                return c1.name.compareTo(c2.name);
            }
        });
        int i = 0;
        while (i < l.size()) {
            this.catvalue.add(l.get((int)i).name);
            ++i;
        }
        this.update();
        this.catvalue.pack();
    }

    public void removeEmbeddedObjectByDocument(Document doc) {
        if (this.isclosed) {
            return;
        }
        this.commentvalue.removeEmbeddedObjectByDocument(doc);
    }
}

