/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.dialog;

import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SizeDialog
extends Dialog {
    public static final int APPLY = 0;
    public static final int CLOSE = 1;
    private StyledText textview;
    private EmbeddedObject eobject;
    Text rtext;

    public SizeDialog(Shell parent, int style, StyledText st, EmbeddedObject obj) {
        super(new Shell(parent, style));
        this.textview = st;
        this.eobject = obj;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(4, true);
        gl.marginHeight = 8;
        gl.marginWidth = 8;
        gl.horizontalSpacing = 4;
        gl.verticalSpacing = 8;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        Label wl = new Label(comp, 131072);
        GridData wgd = new GridData(768);
        wgd.horizontalAlignment = 131072;
        wl.setLayoutData((Object)wgd);
        wl.setText(LabNotePlugin.getString("SizeDialog.0"));
        Rectangle r = this.eobject.getObjectImage().getBounds();
        Point p = this.eobject.getSize();
        String ratio = String.valueOf(p == null ? 100 : p.x * 100 / r.width);
        this.rtext = new Text(comp, 4);
        this.rtext.setLayoutData((Object)new GridData(768));
        this.rtext.setText(String.valueOf(ratio));
        this.rtext.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!Character.isDigit(e.character) && e.character != '\b') {
                    e.doit = false;
                }
            }
        });
        Label percent = new Label(comp, 16384);
        GridData pgd = new GridData(768);
        pgd.horizontalAlignment = 16384;
        pgd.horizontalSpan = 2;
        percent.setLayoutData((Object)pgd);
        percent.setText("%");
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LabNotePlugin.getString("SizeDialog.2"), true);
        this.createButton(parent, 1, LabNotePlugin.getString("SizeDialog.3"), false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        if (buttonId == 0) {
            int val = Integer.parseInt(this.rtext.getText());
            if (val < 1 || 800 < val) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)LabNotePlugin.getString("SizeDialog.4"), (String)LabNotePlugin.getString("SizeDialog.5"));
                return;
            }
            Rectangle r = this.eobject.getObjectImage().getBounds();
            Point newsz = new Point(r.width * val / 100, r.height * val / 100);
            this.eobject.setSize(newsz);
            StyleRange sr = this.textview.getStyleRangeAtOffset(this.eobject.getOffset());
            sr.start = this.eobject.getOffset();
            sr.length = 1;
            sr.metrics = new GlyphMetrics(newsz.y, 0, newsz.x);
            this.textview.setStyleRange(sr);
            this.textview.redraw();
            this.textview.update();
        } else {
            this.close();
        }
    }
}

