/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.resources;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xindice.core.FaultCodes;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.sax.SAXEventGenerator;
import org.apache.xindice.xml.sax.SetContentHandler;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLResourceImpl
implements XMLResource {
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected String id;
    protected String documentId;
    protected Collection collection;
    protected String content;
    private SymbolTable symbols;
    private byte[] bytes;
    private boolean hasSaxNamespaces = true;
    private boolean hasSaxNamespacesPrefixes;

    public XMLResourceImpl(String id, Collection collection) {
        this(id, id, collection, null);
    }

    public XMLResourceImpl(String id, String documentId, Collection collection) {
        this(id, documentId, collection, null);
    }

    public XMLResourceImpl(String id, Collection collection, String content) {
        this(id, id, collection, content);
    }

    public XMLResourceImpl(String id, String documentId, Collection collection, String content) {
        this.collection = collection;
        this.id = id;
        this.documentId = documentId;
        this.content = content;
    }

    public XMLResourceImpl(String id, String documentId, Collection collection, SymbolTable syms, byte[] bytes) {
        this.collection = collection;
        this.id = id;
        this.documentId = documentId;
        this.symbols = syms;
        this.bytes = bytes;
    }

    public void setSAXFeature(String feature, boolean value) {
        if (SAX_NAMESPACES_FEATURE.equals(feature)) {
            this.hasSaxNamespaces = value;
        } else if (SAX_NAMESPACE_PREFIXES_FEATURE.equals(feature)) {
            this.hasSaxNamespacesPrefixes = value;
        }
    }

    public boolean getSAXFeature(String feature) {
        if (SAX_NAMESPACES_FEATURE.equals(feature)) {
            return this.hasSaxNamespaces;
        }
        if (SAX_NAMESPACE_PREFIXES_FEATURE.equals(feature)) {
            return this.hasSaxNamespacesPrefixes;
        }
        return false;
    }

    public XMLResourceImpl(String id, Collection collection, SymbolTable syms, byte[] bytes) {
        this(id, id, collection, syms, bytes);
    }

    public String getDocumentId() throws XMLDBException {
        return this.documentId;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value == null) {
            throw new XMLDBException(301);
        }
        if (!(value instanceof String)) {
            throw new XMLDBException(3);
        }
        this.content = (String)value;
        this.bytes = null;
    }

    public void setContentAsDOM(Node content) throws XMLDBException {
        if (content == null) {
            throw new XMLDBException(301);
        }
        this.content = TextWriter.toString(content);
        this.bytes = null;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new SetContentHandler(this);
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.collection;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public String getId() throws XMLDBException {
        return this.id;
    }

    public Object getContent() throws XMLDBException {
        if (this.bytes != null) {
            DocumentImpl doc = new DocumentImpl(this.bytes, this.symbols, null);
            return TextWriter.toString(doc);
        }
        return this.content;
    }

    public Node getContentAsDOM() throws XMLDBException {
        try {
            if (this.bytes != null) {
                return new DocumentImpl(this.bytes, this.symbols, null);
            }
            return DOMParser.toDocument(this.content);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        try {
            if (this.bytes != null) {
                SAXEventGenerator events = new SAXEventGenerator(this.symbols, this.bytes);
                events.setFeature(SAX_NAMESPACES_FEATURE, this.hasSaxNamespaces);
                events.setFeature(SAX_NAMESPACE_PREFIXES_FEATURE, this.hasSaxNamespacesPrefixes);
                events.setContentHandler(handler);
                if (handler instanceof ErrorHandler) {
                    events.setErrorHandler((ErrorHandler)((Object)handler));
                }
                events.start();
            } else if (this.content != null) {
                SAXParser sp = saxFactory.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                xr.setFeature(SAX_NAMESPACES_FEATURE, this.hasSaxNamespaces);
                xr.setFeature(SAX_NAMESPACE_PREFIXES_FEATURE, this.hasSaxNamespacesPrefixes);
                xr.setContentHandler(handler);
                if (handler instanceof ErrorHandler) {
                    xr.setErrorHandler((ErrorHandler)((Object)handler));
                }
                xr.parse(new InputSource(new StringReader(this.content)));
            }
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void setId(String name) {
        this.id = name;
    }

    static {
        saxFactory.setNamespaceAware(true);
    }
}

